/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.util.Hashtable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.HILayoutInfo;
import org.eclipse.swt.internal.carbon.HISideBinding;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.cocoa.Cocoa;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

class MozillaDelegate {
    Browser browser;
    Listener listener;
    boolean hasFocus;
    Callback callback3;
    static Hashtable handles = new Hashtable();
    static final boolean USE_COCOA_VIEW_CREATE = false;

    MozillaDelegate(Browser browser) {
        this.browser = browser;
    }

    static Browser findBrowser(int handle) {
        LONG value = (LONG)handles.get(new LONG(handle));
        if (value != null) {
            Display display = Display.getCurrent();
            return (Browser)display.findWidget(value.value);
        }
        return null;
    }

    static char[] mbcsToWcs(String codePage, byte[] buffer) {
        int encoding = OS.CFStringGetSystemEncoding();
        int cfstring = OS.CFStringCreateWithBytes(0, buffer, buffer.length, encoding, false);
        char[] chars = null;
        if (cfstring != 0) {
            int length = OS.CFStringGetLength(cfstring);
            chars = new char[length];
            if (length != 0) {
                CFRange range = new CFRange();
                range.length = length;
                OS.CFStringGetCharacters(cfstring, range, chars);
            }
            OS.CFRelease(cfstring);
        }
        return chars;
    }

    static byte[] wcsToMbcs(String codePage, String string, boolean terminate) {
        char[] chars = new char[string.length()];
        string.getChars(0, chars.length, chars, 0);
        int cfstring = OS.CFStringCreateWithCharacters(0, chars, chars.length);
        byte[] buffer = null;
        if (cfstring != 0) {
            CFRange range = new CFRange();
            range.length = chars.length;
            int encoding = OS.CFStringGetSystemEncoding();
            int[] size = new int[1];
            int numChars = OS.CFStringGetBytes(cfstring, range, encoding, (byte)63, true, null, 0, size);
            buffer = new byte[size[0] + (terminate ? 1 : 0)];
            if (numChars != 0) {
                numChars = OS.CFStringGetBytes(cfstring, range, encoding, (byte)63, true, buffer, size[0], size);
            }
            OS.CFRelease(cfstring);
        }
        return buffer;
    }

    public int eventProc3(int nextHandler, int theEvent, int userData) {
        this.browser.getShell().forceActive();
        ((Mozilla)this.browser.webBrowser).Activate();
        return -9874;
    }

    int getHandle() {
        int embedHandle = Cocoa.objc_msgSend(Cocoa.C_NSImageView, Cocoa.S_alloc);
        if (embedHandle == 0) {
            SWT.error(2);
        }
        NSRect r = new NSRect();
        embedHandle = Cocoa.objc_msgSend(embedHandle, Cocoa.S_initWithFrame, r);
        int[] outControl = new int[1];
        try {
            System.loadLibrary("frameembedding");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
        int rc = Cocoa.HIJavaViewCreateWithCocoaView(outControl, embedHandle);
        if (rc != 0 || outControl[0] == 0) {
            SWT.error(2);
        }
        int subHIView = outControl[0];
        HILayoutInfo newLayoutInfo = new HILayoutInfo();
        newLayoutInfo.version = 0;
        OS.HIViewGetLayoutInfo(subHIView, newLayoutInfo);
        HISideBinding biding = newLayoutInfo.binding.top;
        biding.toView = 0;
        biding.kind = 1;
        biding.offset = 0.0f;
        biding = newLayoutInfo.binding.left;
        biding.toView = 0;
        biding.kind = 1;
        biding.offset = 0.0f;
        biding = newLayoutInfo.binding.bottom;
        biding.toView = 0;
        biding.kind = (short)2;
        biding.offset = 0.0f;
        biding = newLayoutInfo.binding.right;
        biding.toView = 0;
        biding.kind = (short)2;
        biding.offset = 0.0f;
        OS.HIViewSetLayoutInfo(subHIView, newLayoutInfo);
        OS.HIViewChangeFeatures(subHIView, 0x2000000, 0);
        OS.HIViewSetVisible(subHIView, true);
        int parentHandle = this.browser.handle;
        OS.HIViewAddSubview(this.browser.handle, subHIView);
        CGRect rect = new CGRect();
        OS.HIViewGetFrame(parentHandle, rect);
        rect.y = 0.0f;
        rect.x = 0.0f;
        OS.HIViewSetFrame(subHIView, rect);
        handles.put(new LONG(embedHandle), new LONG(this.browser.handle));
        this.callback3 = new Callback(this, "eventProc3", 3);
        int[] mask = new int[]{1836021107, 1};
        int controlTarget = OS.GetControlEventTarget(subHIView);
        OS.InstallEventHandler(controlTarget, this.callback3.getAddress(), mask.length / 2, mask, subHIView, null);
        return embedHandle;
    }

    String getLibraryName() {
        return "libxpcom.dylib";
    }

    void handleFocus() {
        if (this.hasFocus) {
            return;
        }
        this.hasFocus = true;
        ((Mozilla)this.browser.webBrowser).Activate();
        this.browser.setFocus();
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == MozillaDelegate.this.browser) {
                    return;
                }
                ((Mozilla)MozillaDelegate.this.browser.webBrowser).Deactivate();
                MozillaDelegate.this.hasFocus = false;
                MozillaDelegate.this.browser.getDisplay().removeFilter(15, this);
                MozillaDelegate.this.browser.getShell().removeListener(27, this);
                MozillaDelegate.this.listener = null;
            }
        };
        this.browser.getDisplay().addFilter(15, this.listener);
        this.browser.getShell().addListener(27, this.listener);
    }

    void init() {
    }

    void onDispose(int embedHandle) {
        handles.remove(new LONG(embedHandle));
        if (this.callback3 != null) {
            this.callback3.dispose();
            this.callback3 = null;
        }
        if (this.listener != null) {
            this.browser.getDisplay().removeFilter(15, this.listener);
            this.browser.getShell().removeListener(27, this.listener);
            this.listener = null;
        }
        this.browser = null;
    }

    void setSize(int embedHandle, int width, int height) {
    }
}

