/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.ControlEditTextSelectionRec;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Combo
extends Composite {
    int menuHandle;
    int textLimit = LIMIT;
    String lastText = "";
    ControlEditTextSelectionRec selection;
    public static final int LIMIT = Integer.MAX_VALUE;

    public Combo(Composite parent, int style) {
        super(parent, Combo.checkStyle(style));
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        char[] buffer = new char[string.length()];
        string.getChars(0, buffer.length, buffer, 0);
        int ptr = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
        if (ptr == 0) {
            this.error(14);
        }
        int result = (this.style & 8) != 0 ? OS.AppendMenuItemTextWithCFString(this.menuHandle, ptr, 0, 0, null) : OS.HIComboBoxAppendTextItem(this.handle, ptr, null);
        OS.CFRelease(ptr);
        if (result != 0) {
            this.error(14);
        }
    }

    public void add(String string, int index) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int count = this.getItemCount();
        if (index < 0 || index > count) {
            this.error(6);
        }
        char[] buffer = new char[string.length()];
        string.getChars(0, buffer.length, buffer, 0);
        int ptr = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
        if (ptr == 0) {
            this.error(14);
        }
        int result = (this.style & 8) != 0 ? OS.InsertMenuItemTextWithCFString(this.menuHandle, ptr, (short)index, 0, 0) : OS.HIComboBoxInsertTextItemAtIndex(this.handle, index, ptr);
        OS.CFRelease(ptr);
        if (result != 0) {
            this.error(14);
        }
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    int callFocusEventHandler(int nextHandler, int theEvent) {
        short[] part = new short[1];
        if ((this.style & 8) == 0) {
            OS.GetEventParameter(theEvent, 1668313716, 1668313716, null, 2, null, part);
            if (part[0] == 0) {
                this.selection = new ControlEditTextSelectionRec();
                OS.GetControlData(this.handle, (short)0, 1936026725, 4, this.selection, null);
            }
        }
        int result = super.callFocusEventHandler(nextHandler, theEvent);
        if ((this.style & 8) == 0 && part[0] != 0 && this.selection != null) {
            OS.SetControlData(this.handle, 0, 1936026725, 4, this.selection);
            this.selection = null;
        }
        return result;
    }

    static int checkStyle(int style) {
        style &= 0xFFFFF7FF;
        style &= 0xFFFFFCFF;
        if (((style = Combo.checkBits(style, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return style & 0xFFFFFFF7;
        }
        return style;
    }

    void checkSelection() {
        if ((this.style & 8) != 0) {
            return;
        }
        String newText = this.getText();
        if (newText.equals(this.lastText)) {
            return;
        }
        if (this.hooks(25) || this.filters(25)) {
            this.setText(this.lastText, false);
            newText = this.verifyText(newText, 0, this.lastText.length(), null);
            if (newText == null) {
                return;
            }
            this.setText(newText, false);
        } else {
            this.lastText = newText;
        }
        this.sendEvent(24);
        if (this.isDisposed()) {
            return;
        }
        int index = this.indexOf(newText);
        if (index != -1) {
            this.postEvent(13);
        }
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clearSelection() {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            Point selection = this.getSelection();
            selection.y = selection.x;
            this.setSelection(selection);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        int[] ptr = new int[1];
        if ((this.style & 8) != 0) {
            int index = OS.GetControlValue(this.handle) - 1;
            OS.CopyMenuItemTextAsCFString(this.menuHandle, (short)(index + 1), ptr);
        } else {
            OS.GetControlData(this.handle, (short)5, 1667658612, 4, ptr, null);
        }
        Point size = this.textExtent(ptr[0], 0);
        if (ptr[0] != 0) {
            OS.CFRelease(ptr[0]);
        }
        width = Math.max(width, size.x);
        height = Math.max(height, size.y);
        int count = (this.style & 8) != 0 ? OS.CountMenuItems(this.menuHandle) : OS.HIComboBoxGetItemCount(this.handle);
        int i = 0;
        while (i < count) {
            int result = (this.style & 8) != 0 ? OS.CopyMenuItemTextAsCFString(this.menuHandle, (short)(i + 1), ptr) : OS.HIComboBoxCopyTextItemAtIndex(this.handle, i, ptr);
            if (result == 0) {
                size = this.textExtent(ptr[0], 0);
                width = Math.max(width, size.x);
                OS.CFRelease(ptr[0]);
            }
            ++i;
        }
        int[] metric = new int[1];
        if ((this.style & 8) != 0) {
            OS.GetThemeMetric(22, metric);
            width += metric[0];
            width += 13;
        } else {
            OS.GetThemeMetric(74, metric);
            width += metric[0];
        }
        OS.GetThemeMetric(4, metric);
        width += metric[0] * 2;
        height += metric[0] * 2;
        Rect inset = this.getInset();
        width += inset.left + inset.right;
        height += inset.top + inset.bottom;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    public void copy() {
        this.checkWidget();
        Point selection = this.getSelection();
        if (selection.x == selection.y) {
            return;
        }
        this.copyToClipboard(this.getText(selection.x, selection.y));
    }

    void createHandle() {
        if ((this.style & 8) != 0) {
            int[] outControl = new int[1];
            int window = OS.GetControlOwner(this.parent.handle);
            OS.CreatePopupButtonControl(window, null, 0, (short)-12345, false, (short)0, (short)0, 0, outControl);
            if (outControl[0] == 0) {
                this.error(2);
            }
            this.handle = outControl[0];
            int[] menuRef = new int[1];
            OS.CreateNewMenu((short)0, 0, menuRef);
            if (menuRef[0] == 0) {
                this.error(2);
            }
            this.menuHandle = menuRef[0];
            OS.SetControlPopupMenuHandle(this.handle, this.menuHandle);
            OS.SetControl32BitMaximum(this.handle, Short.MAX_VALUE);
        } else {
            int[] outControl = new int[1];
            CGRect rect = new CGRect();
            int inAttributes = 8;
            OS.HIComboBoxCreate(rect, 0, null, 0, inAttributes, outControl);
            if (outControl[0] == 0) {
                this.error(2);
            }
            this.handle = outControl[0];
            OS.SetControlData(this.handle, 5, 1684238964, 4, new byte[1]);
            OS.HIViewSetVisible(this.handle, true);
        }
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        Point selection = this.getSelection();
        if (selection.x == selection.y) {
            return;
        }
        int start = selection.x;
        int end = selection.y;
        String text = this.getText();
        String leftText = text.substring(0, start);
        String rightText = text.substring(end, text.length());
        String newText = "";
        if ((this.hooks(25) || this.filters(25)) && (newText = this.verifyText(newText, start, end, null)) == null) {
            return;
        }
        char[] buffer = new char[newText.length()];
        newText.getChars(0, buffer.length, buffer, 0);
        this.copyToClipboard(buffer);
        this.setText(String.valueOf(leftText) + newText + rightText, false);
        this.setSelection(new Point(start += newText.length(), start));
        this.sendEvent(24);
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index == -1) {
            return;
        }
        if (index == this.getSelectionIndex()) {
            if ((this.style & 8) != 0) {
                OS.SetControl32BitValue(this.handle, 0);
                this.sendEvent(24);
            } else {
                this.setText("");
            }
        }
    }

    public void deselectAll() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            OS.SetControl32BitValue(this.handle, 0);
            this.sendEvent(24);
        } else {
            this.setText("");
        }
    }

    void destroyWidget() {
        if ((this.getShell().state & 0x10000) != 0) {
            super.destroyWidget();
        } else {
            this.releaseHandle();
        }
    }

    public String getItem(int index) {
        this.checkWidget();
        int count = this.getItemCount();
        if (index < 0 || index >= count) {
            this.error(6);
        }
        int[] ptr = new int[1];
        int result = (this.style & 8) != 0 ? OS.CopyMenuItemTextAsCFString(this.menuHandle, (short)(index + 1), ptr) : OS.HIComboBoxCopyTextItemAtIndex(this.handle, index, ptr);
        if (result != 0) {
            this.error(8);
        }
        int length = OS.CFStringGetLength(ptr[0]);
        char[] buffer = new char[length];
        CFRange range = new CFRange();
        range.length = length;
        OS.CFStringGetCharacters(ptr[0], range, buffer);
        OS.CFRelease(ptr[0]);
        return new String(buffer);
    }

    public int getItemCount() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return OS.CountMenuItems(this.menuHandle);
        }
        return OS.HIComboBoxGetItemCount(this.handle);
    }

    public int getItemHeight() {
        this.checkWidget();
        return 26;
    }

    public String[] getItems() {
        this.checkWidget();
        int count = this.getItemCount();
        String[] result = new String[count];
        int i = 0;
        while (i < count) {
            result[i] = this.getItem(i);
            ++i;
        }
        return result;
    }

    int getMininumHeight() {
        return this.getTextHeight();
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Point getSelection() {
        ControlEditTextSelectionRec selection;
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return new Point(0, this.getCharCount());
        }
        if (this.selection != null) {
            selection = this.selection;
        } else {
            selection = new ControlEditTextSelectionRec();
            OS.GetControlData(this.handle, (short)5, 1936026725, 4, selection, null);
        }
        return new Point(selection.selStart, selection.selEnd);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return OS.GetControlValue(this.handle) - 1;
        }
        return this.indexOf(this.getText());
    }

    public String getText() {
        this.checkWidget();
        return new String(this.getText(0, -1));
    }

    char[] getText(int start, int end) {
        int result;
        int[] ptr = new int[1];
        if ((this.style & 8) != 0) {
            int index = OS.GetControlValue(this.handle) - 1;
            result = OS.CopyMenuItemTextAsCFString(this.menuHandle, (short)(index + 1), ptr);
        } else {
            int[] actualSize = new int[1];
            result = OS.GetControlData(this.handle, (short)5, 1667658612, 4, ptr, actualSize);
        }
        if (result != 0) {
            return new char[0];
        }
        CFRange range = new CFRange();
        range.location = start;
        if (end == -1) {
            int length = OS.CFStringGetLength(ptr[0]);
            range.length = length - start;
        } else {
            range.length = end - start;
        }
        char[] buffer = new char[range.length];
        OS.CFStringGetCharacters(ptr[0], range, buffer);
        OS.CFRelease(ptr[0]);
        return buffer;
    }

    public int getTextHeight() {
        this.checkWidget();
        return 26;
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return this.getItemCount();
        }
        int[] buffer = new int[1];
        OS.GetControlData(this.handle, (short)0, 1667395177, 4, buffer, null);
        return buffer[0];
    }

    void hookEvents() {
        super.hookEvents();
        if ((this.style & 8) != 0) {
            int commandProc = this.display.commandProc;
            int[] mask = new int[]{1668113523, 1};
            int menuTarget = OS.GetMenuEventTarget(this.menuHandle);
            OS.InstallEventHandler(menuTarget, commandProc, mask.length / 2, mask, this.handle, null);
        }
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int count = this.getItemCount();
        if (start < 0 || start >= count) {
            return -1;
        }
        int i = start;
        while (i < count) {
            if (string.equals(this.getItem(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    int getCharCount() {
        int result;
        int[] ptr = new int[1];
        if ((this.style & 8) != 0) {
            int index = OS.GetControlValue(this.handle) - 1;
            result = OS.CopyMenuItemTextAsCFString(this.menuHandle, (short)(index + 1), ptr);
        } else {
            int[] actualSize = new int[1];
            result = OS.GetControlData(this.handle, (short)5, 1667658612, 4, ptr, actualSize);
        }
        if (result != 0) {
            return 0;
        }
        int length = OS.CFStringGetLength(ptr[0]);
        OS.CFRelease(ptr[0]);
        return length;
    }

    Rect getInset() {
        return this.display.comboInset;
    }

    int kEventControlActivate(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlActivate(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        return 0;
    }

    int kEventProcessCommand(int nextHandler, int theEvent, int userData) {
        int result = super.kEventProcessCommand(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        this.postEvent(24);
        if (this.isDisposed()) {
            return -9874;
        }
        this.postEvent(13);
        return -9874;
    }

    int kEventRawKeyPressed(int nextHandler, int theEvent, int userData) {
        if (OS.VERSION < 4160) {
            int[] keyCode = new int[1];
            OS.GetEventParameter(theEvent, 1801678692, 1835100014, null, keyCode.length * 4, null, keyCode);
            switch (keyCode[0]) {
                case 125: 
                case 126: {
                    if (this.sendKeyEvent(1, theEvent)) break;
                    return 0;
                }
            }
        }
        return -9874;
    }

    int kEventControlSetFocusPart(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlSetFocusPart(nextHandler, theEvent, userData);
        if (result == 0 && (this.style & 8) == 0) {
            short[] part = new short[1];
            OS.GetEventParameter(theEvent, 1668313716, 1668313716, null, 2, null, part);
            if (part[0] != 0) {
                this.display.focusCombo = this;
            }
        }
        return result;
    }

    int kEventUnicodeKeyPressed(int nextHandler, int theEvent, int userData) {
        int result = super.kEventUnicodeKeyPressed(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        int[] keyboardEvent = new int[1];
        OS.GetEventParameter(theEvent, 1953721189, 1702261350, null, keyboardEvent.length * 4, null, keyboardEvent);
        int[] keyCode = new int[1];
        OS.GetEventParameter(keyboardEvent[0], 1801678692, 1835100014, null, keyCode.length * 4, null, keyCode);
        switch (keyCode[0]) {
            case 36: 
            case 76: {
                this.postEvent(14);
            }
        }
        result = OS.CallNextEventHandler(nextHandler, theEvent);
        this.lastText = this.getText();
        return result;
    }

    public void paste() {
        int charCount;
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        Point selection = this.getSelection();
        int start = selection.x;
        int end = selection.y;
        String text = this.getText();
        String leftText = text.substring(0, start);
        String rightText = text.substring(end, text.length());
        String newText = this.getClipboardText();
        if ((this.hooks(25) || this.filters(25)) && (newText = this.verifyText(newText, start, end, null)) == null) {
            return;
        }
        if (this.textLimit != LIMIT && (charCount = text.length()) - (end - start) + newText.length() > this.textLimit) {
            newText = newText.substring(0, this.textLimit - charCount + (end - start));
        }
        this.setText(String.valueOf(leftText) + newText + rightText, false);
        this.setSelection(new Point(start += newText.length(), start));
        this.sendEvent(24);
    }

    void releaseHandle() {
        if ((this.getShell().state & 0x10000) == 0) {
            this.display.addToDisposeWindow(this.handle);
        }
        super.releaseHandle();
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.display.focusCombo == this) {
            this.display.focusCombo = null;
        }
        if (this.menuHandle != 0) {
            OS.DisposeMenu(this.menuHandle);
        }
        this.menuHandle = 0;
    }

    public void remove(int index) {
        this.checkWidget();
        if (index == -1) {
            this.error(6);
        }
        int count = this.getItemCount();
        if (index < 0 || index >= count) {
            this.error(6);
        }
        if ((this.style & 8) != 0) {
            OS.DeleteMenuItems(this.menuHandle, (short)(index + 1), 1);
            if (index == OS.GetControlValue(this.handle) - 1) {
                OS.SetControl32BitValue(this.handle, 0);
            }
        } else {
            OS.HIComboBoxRemoveItemAtIndex(this.handle, index);
        }
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        int count = this.getItemCount();
        if (start < 0 || start > end || end >= count) {
            this.error(6);
        }
        int newEnd = Math.min(end, count - 1);
        if ((this.style & 8) != 0) {
            OS.DeleteMenuItems(this.menuHandle, (short)(start + 1), newEnd - start + 1);
            int index = OS.GetControlValue(this.handle) - 1;
            if (start <= index && index <= end) {
                OS.SetControl32BitValue(this.handle, 0);
            }
        } else {
            int i = newEnd;
            while (i >= start) {
                OS.HIComboBoxRemoveItemAtIndex(this.handle, i);
                --i;
            }
        }
    }

    public void remove(String string) {
        int index;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((index = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(index);
    }

    public void removeAll() {
        this.checkWidget();
        int count = this.getItemCount();
        if ((this.style & 8) != 0) {
            OS.DeleteMenuItems(this.menuHandle, (short)1, count);
            OS.SetControl32BitValue(this.handle, 0);
        } else {
            this.setText("", true);
            if (count > 0) {
                int i = count - 1;
                while (i >= 0) {
                    OS.HIComboBoxRemoveItemAtIndex(this.handle, i);
                    --i;
                }
            }
        }
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    public void select(int index) {
        this.checkWidget();
        int count = this.getItemCount();
        if (index >= 0 && index < count) {
            if ((this.style & 8) != 0) {
                OS.SetControl32BitValue(this.handle, index + 1);
                this.sendEvent(24);
            } else {
                this.setText(this.getItem(index), true);
            }
        }
    }

    boolean sendKeyEvent(int type, Event event) {
        if (!super.sendKeyEvent(type, event)) {
            return false;
        }
        if (type != 1) {
            return true;
        }
        if ((this.style & 8) != 0) {
            return true;
        }
        if (event.character == '\u0000') {
            return true;
        }
        String oldText = "";
        String newText = "";
        if (this.hooks(25) || this.filters(25)) {
            int charCount = this.getCharCount();
            Point selection = this.getSelection();
            int start = selection.x;
            int end = selection.y;
            switch (event.character) {
                case '\b': {
                    if (start != end) break;
                    if (start == 0) {
                        return true;
                    }
                    start = Math.max(0, start - 1);
                    break;
                }
                case '\u007f': {
                    if (start != end) break;
                    if (start == charCount) {
                        return true;
                    }
                    end = Math.min(end + 1, charCount);
                    break;
                }
                case '\r': {
                    return true;
                }
                default: {
                    if (event.character != '\t' && event.character < ' ') {
                        return true;
                    }
                    oldText = new String(new char[]{event.character});
                }
            }
            if ((newText = this.verifyText(oldText, start, end, event)) == null) {
                return false;
            }
            if (charCount - (end - start) + newText.length() > this.textLimit) {
                return false;
            }
            if (newText != oldText) {
                String text = this.getText();
                String leftText = text.substring(0, start);
                String rightText = text.substring(end, text.length());
                this.setText(String.valueOf(leftText) + newText + rightText, false);
                this.setSelection(new Point(start += newText.length(), start));
            }
        }
        this.postEvent(24);
        return newText == oldText;
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        if ((this.style & 8) != 0) {
            return super.setBounds(x, y, width, height, move, resize, events);
        }
        Rect inset = this.getInset();
        Rectangle rect = this.getBounds();
        int oldWidth = rect.width - inset.left - inset.right;
        int result = super.setBounds(x, y, width, height, move, resize, events);
        if (oldWidth == 0 && width > 0) {
            Point selection = this.getSelection();
            this.setText(this.getText(), false);
            this.setSelection(selection);
        }
        return result;
    }

    public void setItem(int index, String string) {
        int result;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int count = this.getItemCount();
        if (index < 0 || index >= count) {
            this.error(6);
        }
        char[] buffer = new char[string.length()];
        string.getChars(0, buffer.length, buffer, 0);
        int ptr = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
        if (ptr == 0) {
            this.error(14);
        }
        if ((this.style & 8) != 0) {
            result = OS.SetMenuItemTextWithCFString(this.menuHandle, (short)(index + 1), ptr);
        } else {
            result = OS.HIComboBoxInsertTextItemAtIndex(this.handle, index, ptr);
            OS.HIComboBoxRemoveItemAtIndex(this.handle, index + 1);
        }
        OS.CFRelease(ptr);
        if (result != 0) {
            this.error(14);
        }
    }

    public void setItems(String[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        int i = 0;
        while (i < items.length) {
            if (items[i] == null) {
                this.error(5);
            }
            ++i;
        }
        this.removeAll();
        if (items.length == 0) {
            return;
        }
        i = 0;
        while (i < items.length) {
            int result;
            String string = items[i];
            char[] buffer = new char[string.length()];
            string.getChars(0, buffer.length, buffer, 0);
            int ptr = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
            if (ptr == 0) {
                this.error(14);
            }
            if ((this.style & 8) != 0) {
                result = OS.AppendMenuItemTextWithCFString(this.menuHandle, ptr, 0, 0, null);
            } else {
                int[] outIndex = new int[1];
                result = OS.HIComboBoxAppendTextItem(this.handle, ptr, outIndex);
            }
            OS.CFRelease(ptr);
            if (result != 0) {
                this.error(14);
            }
            ++i;
        }
    }

    void setListVisible(boolean visible) {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            OS.HIComboBoxSetListVisible(this.handle, visible);
        }
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            this.error(4);
        }
        if ((this.style & 8) == 0) {
            int length = this.getCharCount();
            int start = selection.x;
            int end = selection.y;
            ControlEditTextSelectionRec sel = new ControlEditTextSelectionRec();
            sel.selStart = (short)Math.min(Math.max(Math.min(start, end), 0), length);
            sel.selEnd = (short)Math.min(Math.max(Math.max(start, end), 0), length);
            if (this.hasFocus()) {
                OS.SetControlData(this.handle, 5, 1936026725, 4, sel);
            } else {
                this.selection = sel;
            }
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.setText(string, true);
    }

    void setText(String string, boolean notify) {
        if (notify && (this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, this.getCharCount(), null)) == null) {
            return;
        }
        if ((this.style & 8) != 0) {
            int index = this.indexOf(string);
            if (index != -1 && index != this.getSelectionIndex()) {
                this.select(index);
                if (notify) {
                    this.sendEvent(24);
                }
            }
        } else {
            char[] buffer = new char[Math.min(string.length(), this.textLimit)];
            string.getChars(0, buffer.length, buffer, 0);
            int ptr = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
            if (ptr == 0) {
                this.error(13);
            }
            this.lastText = string;
            OS.SetControlData(this.handle, 5, 1667658612, 4, new int[]{ptr});
            OS.CFRelease(ptr);
            this.selection = null;
            if (notify) {
                this.sendEvent(24);
            }
        }
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        this.textLimit = limit;
    }

    public void setVisibleItemCount(int count) {
        this.checkWidget();
        if (count < 0) {
            return;
        }
        if ((this.style & 8) == 0) {
            OS.SetControlData(this.handle, 0, 1667395177, 4, new int[]{count});
        }
    }

    String verifyText(String string, int start, int end, Event keyEvent) {
        Event event = new Event();
        event.text = string;
        event.start = start;
        event.end = end;
        if (keyEvent != null) {
            event.character = keyEvent.character;
            event.keyCode = keyEvent.keyCode;
            event.stateMask = keyEvent.stateMask;
        }
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

