/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.el.diagnostics;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.validation.internal.ELValidationPreferences;
import org.eclipse.jst.jsf.validation.internal.el.diagnostics.MyLocalizedMessage;
import org.eclipse.wst.validation.internal.core.Message;

public final class ValidationMessageFactory {
    public static Message createFromDiagnostic(Diagnostic diagnostic, int offset, int length, IFile file, ELValidationPreferences prefs) {
        int severity = prefs.getDiagnosticSeverity(diagnostic.getCode());
        MyLocalizedMessage message = new MyLocalizedMessage(ValidationMessageFactory.convertSeverity(severity), diagnostic.getMessage(), (IResource)file, diagnostic.getCode());
        message.setOffset(offset);
        message.setLength(length);
        return message;
    }

    private static int convertSeverity(int severity) {
        switch (severity) {
            case 4: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 4;
            }
        }
        return 0;
    }

    private ValidationMessageFactory() {
    }
}

