/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.breakpoint;

import java.text.MessageFormat;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.breakpoint.provider.PHPBreakpointProvider;
import org.eclipse.ui.texteditor.IMarkerUpdater;

public class BreakpointMarkerUpdater
implements IMarkerUpdater {
    public String[] getAttribute() {
        return new String[]{"lineNumber", "message"};
    }

    public String getMarkerType() {
        return "org.eclipse.php.debug.core.PHPConditionalBreakpointMarker";
    }

    public boolean updateMarker(IMarker iMarker, IDocument iDocument, Position position) {
        block4: {
            int n;
            block5: {
                if (position.isDeleted()) {
                    return false;
                }
                n = iDocument.getLineOfOffset(position.offset) + 1;
                int n2 = PHPBreakpointProvider.getValidPosition(iDocument, n);
                if (n2 == -1) break block4;
                n = iDocument.getLineOfOffset(n2) + 1;
                iMarker.setAttribute("message", (Object)MessageFormat.format(PHPDebugCoreMessages.LineBreakPointMessage_1, iMarker.getResource().getName(), n));
                if (iMarker.getAttribute("lineNumber", -1) != n) break block5;
                return true;
            }
            try {
                iMarker.setAttribute("lineNumber", n);
                return true;
            }
            catch (Exception exception) {
                Logger.logException(exception);
            }
        }
        return false;
    }
}

