/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.encoding.ContentTypeEncodingPreferences;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.ui.internal.IReleasable;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMContent;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMEntityDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMGroup;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNodeList;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQueryAction;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMNamespaceHelper;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.contentassist.AttributeContextInformationPresenter;
import org.eclipse.wst.xml.ui.internal.contentassist.AttributeContextInformationProvider;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.eclipse.wst.xml.ui.internal.contentassist.SimpleCMElementDeclaration;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLContentModelGenerator;
import org.eclipse.wst.xml.ui.internal.editor.CMImageUtil;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;
import org.eclipse.wst.xml.ui.internal.preferences.XMLUIPreferenceNames;
import org.eclipse.wst.xml.ui.internal.taginfo.MarkupTagInfoProvider;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractContentAssistProcessor
implements IContentAssistProcessor,
IReleasable {
    protected static final String INTERNALERROR = XMLUIMessages.SEVERE_internal_error_occu_UI_;
    protected static final String UNKNOWN_ATTR = XMLUIMessages.No_known_attribute__UI_;
    protected static final String UNKNOWN_CONTEXT = XMLUIMessages.Content_Assist_not_availab_UI_;
    protected char[] completionProposalAutoActivationCharacters = null;
    protected char[] contextInformationAutoActivationCharacters = null;
    private AttributeContextInformationProvider fAttributeInfoProvider = null;
    private AttributeContextInformationPresenter fContextInformationPresenter = null;
    protected String fErrorMessage = null;
    protected XMLContentModelGenerator fGenerator;
    protected MarkupTagInfoProvider fInfoProvider = null;
    protected ITextViewer fTextViewer = null;
    private final boolean showValues = true;

    public AbstractContentAssistProcessor() {
        this.init();
    }

    protected void addAttributeNameProposals(ContentAssistRequest contentAssistRequest) {
        IDOMNode node = (IDOMNode)contentAssistRequest.getNode();
        IStructuredDocumentRegion sdRegion = contentAssistRequest.getDocumentRegion();
        CMElementDeclaration elementDecl = this.getCMElementDeclaration((Node)node);
        if (elementDecl != null) {
            CMNamedNodeMap attributes = elementDecl.getAttributes();
            String matchString = contentAssistRequest.getMatchString();
            boolean attrAtLocationHasValue = false;
            NamedNodeMap attrs = node.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                AttrImpl existingAttr = (AttrImpl)attrs.item(i);
                ITextRegion name = existingAttr.getNameRegion();
                if (sdRegion.getStartOffset(name) <= contentAssistRequest.getReplacementBeginPosition() && sdRegion.getStartOffset(name) + name.getLength() >= contentAssistRequest.getReplacementBeginPosition() + contentAssistRequest.getReplacementLength() && existingAttr.getValueRegion() != null) {
                    attrAtLocationHasValue = true;
                    break;
                }
                ++i;
            }
            if (attributes != null) {
                i = 0;
                while (i < attributes.getLength()) {
                    boolean showAttribute;
                    CMAttributeDeclaration attrDecl = (CMAttributeDeclaration)attributes.item(i);
                    int isRequired = 0;
                    if (attrDecl.getUsage() == 2) {
                        isRequired = 10;
                    }
                    showAttribute = (showAttribute = true) && this.beginsWith(this.getRequiredName((Node)node, (CMNode)attrDecl), matchString.trim());
                    AttrImpl attr = (AttrImpl)node.getAttributes().getNamedItem(this.getRequiredName((Node)node, (CMNode)attrDecl));
                    ITextRegion nameRegion = attr != null ? attr.getNameRegion() : null;
                    boolean bl = showAttribute = showAttribute && (attr == null || nameRegion != null && sdRegion.getStartOffset(nameRegion) <= contentAssistRequest.getReplacementBeginPosition() && sdRegion.getStartOffset(nameRegion) + nameRegion.getLength() >= contentAssistRequest.getReplacementBeginPosition() + contentAssistRequest.getReplacementLength());
                    if (showAttribute) {
                        Image attrImage = CMImageUtil.getImage((CMNode)attrDecl);
                        if (attrImage == null) {
                            attrImage = isRequired > 0 ? XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/att_req_obj.gif") : XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/attribute_obj.gif");
                        }
                        String proposedText = null;
                        String proposedInfo = this.getAdditionalInfo((CMNode)elementDecl, (CMNode)attrDecl);
                        CustomCompletionProposal proposal = null;
                        if (attrAtLocationHasValue) {
                            proposedText = this.getRequiredName((Node)node, (CMNode)attrDecl);
                            proposal = new CustomCompletionProposal(proposedText, contentAssistRequest.getReplacementBeginPosition(), contentAssistRequest.getReplacementLength(), proposedText.length(), attrImage, proposedText, null, proposedInfo, 900 + isRequired, true);
                        } else {
                            Attr existingAttrNode = (Attr)node.getAttributes().getNamedItem(this.getRequiredName((Node)node, (CMNode)attrDecl));
                            String value = null;
                            if (existingAttrNode != null) {
                                value = existingAttrNode.getNodeValue();
                            }
                            proposedText = value != null && value.length() > 0 ? this.getRequiredName((Node)node, (CMNode)attrDecl) : this.getRequiredText((Node)node, attrDecl);
                            proposal = new CustomCompletionProposal(proposedText, contentAssistRequest.getReplacementBeginPosition(), contentAssistRequest.getReplacementLength(), attrDecl.getNodeName().length() + 2, attrImage, proposedText.indexOf("\"\"") < 0 ? proposedText : this.getRequiredName((Node)node, (CMNode)attrDecl), null, proposedInfo, 900 + isRequired);
                        }
                        contentAssistRequest.addProposal((ICompletionProposal)proposal);
                    }
                    ++i;
                }
            }
        } else {
            this.setErrorMessage(NLS.bind((String)XMLUIMessages.Element__is_unknown, (Object[])new Object[]{node.getNodeName()}));
        }
    }

    protected void addAttributeValueProposals(ContentAssistRequest contentAssistRequest) {
        IDOMNode node = (IDOMNode)contentAssistRequest.getNode();
        IStructuredDocumentRegion open = node.getFirstStructuredDocumentRegion();
        ITextRegionList openRegions = open.getRegions();
        int i = openRegions.indexOf(contentAssistRequest.getRegion());
        if (i < 0) {
            return;
        }
        ITextRegion nameRegion = null;
        while (i >= 0) {
            if ((nameRegion = openRegions.get(i--)).getType() == "XML_TAG_ATTRIBUTE_NAME") break;
        }
        if (nameRegion != null) {
            CMElementDeclaration elementDecl = this.getCMElementDeclaration((Node)node);
            String attributeName = open.getText(nameRegion);
            CMAttributeDeclaration attrDecl = null;
            if (elementDecl != null) {
                CMNamedNodeMap attributes = elementDecl.getAttributes();
                String noprefixName = DOMNamespaceHelper.getUnprefixedName((String)attributeName);
                if (attributes != null && (attrDecl = (CMAttributeDeclaration)attributes.getNamedItem(noprefixName)) == null) {
                    attrDecl = (CMAttributeDeclaration)attributes.getNamedItem(attributeName);
                }
                if (attrDecl == null) {
                    this.setErrorMessage(UNKNOWN_ATTR, attributeName);
                }
            }
            String currentValue = node.getAttributes().getNamedItem(attributeName).getNodeValue();
            String proposedInfo = null;
            Image image = CMImageUtil.getImage(attrDecl);
            if (image == null) {
                image = attrDecl != null && attrDecl.getUsage() == 2 ? XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/att_req_obj.gif") : XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/attribute_obj.gif");
            }
            if (attrDecl != null && attrDecl.getAttrType() != null) {
                String value;
                proposedInfo = this.getAdditionalInfo((CMNode)elementDecl, (CMNode)attrDecl);
                List possibleValues = this.getPossibleDataTypeValues((Node)node, attrDecl);
                if (possibleValues.size() > 0) {
                    boolean existingComplicatedValue;
                    String matchString = contentAssistRequest.getMatchString();
                    if (matchString == null) {
                        matchString = "";
                    }
                    if (matchString.length() > 0 && (matchString.startsWith("\"") || matchString.startsWith("'"))) {
                        matchString = matchString.substring(1);
                    }
                    boolean currentValid = false;
                    boolean bl = existingComplicatedValue = contentAssistRequest.getRegion() != null && contentAssistRequest.getRegion() instanceof ITextRegionContainer;
                    if (!existingComplicatedValue) {
                        Iterator j = possibleValues.iterator();
                        while (j.hasNext()) {
                            String possibleValue = (String)j.next();
                            boolean bl2 = currentValid = currentValid || possibleValue.equals(currentValue);
                            if (matchString.length() != 0 && !possibleValue.startsWith(matchString)) continue;
                            String rString = "\"" + possibleValue + "\"";
                            int rOffset = contentAssistRequest.getReplacementBeginPosition();
                            int rLength = contentAssistRequest.getReplacementLength();
                            int cursorAfter = possibleValue.length() + 1;
                            String displayString = "\"" + possibleValue + "\"";
                            CustomCompletionProposal proposal = new CustomCompletionProposal(rString, rOffset, rLength, cursorAfter, image, displayString, null, proposedInfo, 800);
                            contentAssistRequest.addProposal((ICompletionProposal)proposal);
                        }
                    }
                } else if ((attrDecl.getUsage() == 3 || attrDecl.getAttrType().getImpliedValueKind() == 2) && attrDecl.getAttrType().getImpliedValue() != null && (value = attrDecl.getAttrType().getImpliedValue()) != null && value.length() > 0) {
                    String rValue = "\"" + value + "\"";
                    CustomCompletionProposal proposal = new CustomCompletionProposal(rValue, contentAssistRequest.getReplacementBeginPosition(), contentAssistRequest.getReplacementLength(), rValue.length() + 1, image, rValue, null, proposedInfo, 800);
                    contentAssistRequest.addProposal((ICompletionProposal)proposal);
                    if (currentValue.length() > 0 && !value.equals(currentValue)) {
                        rValue = "\"" + currentValue + "\"";
                        proposal = new CustomCompletionProposal(rValue, contentAssistRequest.getReplacementBeginPosition(), contentAssistRequest.getReplacementLength(), rValue.length() + 1, image, rValue, null, proposedInfo, 800);
                        contentAssistRequest.addProposal((ICompletionProposal)proposal);
                    }
                }
            } else {
                proposedInfo = this.getAdditionalInfo(null, (CMNode)elementDecl);
                CustomCompletionProposal proposal = null;
                if (currentValue != null && currentValue.length() > 0) {
                    String rValue = "\"" + currentValue + "\"";
                    proposal = new CustomCompletionProposal(rValue, contentAssistRequest.getReplacementBeginPosition(), contentAssistRequest.getReplacementLength(), 1, image, rValue, null, proposedInfo, 800);
                    contentAssistRequest.addProposal((ICompletionProposal)proposal);
                }
            }
        } else {
            this.setErrorMessage(UNKNOWN_CONTEXT);
        }
    }

    protected void addCommentProposal(ContentAssistRequest contentAssistRequest) {
        contentAssistRequest.addProposal((ICompletionProposal)new CustomCompletionProposal("<!--  -->", contentAssistRequest.getReplacementBeginPosition(), contentAssistRequest.getReplacementLength(), 5, XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/comment_obj.gif"), NLS.bind((String)XMLUIMessages.Comment__, (Object[])new Object[]{" <!--  -->"}), null, null, 100));
    }

    protected void addContent(List contentList, CMContent content) {
        if (content == null) {
            return;
        }
        if (content instanceof CMGroup) {
            CMNodeList children = ((CMGroup)content).getChildNodes();
            if (children == null) {
                return;
            }
            int i = 0;
            while (i < children.getLength()) {
                CMNode child = children.item(i);
                if (child.getNodeType() == 5) {
                    contentList.add(child);
                } else if (child.getNodeType() == 7) {
                    this.addContent(contentList, (CMContent)child);
                } else {
                    throw new IllegalArgumentException("Unknown content child: " + child);
                }
                ++i;
            }
        } else {
            contentList.add(content);
        }
    }

    protected void addDocTypeProposal(ContentAssistRequest contentAssistRequest) {
        String rootname = "unspecified";
        if (contentAssistRequest.getNode().getOwnerDocument().getDocumentElement() != null) {
            rootname = contentAssistRequest.getNode().getOwnerDocument().getDocumentElement().getNodeName();
        }
        String proposedText = "<!DOCTYPE " + rootname + " PUBLIC \"//UNKNOWN/\" \"unknown.dtd\">";
        CustomCompletionProposal proposal = new CustomCompletionProposal(proposedText, contentAssistRequest.getReplacementBeginPosition(), contentAssistRequest.getReplacementLength(), 10, XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/doctype.gif"), "<!DOCTYPE ... >", null, null, 600);
        contentAssistRequest.addProposal((ICompletionProposal)proposal);
    }

    protected void addEmptyDocumentProposals(ContentAssistRequest contentAssistRequest) {
    }

    protected void addEndTagNameProposals(ContentAssistRequest contentAssistRequest) {
        if (contentAssistRequest.getStartOffset() + contentAssistRequest.getRegion().getTextLength() < contentAssistRequest.getReplacementBeginPosition()) {
            CustomCompletionProposal proposal = new CustomCompletionProposal(">", contentAssistRequest.getReplacementBeginPosition(), contentAssistRequest.getReplacementLength(), 1, XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/tag-generic.gif"), NLS.bind((String)XMLUIMessages.Close_with__, (Object[])new Object[]{" '>'"}), null, null, 1100);
            contentAssistRequest.addProposal((ICompletionProposal)proposal);
        } else {
            IDOMNode node = (IDOMNode)contentAssistRequest.getNode();
            ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)node.getOwnerDocument());
            Node aNode = contentAssistRequest.getNode();
            String matchString = contentAssistRequest.getMatchString();
            if (matchString.startsWith("</")) {
                matchString = matchString.substring(2);
            }
            while (aNode != null) {
                if (aNode.getNodeType() == 1 && aNode.getNodeName().startsWith(matchString)) {
                    IDOMNode aXMLNode = (IDOMNode)aNode;
                    CMElementDeclaration ed = modelQuery.getCMElementDeclaration((Element)aNode);
                    if (aXMLNode.getEndStructuredDocumentRegion() == null && (ed == null || ed.getContentType() != 1)) {
                        String proposedInfo;
                        String proposedText = aNode.getNodeName();
                        String string = proposedInfo = ed != null ? this.getAdditionalInfo(null, (CMNode)ed) : null;
                        if (node.getNodeType() == 3 && !contentAssistRequest.getDocumentRegion().isEnded()) {
                            proposedText = String.valueOf(proposedText) + ">";
                        }
                        CustomCompletionProposal proposal = null;
                        Image image = CMImageUtil.getImage((CMNode)ed);
                        if (image == null) {
                            image = XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/tag-generic.gif");
                        }
                        proposal = contentAssistRequest.getRegion().getType() == "XML_TAG_NAME" ? new CustomCompletionProposal(proposedText, contentAssistRequest.getStartOffset(), contentAssistRequest.getRegion().getTextLength(), proposedText.length(), image, proposedText, null, proposedInfo, 1100) : new CustomCompletionProposal(proposedText, contentAssistRequest.getReplacementBeginPosition(), contentAssistRequest.getReplacementLength(), proposedText.length(), image, NLS.bind((String)XMLUIMessages.Close_with__, (Object[])new Object[]{"'" + proposedText + "'"}), null, proposedInfo, 1100);
                        contentAssistRequest.addProposal((ICompletionProposal)proposal);
                    }
                }
                aNode = aNode.getParentNode();
            }
        }
    }

    protected void addEndTagProposals(ContentAssistRequest contentAssistRequest) {
        IDOMNode node = (IDOMNode)contentAssistRequest.getParent();
        if (this.isCommentNode(node)) {
            while (node != null && this.isCommentNode(node)) {
                node = (IDOMNode)node.getParentNode();
            }
        }
        if (node.isClosed()) {
            while (node != null && node.isClosed()) {
                node = (IDOMNode)node.getParentNode();
            }
        }
        if (node == null) {
            return;
        }
        String replaceText = String.valueOf(node.getNodeName()) + ">";
        int replaceBegin = contentAssistRequest.getReplacementBeginPosition();
        int replaceLength = contentAssistRequest.getReplacementLength();
        int cursorOffset = node.getNodeName().length() + 1;
        String displayString = "";
        String proposedInfo = "";
        Image image = XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/tag-generic.gif");
        this.setErrorMessage(null);
        boolean addProposal = false;
        if (node.getNodeType() == 1) {
            IStructuredDocument sDoc = (IStructuredDocument)this.fTextViewer.getDocument();
            IStructuredDocumentRegion xmlEndTagOpen = sDoc.getRegionAtCharacterOffset(contentAssistRequest.getReplacementBeginPosition());
            String type = "";
            while (xmlEndTagOpen != null && (type = xmlEndTagOpen.getType()) != "XML_END_TAG_OPEN" && type != "XML_TAG_CLOSE" && !this.needsEndTag(xmlEndTagOpen) && type != "XML_TAG_OPEN") {
                xmlEndTagOpen = xmlEndTagOpen.getPrevious();
            }
            if (xmlEndTagOpen == null) {
                return;
            }
            node = (IDOMNode)node.getModel().getIndexedRegion(xmlEndTagOpen.getStartOffset());
            node = (IDOMNode)node.getParentNode();
            if (this.isStartTag(xmlEndTagOpen)) {
                if (this.needsEndTag(xmlEndTagOpen)) {
                    String tagName = this.getTagName(xmlEndTagOpen);
                    xmlEndTagOpen.getTextEndOffset();
                    replaceLength = 0;
                    replaceText = "</" + tagName + ">";
                    cursorOffset = tagName.length() + 3;
                    displayString = NLS.bind((String)XMLUIMessages.End_with__, (Object[])new Object[]{tagName});
                    addProposal = true;
                }
            } else if (type == "XML_END_TAG_OPEN") {
                replaceLength = replaceBegin > xmlEndTagOpen.getTextEndOffset() ? replaceBegin - xmlEndTagOpen.getTextEndOffset() : 0;
                replaceText = String.valueOf(node.getNodeName()) + ">";
                cursorOffset = replaceText.length();
                replaceBegin = xmlEndTagOpen.getTextEndOffset();
                displayString = NLS.bind((String)XMLUIMessages.End_with_, (Object[])new Object[]{node.getNodeName()});
                addProposal = true;
            } else if (type == "XML_TAG_OPEN") {
                replaceText = "/" + node.getNodeName() + ">";
                cursorOffset = replaceText.length();
                replaceLength = replaceBegin > xmlEndTagOpen.getTextEndOffset() ? replaceBegin - xmlEndTagOpen.getTextEndOffset() : 0;
                replaceBegin = xmlEndTagOpen.getTextEndOffset();
                displayString = NLS.bind((String)XMLUIMessages.End_with_, (Object[])new Object[]{"/" + node.getNodeName()});
                addProposal = true;
            }
        } else if (node.getNodeValue() != null && node.getNodeValue().indexOf("</") != -1) {
            Node parent = node.getParentNode();
            if (parent != null && parent.getNodeType() != 9) {
                replaceText = String.valueOf(parent.getNodeName()) + ">";
                cursorOffset = replaceText.length();
                displayString = NLS.bind((String)XMLUIMessages.End_with__, (Object[])new Object[]{parent.getNodeName()});
                this.setErrorMessage(null);
                addProposal = true;
            }
        } else if (node.getNodeType() == 9) {
            this.setErrorMessage(UNKNOWN_CONTEXT);
        }
        if (addProposal) {
            CustomCompletionProposal proposal = new CustomCompletionProposal(replaceText, replaceBegin, replaceLength, cursorOffset, image, displayString, null, proposedInfo, 1400);
            contentAssistRequest.addProposal((ICompletionProposal)proposal);
        }
    }

    protected void addEntityProposals(ContentAssistRequest contentAssistRequest, int documentPosition, ITextRegion completionRegion, IDOMNode treeNode) {
        ICompletionProposal[] eps = this.computeEntityReferenceProposals(documentPosition, completionRegion, treeNode);
        int i = 0;
        while (eps != null && i < eps.length) {
            contentAssistRequest.addProposal(eps[i]);
            ++i;
        }
    }

    protected void addEntityProposals(Vector proposals, Properties map, String key, int nodeOffset, IStructuredDocumentRegion sdRegion, ITextRegion completionRegion) {
        if (map == null) {
            return;
        }
        String entityName = "";
        String entityValue = "";
        Image entityIcon = XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/entity_reference.gif");
        String replacementText = "";
        String displayString = "";
        Enumeration<Object> keys = map.keys();
        while (keys != null && keys.hasMoreElements()) {
            entityName = (String)keys.nextElement();
            entityValue = map.getProperty(entityName);
            if (!entityName.toLowerCase().startsWith(key.toLowerCase()) && !key.trim().equals("")) continue;
            int selectionLength = nodeOffset;
            if (this.fTextViewer != null) {
                selectionLength += this.fTextViewer.getSelectedRange().y;
            }
            replacementText = "&" + entityName + ";";
            displayString = "&" + entityName + "; (" + entityValue + ")";
            CustomCompletionProposal cp = new CustomCompletionProposal(replacementText, sdRegion.getStartOffset(completionRegion), selectionLength, replacementText.length(), entityIcon, displayString, null, null, 1000);
            if (cp == null) continue;
            proposals.add(cp);
        }
    }

    protected void addPCDATAProposal(String nodeName, ContentAssistRequest contentAssistRequest) {
        CustomCompletionProposal proposal = new CustomCompletionProposal("<![CDATA[]]>", contentAssistRequest.getReplacementBeginPosition(), contentAssistRequest.getReplacementLength(), 9, XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/cdatasection.gif"), "CDATA Section", null, null, 400);
        contentAssistRequest.addProposal((ICompletionProposal)proposal);
        proposal = new CustomCompletionProposal(nodeName, contentAssistRequest.getReplacementBeginPosition(), contentAssistRequest.getReplacementLength(), nodeName.length(), XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/text.gif"), "#PCDATA", null, null, 400);
        contentAssistRequest.addProposal((ICompletionProposal)proposal);
    }

    protected void addStartDocumentProposals(ContentAssistRequest contentAssistRequest) {
        boolean xmlpiIsFirstElement;
        Node aNode = contentAssistRequest.getNode();
        boolean xmlpiFound = false;
        Document owningDocument = aNode.getOwnerDocument();
        Node first = owningDocument.getFirstChild();
        boolean insertDoctype = xmlpiIsFirstElement = first != null && first.getNodeType() == 7;
        Node child = owningDocument.getFirstChild();
        while (child != null) {
            boolean xmlpi = child.getNodeType() == 7 && child.getNodeName().equals("xml");
            boolean bl = xmlpiFound = xmlpiFound || xmlpi;
            if (xmlpiFound) {
                boolean cfr_ignored_0 = child instanceof IDOMNode;
                while ((child = child.getNextSibling()) != null && child.getNodeType() == 3) {
                }
                if (child == null || !(child instanceof IDOMNode) || contentAssistRequest.getReplacementBeginPosition() < ((IDOMNode)child).getEndOffset() && xmlpiIsFirstElement) break;
                insertDoctype = false;
                break;
            }
            child = child.getNextSibling();
        }
        if (xmlpiFound && owningDocument.getDoctype() == null && this.isCursorAfterXMLPI(contentAssistRequest) && insertDoctype) {
            this.addDocTypeProposal(contentAssistRequest);
        }
    }

    protected void addTagCloseProposals(ContentAssistRequest contentAssistRequest) {
        IDOMNode node = (IDOMNode)contentAssistRequest.getParent();
        if (node.getNodeType() == 1) {
            CMElementDeclaration elementDecl = this.getCMElementDeclaration((Node)node);
            String proposedInfo = elementDecl != null ? this.getAdditionalInfo(null, (CMNode)elementDecl) : null;
            int contentType = elementDecl != null ? elementDecl.getContentType() : 0;
            boolean endWithSlashBracket = this.getXML((Node)node) && contentType != 2;
            Image image = CMImageUtil.getImage((CMNode)elementDecl);
            if (image == null) {
                image = XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/tag-generic.gif");
            }
            if (contentAssistRequest.getDocumentRegion() == node.getFirstStructuredDocumentRegion() && !node.getFirstStructuredDocumentRegion().isEnded()) {
                this.setErrorMessage(null);
                if (elementDecl != null && elementDecl.getContentType() == 1) {
                    CustomCompletionProposal proposal = new CustomCompletionProposal(this.getContentGenerator().getStartTagClose((Node)node, elementDecl), contentAssistRequest.getReplacementBeginPosition(), 0, this.getContentGenerator().getStartTagClose((Node)node, elementDecl).length(), image, NLS.bind((String)XMLUIMessages.Close_with___, (Object[])new Object[]{this.getContentGenerator().getStartTagClose((Node)node, elementDecl)}), null, proposedInfo, 1500);
                    contentAssistRequest.addProposal((ICompletionProposal)proposal);
                } else {
                    CustomCompletionProposal proposal = new CustomCompletionProposal(">", contentAssistRequest.getReplacementBeginPosition(), 0, 1, image, NLS.bind((String)XMLUIMessages.Close_with__, (Object[])new Object[]{" '>'"}), null, proposedInfo, 1500);
                    contentAssistRequest.addProposal((ICompletionProposal)proposal);
                    if (node.getEndStructuredDocumentRegion() == null) {
                        String openingTagText;
                        IStructuredDocumentRegion sdr = contentAssistRequest.getDocumentRegion();
                        String string = openingTagText = sdr != null ? sdr.getFullText() : "";
                        if (openingTagText != null && openingTagText.indexOf(node.getNodeName()) != -1) {
                            proposal = new CustomCompletionProposal("></" + node.getNodeName() + ">", contentAssistRequest.getReplacementBeginPosition(), 0, 1, image, NLS.bind((String)XMLUIMessages.Close_with____, (Object[])new Object[]{node.getNodeName()}), null, proposedInfo, 1500);
                            contentAssistRequest.addProposal((ICompletionProposal)proposal);
                        }
                    }
                    if (endWithSlashBracket) {
                        proposal = new CustomCompletionProposal("/>", contentAssistRequest.getReplacementBeginPosition(), 0, 2, image, NLS.bind((String)XMLUIMessages.Close_with__, (Object[])new Object[]{" \"/>\""}), null, proposedInfo, 1501);
                        contentAssistRequest.addProposal((ICompletionProposal)proposal);
                    }
                }
            } else if (contentAssistRequest.getDocumentRegion() == node.getLastStructuredDocumentRegion() && !node.getLastStructuredDocumentRegion().isEnded()) {
                this.setErrorMessage(null);
                CustomCompletionProposal proposal = new CustomCompletionProposal(">", contentAssistRequest.getReplacementBeginPosition(), 0, 1, image, NLS.bind((String)XMLUIMessages.Close_with__, (Object[])new Object[]{" '>'"}), null, proposedInfo, 1500);
                contentAssistRequest.addProposal((ICompletionProposal)proposal);
            }
        } else if (node.getNodeType() == 9) {
            this.setErrorMessage(UNKNOWN_CONTEXT);
        }
    }

    protected void addTagInsertionProposals(ContentAssistRequest contentAssistRequest, int childPosition) {
        block25: {
            Node parent;
            block23: {
                Iterator nodeIterator;
                CMElementDeclaration parentDecl;
                String error;
                List cmnodes;
                block24: {
                    String[] childStrings;
                    CMDataType childType;
                    cmnodes = null;
                    parent = contentAssistRequest.getParent();
                    error = null;
                    if (parent != null && parent.getNodeType() == 9 && ((IDOMDocument)parent).isXMLType() && !this.isCursorAfterXMLPI(contentAssistRequest)) {
                        return;
                    }
                    if (!this.isCursorAfterDoctype(contentAssistRequest)) {
                        return;
                    }
                    if (parent != null && parent instanceof IDOMNode && this.isCommentNode((IDOMNode)parent)) {
                        while (parent != null && this.isCommentNode((IDOMNode)parent)) {
                            parent = parent.getParentNode();
                        }
                    }
                    if (parent.getNodeType() != 1) break block23;
                    parentDecl = this.getCMElementDeclaration(parent);
                    if (parentDecl != null && (childType = parentDecl.getDataType()) != null && (childStrings = childType.getEnumeratedValues()) != null) {
                        int begin = contentAssistRequest.getReplacementBeginPosition();
                        int length = contentAssistRequest.getReplacementLength();
                        if (parent instanceof IDOMNode && ((IDOMNode)parent).getLastStructuredDocumentRegion() != ((IDOMNode)parent).getFirstStructuredDocumentRegion()) {
                            begin = ((IDOMNode)parent).getFirstStructuredDocumentRegion().getEndOffset();
                            length = ((IDOMNode)parent).getLastStructuredDocumentRegion().getStartOffset() - begin;
                        }
                        String proposedInfo = this.getAdditionalInfo((CMNode)parentDecl, (CMNode)childType);
                        int i = 0;
                        while (i < childStrings.length) {
                            CustomCompletionProposal textProposal = new CustomCompletionProposal(childStrings[i], begin, length, childStrings[i].length(), XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/enum.gif"), childStrings[i], null, proposedInfo, 500);
                            contentAssistRequest.addProposal((ICompletionProposal)textProposal);
                            ++i;
                        }
                    }
                    if (parentDecl == null || parentDecl.getContentType() != 4) break block24;
                    this.addPCDATAProposal(parentDecl.getNodeName(), contentAssistRequest);
                    break block25;
                }
                cmnodes = this.getAvailableChildElementDeclarations((Element)parent, childPosition, 1);
                List strictCMNodeSuggestions = null;
                if ("Strict".equals(XMLUIPlugin.getInstance().getPreferenceStore().getString(XMLUIPreferenceNames.SUGGESTION_STRATEGY))) {
                    strictCMNodeSuggestions = this.getValidChildElementDeclarations((Element)parent, childPosition, 1);
                }
                if (!(nodeIterator = cmnodes.iterator()).hasNext()) {
                    error = this.getCMElementDeclaration(parent) != null ? NLS.bind((String)XMLUIMessages._Has_no_available_child, (Object[])new Object[]{parent.getNodeName()}) : NLS.bind((String)XMLUIMessages.Element__is_unknown, (Object[])new Object[]{parent.getNodeName()});
                }
                String matchString = contentAssistRequest.getMatchString();
                while (matchString.length() > 0 && (Character.isWhitespace(matchString.charAt(0)) || this.beginsWith(matchString, "<"))) {
                    matchString = matchString.substring(1);
                }
                while (nodeIterator.hasNext()) {
                    Object o = nodeIterator.next();
                    if (!(o instanceof CMElementDeclaration)) continue;
                    CMElementDeclaration elementDecl = (CMElementDeclaration)o;
                    String tagname = this.getRequiredName(parent, (CMNode)elementDecl);
                    boolean isStrictCMNodeSuggestion = strictCMNodeSuggestions != null ? strictCMNodeSuggestions.contains(elementDecl) : false;
                    Image image = CMImageUtil.getImage((CMNode)elementDecl);
                    if (image == null) {
                        image = strictCMNodeSuggestions != null ? (isStrictCMNodeSuggestion ? XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/tag_generic_emphasized_obj.gif") : XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/tag_generic_deemphasized_obj.gif")) : XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/tag-generic.gif");
                    }
                    if (!this.beginsWith(tagname, matchString)) continue;
                    String proposedText = this.getRequiredText(parent, elementDecl);
                    int markupAdjustment = this.getCursorPositionForProposedText(proposedText);
                    String proposedInfo = this.getAdditionalInfo((CMNode)parentDecl, (CMNode)elementDecl);
                    int relevance = isStrictCMNodeSuggestion ? 600 : 500;
                    CustomCompletionProposal proposal = new CustomCompletionProposal(proposedText, contentAssistRequest.getReplacementBeginPosition(), contentAssistRequest.getReplacementLength(), markupAdjustment, image, tagname, null, proposedInfo, relevance);
                    contentAssistRequest.addProposal((ICompletionProposal)proposal);
                }
                if (contentAssistRequest.getProposals().size() != 0) break block25;
                if (error != null) {
                    this.setErrorMessage(error);
                } else if (contentAssistRequest.getMatchString() != null && contentAssistRequest.getMatchString().length() > 0) {
                    this.setErrorMessage(NLS.bind((String)XMLUIMessages.No_known_child_tag, (Object[])new Object[]{parent.getNodeName(), contentAssistRequest.getMatchString()}));
                } else {
                    this.setErrorMessage(NLS.bind((String)XMLUIMessages.__Has_no_known_child, (Object[])new Object[]{parent.getNodeName()}));
                }
                break block25;
            }
            if (parent.getNodeType() == 9) {
                boolean xmlpiFound = false;
                boolean doctypeFound = false;
                int minimumOffset = -1;
                Node child = parent.getFirstChild();
                while (child != null) {
                    boolean doctype;
                    boolean xmlpi = child.getNodeType() == 7 && child.getNodeName().equals("xml");
                    boolean bl = doctype = child.getNodeType() == 10;
                    if (xmlpi || doctype && minimumOffset < 0) {
                        minimumOffset = ((IDOMNode)child).getFirstStructuredDocumentRegion().getStartOffset() + ((IDOMNode)child).getFirstStructuredDocumentRegion().getTextLength();
                    }
                    xmlpiFound = xmlpiFound || xmlpi;
                    doctypeFound = doctypeFound || doctype;
                    child = child.getNextSibling();
                }
                if (contentAssistRequest.getReplacementBeginPosition() >= minimumOffset) {
                    List childDecls = this.getAvailableRootChildren((Document)parent, childPosition);
                    int i = 0;
                    while (i < childDecls.size()) {
                        CMElementDeclaration ed = (CMElementDeclaration)childDecls.get(i);
                        if (ed != null) {
                            Image image = CMImageUtil.getImage((CMNode)ed);
                            if (image == null) {
                                image = XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/tag-generic.gif");
                            }
                            String proposedText = this.getRequiredText(parent, ed);
                            String tagname = this.getRequiredName(parent, (CMNode)ed);
                            int markupAdjustment = this.getContentGenerator().getMinimalStartTagLength(parent, ed);
                            String proposedInfo = this.getAdditionalInfo(null, (CMNode)ed);
                            CustomCompletionProposal proposal = new CustomCompletionProposal(proposedText, contentAssistRequest.getReplacementBeginPosition(), contentAssistRequest.getReplacementLength(), markupAdjustment, image, tagname, null, proposedInfo, 500);
                            contentAssistRequest.addProposal((ICompletionProposal)proposal);
                        }
                        ++i;
                    }
                }
            }
        }
    }

    protected void addTagNameProposals(ContentAssistRequest contentAssistRequest, int childPosition) {
        List cmnodes = null;
        Node parent = contentAssistRequest.getParent();
        IDOMNode node = (IDOMNode)contentAssistRequest.getNode();
        String error = null;
        String matchString = contentAssistRequest.getMatchString();
        if (parent.getNodeType() == 1) {
            cmnodes = this.getAvailableChildElementDeclarations((Element)parent, childPosition, 1);
            Iterator nodeIterator = cmnodes.iterator();
            while (matchString.length() > 0 && (Character.isWhitespace(matchString.charAt(0)) || this.beginsWith(matchString, "<"))) {
                matchString = matchString.substring(1);
            }
            if (!nodeIterator.hasNext()) {
                error = NLS.bind((String)XMLUIMessages.__Has_no_known_child, (Object[])new Object[]{parent.getNodeName()});
            }
            while (nodeIterator.hasNext()) {
                CMNode elementDecl = (CMNode)nodeIterator.next();
                if (elementDecl == null) continue;
                String proposedText = null;
                int cursorAdjustment = 0;
                if (node != null && node.getAttributes() != null && node.getAttributes().getLength() > 0 && this.attributeInList(node, parent, elementDecl) || node.getNodeType() != 3 && node.getFirstStructuredDocumentRegion().isEnded()) {
                    proposedText = this.getRequiredName(parent, elementDecl);
                    cursorAdjustment = proposedText.length();
                } else {
                    proposedText = this.getRequiredName(parent, elementDecl);
                    cursorAdjustment = proposedText.length();
                    if (elementDecl instanceof CMElementDeclaration) {
                        CMElementDeclaration ed = (CMElementDeclaration)elementDecl;
                        if (ed.getContentType() == 1) {
                            proposedText = String.valueOf(proposedText) + this.getContentGenerator().getStartTagClose(parent, ed);
                            cursorAdjustment = proposedText.length();
                        } else {
                            StringBuffer sb = new StringBuffer();
                            this.getContentGenerator().generateTag(parent, ed, sb);
                            proposedText = sb.toString().substring(1);
                            cursorAdjustment = this.getCursorPositionForProposedText(proposedText);
                        }
                    }
                }
                if (!this.beginsWith(proposedText, matchString)) continue;
                Image image = CMImageUtil.getImage(elementDecl);
                if (image == null) {
                    image = XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/tag-generic.gif");
                }
                String proposedInfo = this.getAdditionalInfo((CMNode)this.getCMElementDeclaration(parent), elementDecl);
                CustomCompletionProposal proposal = new CustomCompletionProposal(proposedText, contentAssistRequest.getReplacementBeginPosition(), contentAssistRequest.getReplacementLength(), cursorAdjustment, image, this.getRequiredName(parent, elementDecl), null, proposedInfo, 1200);
                contentAssistRequest.addProposal((ICompletionProposal)proposal);
            }
            if (contentAssistRequest.getProposals().size() == 0) {
                if (error != null) {
                    this.setErrorMessage(error);
                } else if (contentAssistRequest.getMatchString() != null && contentAssistRequest.getMatchString().length() > 0) {
                    this.setErrorMessage(NLS.bind((String)XMLUIMessages.No_known_child_tag_names, (Object[])new Object[]{parent.getNodeName(), contentAssistRequest.getMatchString()}));
                } else {
                    this.setErrorMessage(NLS.bind((String)XMLUIMessages.__Has_no_known_child, (Object[])new Object[]{parent.getNodeName()}));
                }
            }
        } else if (parent.getNodeType() == 9) {
            List childElements = this.getAvailableRootChildren((Document)parent, childPosition);
            int i = 0;
            while (i < childElements.size()) {
                CMNode ed = (CMNode)childElements.get(i);
                if (ed != null) {
                    String proposedText = null;
                    int cursorAdjustment = 0;
                    if (ed instanceof CMElementDeclaration) {
                        StringBuffer sb = new StringBuffer();
                        this.getContentGenerator().generateTag(parent, (CMElementDeclaration)ed, sb);
                        proposedText = sb.toString().substring(1);
                        if (this.beginsWith(proposedText, matchString)) {
                            CMElementDeclaration elementDecl;
                            cursorAdjustment = this.getCursorPositionForProposedText(proposedText);
                            if (ed instanceof CMElementDeclaration && (elementDecl = (CMElementDeclaration)ed).getContentType() == 1) {
                                proposedText = String.valueOf(proposedText) + this.getContentGenerator().getStartTagClose(parent, elementDecl);
                                cursorAdjustment = proposedText.length();
                            }
                            String proposedInfo = this.getAdditionalInfo(null, ed);
                            Image image = CMImageUtil.getImage(ed);
                            if (image == null) {
                                image = XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/tag-generic.gif");
                            }
                            CustomCompletionProposal proposal = new CustomCompletionProposal(proposedText, contentAssistRequest.getReplacementBeginPosition(), contentAssistRequest.getReplacementLength(), cursorAdjustment, image, this.getRequiredName(parent, ed), null, proposedInfo, 1200);
                            contentAssistRequest.addProposal((ICompletionProposal)proposal);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private int getCursorPositionForProposedText(String proposedText) {
        int cursorAdjustment = proposedText.indexOf("\"\"") + 1;
        if (cursorAdjustment == 0) {
            cursorAdjustment = proposedText.indexOf(62) + 1;
        }
        if (cursorAdjustment == 0) {
            cursorAdjustment = proposedText.length() + 1;
        }
        return cursorAdjustment;
    }

    protected void addXMLProposal(ContentAssistRequest contentAssistRequest) {
        String proposedText = "<?xml version=\"1.0\" encoding=\"" + ContentTypeEncodingPreferences.getUserPreferredCharsetName((String)ContentTypeIdForXML.ContentTypeID_XML) + "\"?>";
        CustomCompletionProposal proposal = new CustomCompletionProposal(proposedText, contentAssistRequest.getReplacementBeginPosition(), contentAssistRequest.getReplacementLength(), proposedText.length(), XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/proinst_obj.gif"), proposedText, null, null, 1300);
        contentAssistRequest.addProposal((ICompletionProposal)proposal);
    }

    protected boolean attributeInList(IDOMNode node, Node parent, CMNode cmnode) {
        if (node == null || parent == null || cmnode == null) {
            return false;
        }
        String elementMatchString = node.getNodeName();
        String cmnodeName = this.getRequiredName(parent, cmnode);
        if (node instanceof Element) {
            NamedNodeMap map = ((Element)node).getAttributes();
            String attrMatchString = "";
            CMNamedNodeMap cmattrMap = null;
            int i = 0;
            while (map != null && i < map.getLength()) {
                attrMatchString = map.item(i).getNodeName();
                if (this.beginsWith(cmnodeName, elementMatchString) && cmnode.getNodeType() == 5) {
                    cmattrMap = ((CMElementDeclaration)cmnode).getAttributes();
                    int k = 0;
                    while (cmattrMap != null && k < cmattrMap.getLength()) {
                        if (cmattrMap.item(k).getNodeName().equals(attrMatchString)) {
                            return true;
                        }
                        ++k;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    protected boolean beginsWith(String aString, String prefix) {
        if (aString == null || prefix == null) {
            return true;
        }
        return aString.toLowerCase().startsWith(prefix.toLowerCase());
    }

    protected ContentAssistRequest computeAttributeProposals(int documentPosition, String matchString, ITextRegion completionRegion, IDOMNode nodeAtOffset, IDOMNode node) {
        ContentAssistRequest contentAssistRequest = null;
        IStructuredDocumentRegion sdRegion = this.getStructuredDocumentRegion(documentPosition);
        contentAssistRequest = documentPosition < sdRegion.getStartOffset(completionRegion) ? this.newContentAssistRequest((Node)nodeAtOffset, (Node)node, sdRegion, completionRegion, documentPosition, 0, matchString) : this.newContentAssistRequest((Node)nodeAtOffset, (Node)node, sdRegion, completionRegion, sdRegion.getStartOffset(completionRegion), completionRegion.getTextLength(), matchString);
        this.addAttributeNameProposals(contentAssistRequest);
        contentAssistRequest.setReplacementBeginPosition(documentPosition);
        contentAssistRequest.setReplacementLength(0);
        if (node.getFirstStructuredDocumentRegion() != null && !node.getFirstStructuredDocumentRegion().isEnded()) {
            this.addTagCloseProposals(contentAssistRequest);
        }
        return contentAssistRequest;
    }

    protected ContentAssistRequest computeAttributeValueProposals(int documentPosition, String matchString, ITextRegion completionRegion, IDOMNode nodeAtOffset, IDOMNode node) {
        ContentAssistRequest contentAssistRequest = null;
        IStructuredDocumentRegion sdRegion = this.getStructuredDocumentRegion(documentPosition);
        if (documentPosition > sdRegion.getStartOffset(completionRegion) + completionRegion.getTextLength() && sdRegion.getStartOffset(completionRegion) + completionRegion.getTextLength() != sdRegion.getStartOffset(completionRegion) + completionRegion.getLength()) {
            IDOMNode actualNode = (IDOMNode)node.getModel().getIndexedRegion(sdRegion.getStartOffset(completionRegion));
            contentAssistRequest = this.newContentAssistRequest((Node)actualNode, (Node)actualNode, sdRegion, completionRegion, documentPosition, 0, matchString);
            this.addAttributeNameProposals(contentAssistRequest);
            if (actualNode.getFirstStructuredDocumentRegion() != null && !actualNode.getFirstStructuredDocumentRegion().isEnded()) {
                this.addTagCloseProposals(contentAssistRequest);
            }
        } else if (!nodeAtOffset.getFirstStructuredDocumentRegion().isEnded() && documentPosition < sdRegion.getStartOffset(completionRegion)) {
            contentAssistRequest = this.newContentAssistRequest((Node)nodeAtOffset, (Node)node, sdRegion, completionRegion, documentPosition, 0, matchString);
            this.addAttributeNameProposals(contentAssistRequest);
        } else {
            contentAssistRequest = this.newContentAssistRequest((Node)nodeAtOffset, (Node)node, sdRegion, completionRegion, sdRegion.getStartOffset(completionRegion), completionRegion.getTextLength(), matchString);
            this.addAttributeValueProposals(contentAssistRequest);
        }
        return contentAssistRequest;
    }

    protected ContentAssistRequest computeCompletionProposals(int documentPosition, String matchString, ITextRegion completionRegion, IDOMNode treeNode, IDOMNode xmlnode) {
        ContentAssistRequest contentAssistRequest = null;
        String regionType = completionRegion.getType();
        IStructuredDocumentRegion sdRegion = this.getStructuredDocumentRegion(documentPosition);
        if (xmlnode.getNodeType() == 1 || xmlnode.getNodeType() == 9) {
            if (regionType == "XML_TAG_OPEN") {
                contentAssistRequest = this.computeTagOpenProposals(documentPosition, matchString, completionRegion, treeNode, xmlnode);
            } else if (regionType == "XML_TAG_NAME") {
                contentAssistRequest = this.computeTagNameProposals(documentPosition, matchString, completionRegion, treeNode, xmlnode);
            } else if (regionType == "XML_TAG_ATTRIBUTE_NAME") {
                contentAssistRequest = this.computeAttributeProposals(documentPosition, matchString, completionRegion, treeNode, xmlnode);
            } else if (regionType == "XML_TAG_ATTRIBUTE_EQUALS") {
                contentAssistRequest = this.computeEqualsProposals(documentPosition, matchString, completionRegion, treeNode, xmlnode);
            } else if (regionType == "XML_TAG_ATTRIBUTE_VALUE" && documentPosition == sdRegion.getTextEndOffset() && (sdRegion.getText(completionRegion).endsWith("\"") || sdRegion.getText(completionRegion).endsWith("'"))) {
                IDOMNode actualNode = (IDOMNode)xmlnode.getModel().getIndexedRegion(sdRegion.getStartOffset(completionRegion));
                contentAssistRequest = this.newContentAssistRequest((Node)actualNode, (Node)actualNode, sdRegion, completionRegion, documentPosition, 0, matchString);
                this.addTagCloseProposals(contentAssistRequest);
            } else if (regionType == "XML_TAG_ATTRIBUTE_VALUE") {
                contentAssistRequest = this.computeAttributeValueProposals(documentPosition, matchString, completionRegion, treeNode, xmlnode);
            } else if (regionType == "XML_TAG_CLOSE" || regionType == "XML_EMPTY_TAG_CLOSE" || regionType.equals("JSP_DIRECTIVE_CLOSE")) {
                contentAssistRequest = this.computeTagCloseProposals(documentPosition, matchString, completionRegion, treeNode, xmlnode);
            } else if (regionType == "XML_END_TAG_OPEN") {
                contentAssistRequest = this.computeEndTagOpenProposals(documentPosition, matchString, completionRegion, treeNode, xmlnode);
            } else if (regionType == "XML_CONTENT" || regionType == "XML_CHAR_REFERENCE" || regionType == "XML_ENTITY_REFERENCE" || regionType == "XML_PE_REFERENCE") {
                contentAssistRequest = this.computeContentProposals(documentPosition, matchString, completionRegion, treeNode, xmlnode);
            } else if (documentPosition == sdRegion.getStartOffset(completionRegion) && (regionType.equals("JSP_COMMENT_OPEN") || regionType.equals("JSP_DECLARATION_OPEN") || regionType.equals("JSP_DIRECTIVE_OPEN") || regionType.equals("JSP_EXPRESSION_OPEN") || regionType.equals("JSP_SCRIPTLET_OPEN") || regionType == "XML_DECLARATION_OPEN" || regionType == "XML_PI_OPEN" || regionType == "XML_COMMENT_OPEN" || regionType == "XML_CDATA_OPEN")) {
                contentAssistRequest = this.newContentAssistRequest((Node)treeNode, xmlnode.getParentNode(), sdRegion, completionRegion, documentPosition, 0, matchString);
                this.addTagInsertionProposals(contentAssistRequest, this.getElementPositionForModelQuery((Node)treeNode));
                this.addStartDocumentProposals(contentAssistRequest);
            }
        } else if (this.isCloseRegion(completionRegion)) {
            contentAssistRequest = this.newContentAssistRequest((Node)treeNode, xmlnode.getParentNode(), sdRegion, completionRegion, sdRegion.getStartOffset(completionRegion) + completionRegion.getLength(), 0, matchString);
            this.addStartDocumentProposals(contentAssistRequest);
            if (documentPosition >= sdRegion.getTextEndOffset(completionRegion)) {
                this.addTagInsertionProposals(contentAssistRequest, this.getElementPositionForModelQuery((Node)treeNode) + 1);
            }
        } else if (documentPosition == sdRegion.getStartOffset(completionRegion) && (regionType.equals("JSP_COMMENT_OPEN") || regionType.equals("JSP_DECLARATION_OPEN") || regionType.equals("JSP_DIRECTIVE_OPEN") || regionType.equals("JSP_EXPRESSION_OPEN") || regionType.equals("JSP_SCRIPTLET_OPEN") || regionType == "XML_DECLARATION_OPEN" || regionType == "XML_PI_OPEN" || regionType == "XML_COMMENT_OPEN" || regionType == "XML_CDATA_OPEN")) {
            contentAssistRequest = this.newContentAssistRequest((Node)treeNode, xmlnode.getParentNode(), sdRegion, completionRegion, documentPosition, 0, matchString);
            this.addTagInsertionProposals(contentAssistRequest, this.getElementPositionForModelQuery((Node)treeNode));
            this.addStartDocumentProposals(contentAssistRequest);
        }
        return contentAssistRequest;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICompletionProposal[] computeCompletionProposals(ITextViewer textViewer, int documentPosition) {
        this.setErrorMessage(null);
        this.fTextViewer = textViewer;
        IndexedRegion treeNode = ContentAssistUtils.getNodeAt((ITextViewer)textViewer, (int)documentPosition);
        Node node = (Node)treeNode;
        while (node != null && node.getNodeType() == 3 && node.getParentNode() != null) {
            node = node.getParentNode();
        }
        IDOMNode xmlnode = (IDOMNode)node;
        ContentAssistRequest contentAssistRequest = null;
        IStructuredDocumentRegion sdRegion = this.getStructuredDocumentRegion(documentPosition);
        ITextRegion completionRegion = this.getCompletionRegion(documentPosition, node);
        String matchString = this.getMatchString(sdRegion, completionRegion, documentPosition);
        if (completionRegion == null) {
            if (!(treeNode != null && ((Node)treeNode).getNodeType() != 9 || completionRegion != null || xmlnode != null && xmlnode.getChildNodes() != null && xmlnode.getChildNodes().getLength() != 0)) {
                block12: {
                    IStructuredModel sModel = StructuredModelManager.getModelManager().getExistingModelForRead(textViewer.getDocument());
                    try {
                        if (sModel != null) {
                            IDOMDocument docNode = ((IDOMModel)sModel).getDocument();
                            contentAssistRequest = this.newContentAssistRequest((Node)docNode, (Node)docNode, sdRegion, completionRegion, documentPosition, 0, null);
                            this.addEmptyDocumentProposals(contentAssistRequest);
                        }
                        Object var12_14 = null;
                        if (sModel == null) break block12;
                    }
                    catch (Throwable throwable) {
                        Object var12_13 = null;
                        if (sModel != null) {
                            sModel.releaseFromRead();
                        }
                        throw throwable;
                    }
                    sModel.releaseFromRead();
                }
                if (contentAssistRequest == null) {
                    Logger.logException(new IllegalStateException("problem getting model"));
                    return new ICompletionProposal[0];
                }
                return contentAssistRequest.getCompletionProposals();
            }
            Logger.logException(new IllegalStateException("completion region was null"));
            this.setErrorMessage(INTERNALERROR);
            contentAssistRequest = this.newContentAssistRequest((Node)treeNode, node.getParentNode(), sdRegion, completionRegion, documentPosition, 0, "");
            return contentAssistRequest.getCompletionProposals();
        }
        if (xmlnode.getNodeType() == 9 && (completionRegion == null || xmlnode.getChildNodes() == null || xmlnode.getChildNodes().getLength() == 0)) {
            contentAssistRequest = this.computeStartDocumentProposals(documentPosition, matchString, completionRegion, (IDOMNode)treeNode, xmlnode);
            return contentAssistRequest.getCompletionProposals();
        }
        contentAssistRequest = this.computeCompletionProposals(documentPosition, matchString, completionRegion, (IDOMNode)treeNode, xmlnode);
        if (contentAssistRequest == null) {
            contentAssistRequest = this.newContentAssistRequest((Node)treeNode, node.getParentNode(), sdRegion, completionRegion, documentPosition, 0, "");
            this.setErrorMessage(UNKNOWN_CONTEXT);
        }
        if (contentAssistRequest.getProposals().size() == 0) {
            this.setErrorMessage(UNKNOWN_CONTEXT);
        }
        return contentAssistRequest.getCompletionProposals();
    }

    protected ContentAssistRequest computeContentProposals(int documentPosition, String matchString, ITextRegion completionRegion, IDOMNode nodeAtOffset, IDOMNode node) {
        ContentAssistRequest contentAssistRequest = null;
        contentAssistRequest = this.newContentAssistRequest((Node)nodeAtOffset, (Node)node, this.getStructuredDocumentRegion(documentPosition), completionRegion, documentPosition, 0, matchString);
        if (node != null && node.getNodeType() == 9 && ((Document)node).getDoctype() == null) {
            this.addStartDocumentProposals(contentAssistRequest);
        }
        this.addTagInsertionProposals(contentAssistRequest, this.getElementPositionForModelQuery((Node)nodeAtOffset));
        if (node.getNodeType() != 9) {
            this.addEndTagProposals(contentAssistRequest);
        }
        this.addEntityProposals(contentAssistRequest, documentPosition, completionRegion, node);
        return contentAssistRequest;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        if (this.fAttributeInfoProvider == null) {
            this.fAttributeInfoProvider = new AttributeContextInformationProvider((IStructuredDocument)viewer.getDocument(), (AttributeContextInformationPresenter)this.getContextInformationValidator());
        }
        return this.fAttributeInfoProvider.getAttributeInformation(documentOffset);
    }

    protected ContentAssistRequest computeEndTagOpenProposals(int documentPosition, String matchString, ITextRegion completionRegion, IDOMNode nodeAtOffset, IDOMNode node) {
        ContentAssistRequest contentAssistRequest = null;
        IStructuredDocumentRegion sdRegion = this.getStructuredDocumentRegion(documentPosition);
        int completionRegionStart = sdRegion.getStartOffset(completionRegion);
        int completionRegionLength = completionRegion.getLength();
        IStructuredDocumentRegion sdRegionAtCompletionOffset = node.getStructuredDocument().getRegionAtCharacterOffset(completionRegionStart + completionRegionLength);
        ITextRegion regionAtEndOfCompletion = sdRegionAtCompletionOffset.getRegionAtCharacterOffset(completionRegionStart + completionRegionLength);
        if (documentPosition != completionRegionStart && regionAtEndOfCompletion != null && regionAtEndOfCompletion.getType() == "XML_TAG_NAME") {
            ITextRegion nameRegion = regionAtEndOfCompletion;
            contentAssistRequest = this.newContentAssistRequest((Node)nodeAtOffset, nodeAtOffset.getParentNode(), sdRegion, completionRegion, sdRegion.getStartOffset(nameRegion), nameRegion.getTextLength(), matchString);
        } else {
            contentAssistRequest = nodeAtOffset.getFirstStructuredDocumentRegion() == sdRegion ? this.newContentAssistRequest((Node)nodeAtOffset, nodeAtOffset.getParentNode(), sdRegion, completionRegion, documentPosition, 0, matchString) : this.newContentAssistRequest((Node)nodeAtOffset, (Node)nodeAtOffset, sdRegion, completionRegion, documentPosition, 0, matchString);
        }
        this.addEndTagProposals(contentAssistRequest);
        if (completionRegionStart == documentPosition) {
            this.addTagInsertionProposals(contentAssistRequest, node.getChildNodes().getLength());
        }
        return contentAssistRequest;
    }

    protected ICompletionProposal[] computeEntityReferenceProposals(int documentPosition, ITextRegion completionRegion, IDOMNode treeNode) {
        Vector proposals = new Vector();
        IStructuredDocumentRegion sdRegion = this.getStructuredDocumentRegion(documentPosition);
        if (completionRegion != null && completionRegion.getType() == "XML_CONTENT") {
            IStructuredDocumentRegion prev;
            int nodeOffset = documentPosition - sdRegion.getStartOffset(completionRegion);
            String regionText = sdRegion.getFullText(completionRegion);
            if (regionText != null && regionText.trim().equals("") && documentPosition > 0 && (prev = treeNode.getStructuredDocument().getRegionAtCharacterOffset(documentPosition - 1)) != null && prev.getFullText().trim().equals("&")) {
                completionRegion = prev;
                regionText = prev.getFullText();
                nodeOffset = 1;
            }
            if (regionText != null && regionText.startsWith("&")) {
                String key = nodeOffset > 0 ? regionText.substring(1, nodeOffset) : "";
                ModelQuery mq = ModelQueryUtil.getModelQuery((Document)treeNode.getOwnerDocument());
                if (mq != null) {
                    CMDocument xmlDoc = mq.getCorrespondingCMDocument((Node)treeNode);
                    CMNamedNodeMap cmmap = null;
                    Properties entities = null;
                    if (xmlDoc != null) {
                        cmmap = xmlDoc.getEntities();
                    }
                    if (cmmap != null) {
                        entities = this.mapToProperties(cmmap);
                    } else {
                        entities = new Properties();
                        entities.put("quot", "\"");
                        entities.put("apos", "'");
                        entities.put("amp", "&");
                        entities.put("lt", "<");
                        entities.put("gt", ">");
                        entities.put("nbsp", " ");
                    }
                    this.addEntityProposals(proposals, entities, key, nodeOffset, sdRegion, completionRegion);
                }
            }
        }
        return proposals.size() > 0 ? proposals.toArray(new ICompletionProposal[proposals.size()]) : null;
    }

    protected ContentAssistRequest computeEqualsProposals(int documentPosition, String matchString, ITextRegion completionRegion, IDOMNode nodeAtOffset, IDOMNode node) {
        ContentAssistRequest contentAssistRequest = null;
        IStructuredDocumentRegion sdRegion = this.getStructuredDocumentRegion(documentPosition);
        ITextRegion valueRegion = node.getStartStructuredDocumentRegion().getRegionAtCharacterOffset(sdRegion.getStartOffset(completionRegion) + completionRegion.getLength());
        contentAssistRequest = valueRegion != null && valueRegion.getType() == "XML_TAG_ATTRIBUTE_VALUE" && sdRegion.getStartOffset(valueRegion) <= documentPosition ? this.newContentAssistRequest((Node)nodeAtOffset, (Node)node, sdRegion, valueRegion, sdRegion.getStartOffset(valueRegion), valueRegion.getTextLength(), matchString) : this.newContentAssistRequest((Node)nodeAtOffset, (Node)node, sdRegion, completionRegion, documentPosition, 0, matchString);
        this.addAttributeValueProposals(contentAssistRequest);
        return contentAssistRequest;
    }

    protected ContentAssistRequest computeStartDocumentProposals(int documentPosition, String matchString, ITextRegion completionRegion, IDOMNode nodeAtOffset, IDOMNode node) {
        ContentAssistRequest contentAssistRequest = null;
        contentAssistRequest = this.newContentAssistRequest((Node)nodeAtOffset, (Node)node, this.getStructuredDocumentRegion(documentPosition), completionRegion, documentPosition, 0, matchString);
        this.addStartDocumentProposals(contentAssistRequest);
        return contentAssistRequest;
    }

    protected ContentAssistRequest computeTagCloseProposals(int documentPosition, String matchString, ITextRegion completionRegion, IDOMNode nodeAtOffset, IDOMNode node) {
        ContentAssistRequest contentAssistRequest = null;
        IStructuredDocumentRegion sdRegion = this.getStructuredDocumentRegion(documentPosition);
        if (node.getNodeType() == 9 || documentPosition >= sdRegion.getEndOffset()) {
            if (node == nodeAtOffset && node.getParentNode() != null) {
                node = (IDOMNode)node.getParentNode();
            }
            contentAssistRequest = this.newContentAssistRequest((Node)nodeAtOffset, (Node)node, sdRegion, completionRegion, documentPosition, 0, matchString);
            this.addTagInsertionProposals(contentAssistRequest, this.getElementPositionForModelQuery((Node)nodeAtOffset));
            if (node.getNodeType() != 9 && node.getEndStructuredDocumentRegion() == null) {
                this.addEndTagProposals(contentAssistRequest);
            }
        } else {
            boolean insideTag;
            ITextRegion closeRegion = sdRegion.getLastRegion();
            boolean bl = insideTag = !sdRegion.isEnded() || documentPosition <= sdRegion.getStartOffset(closeRegion);
            if (insideTag) {
                contentAssistRequest = this.newContentAssistRequest((Node)nodeAtOffset, (Node)node, sdRegion, completionRegion, documentPosition, 0, matchString);
                if (node.getNodeType() != 9 && node.getEndStructuredDocumentRegion() != null) {
                    this.addTagCloseProposals(contentAssistRequest);
                }
                if (sdRegion == nodeAtOffset.getFirstStructuredDocumentRegion()) {
                    contentAssistRequest.setReplacementBeginPosition(documentPosition);
                    contentAssistRequest.setReplacementLength(0);
                    this.addAttributeNameProposals(contentAssistRequest);
                }
            }
        }
        return contentAssistRequest;
    }

    protected ContentAssistRequest computeTagNameProposals(int documentPosition, String matchString, ITextRegion completionRegion, IDOMNode nodeAtOffset, IDOMNode node) {
        ContentAssistRequest contentAssistRequest = null;
        IStructuredDocumentRegion sdRegion = this.getStructuredDocumentRegion(documentPosition);
        if (sdRegion != nodeAtOffset.getFirstStructuredDocumentRegion()) {
            IDOMNode actualNode = (IDOMNode)node.getModel().getIndexedRegion(sdRegion.getStartOffset(completionRegion));
            if (actualNode != null) {
                if (actualNode.getFirstStructuredDocumentRegion() == sdRegion) {
                    if (documentPosition > sdRegion.getStartOffset(completionRegion) + completionRegion.getLength()) {
                        contentAssistRequest = this.newContentAssistRequest((Node)actualNode, (Node)actualNode, sdRegion, completionRegion, documentPosition - matchString.length(), matchString.length(), matchString);
                        if (node.getStructuredDocument().getRegionAtCharacterOffset(sdRegion.getStartOffset(completionRegion) - 1).getRegionAtCharacterOffset(sdRegion.getStartOffset(completionRegion) - 1).getType() == "XML_TAG_OPEN") {
                            this.addAttributeNameProposals(contentAssistRequest);
                        }
                        this.addTagCloseProposals(contentAssistRequest);
                    } else {
                        contentAssistRequest = this.newContentAssistRequest((Node)actualNode, actualNode.getParentNode(), sdRegion, completionRegion, documentPosition - matchString.length(), matchString.length(), matchString);
                        this.addTagNameProposals(contentAssistRequest, this.getElementPositionForModelQuery((Node)actualNode));
                    }
                } else {
                    contentAssistRequest = documentPosition >= sdRegion.getStartOffset(completionRegion) + completionRegion.getLength() ? this.newContentAssistRequest((Node)actualNode, actualNode.getParentNode(), sdRegion, completionRegion, documentPosition, 0, matchString) : this.newContentAssistRequest((Node)actualNode, actualNode.getParentNode(), sdRegion, completionRegion, sdRegion.getStartOffset(completionRegion), completionRegion.getTextLength(), matchString);
                    this.addEndTagNameProposals(contentAssistRequest);
                }
            }
        } else if (documentPosition > sdRegion.getStartOffset(completionRegion) + completionRegion.getTextLength()) {
            contentAssistRequest = this.newContentAssistRequest((Node)nodeAtOffset, (Node)node, sdRegion, completionRegion, documentPosition - matchString.length(), matchString.length(), matchString);
            this.addAttributeNameProposals(contentAssistRequest);
            this.addTagCloseProposals(contentAssistRequest);
        } else if (sdRegion.getRegions().get(0).getType() != "XML_END_TAG_OPEN") {
            int replaceLength = documentPosition - sdRegion.getStartOffset(completionRegion);
            contentAssistRequest = this.newContentAssistRequest((Node)node, node.getParentNode(), sdRegion, completionRegion, sdRegion.getStartOffset(completionRegion), replaceLength, matchString);
            this.addTagNameProposals(contentAssistRequest, this.getElementPositionForModelQuery((Node)nodeAtOffset));
        } else {
            IDOMNode actualNode = (IDOMNode)node.getModel().getIndexedRegion(documentPosition);
            if (actualNode != null) {
                contentAssistRequest = documentPosition >= sdRegion.getStartOffset(completionRegion) + completionRegion.getTextLength() ? this.newContentAssistRequest((Node)actualNode, actualNode.getParentNode(), sdRegion, completionRegion, documentPosition, 0, matchString) : this.newContentAssistRequest((Node)actualNode, actualNode.getParentNode(), sdRegion, completionRegion, sdRegion.getStartOffset(completionRegion), completionRegion.getTextLength(), matchString);
                this.addEndTagNameProposals(contentAssistRequest);
            }
        }
        return contentAssistRequest;
    }

    protected ContentAssistRequest computeTagOpenProposals(int documentPosition, String matchString, ITextRegion completionRegion, IDOMNode nodeAtOffset, IDOMNode node) {
        ContentAssistRequest contentAssistRequest = null;
        IStructuredDocumentRegion sdRegion = this.getStructuredDocumentRegion(documentPosition);
        if (sdRegion != nodeAtOffset.getFirstStructuredDocumentRegion()) {
            IDOMNode actualNode = (IDOMNode)node.getModel().getIndexedRegion(sdRegion.getStartOffset(completionRegion));
            if (actualNode != null) {
                contentAssistRequest = this.newContentAssistRequest((Node)actualNode, actualNode.getParentNode(), sdRegion, completionRegion, documentPosition, 0, matchString);
                this.addTagNameProposals(contentAssistRequest, this.getElementPositionForModelQuery((Node)actualNode));
                this.addEndTagProposals(contentAssistRequest);
            }
        } else if (documentPosition == sdRegion.getStartOffset(completionRegion)) {
            if (node.getNodeType() == 1) {
                contentAssistRequest = this.newContentAssistRequest((Node)nodeAtOffset, node.getParentNode(), sdRegion, completionRegion, documentPosition, 0, matchString);
                this.addTagInsertionProposals(contentAssistRequest, this.getElementPositionForModelQuery((Node)nodeAtOffset));
                this.addEndTagProposals(contentAssistRequest);
            } else if (node.getNodeType() == 9) {
                contentAssistRequest = this.newContentAssistRequest((Node)nodeAtOffset, node.getParentNode(), sdRegion, completionRegion, sdRegion.getStartOffset(completionRegion), completionRegion.getTextLength(), matchString);
                this.addStartDocumentProposals(contentAssistRequest);
            }
        } else {
            ITextRegion name = this.getNameRegion(node.getStartStructuredDocumentRegion());
            if (name != null && sdRegion.getStartOffset(name) <= documentPosition && sdRegion.getEndOffset(name) >= documentPosition) {
                contentAssistRequest = this.newContentAssistRequest((Node)node, node.getParentNode(), sdRegion, completionRegion, sdRegion.getStartOffset(name), name.getTextLength(), matchString);
            } else {
                contentAssistRequest = this.newContentAssistRequest((Node)nodeAtOffset, nodeAtOffset.getParentNode(), sdRegion, completionRegion, documentPosition, 0, matchString);
                this.addEndTagProposals(contentAssistRequest);
                contentAssistRequest.setReplacementBeginPosition(documentPosition);
                contentAssistRequest.setReplacementLength(0);
            }
            this.addTagNameProposals(contentAssistRequest, this.getElementPositionForModelQuery((Node)nodeAtOffset));
        }
        return contentAssistRequest;
    }

    protected String getAdditionalInfo(CMNode parentOrOwner, CMNode cmnode) {
        String addlInfo = null;
        if (cmnode == null) {
            return null;
        }
        addlInfo = this.getInfoProvider().getInfo(cmnode);
        if (addlInfo == null && parentOrOwner != null) {
            addlInfo = this.getInfoProvider().getInfo(parentOrOwner);
        }
        return addlInfo;
    }

    protected List getAvailableChildrenAtIndex(Element parent, int index, int validityChecking) {
        ArrayList list = new ArrayList();
        CMElementDeclaration parentDecl = this.getCMElementDeclaration(parent);
        if (parentDecl != null) {
            ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)parent.getOwnerDocument());
            int editMode = 0;
            int ic = editMode == 2 ? 6 : 2;
            modelQuery.getInsertActions(parent, parentDecl, index, ic, validityChecking, list);
        }
        return list;
    }

    protected List getAvailableRootChildren(Document document, int childIndex) {
        ArrayList<CMElementDeclaration> list = null;
        DocumentType docType = document.getDoctype();
        String rootName = null;
        if (docType != null) {
            rootName = docType.getNodeName();
        }
        if (rootName == null) {
            return new ArrayList(0);
        }
        Node child = document.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1 && this.stringsEqual(child.getNodeName(), rootName) && (!(child instanceof IDOMNode) || ((IDOMNode)child).getStartStructuredDocumentRegion() != null && ((IDOMNode)child).getEndStructuredDocumentRegion() != null)) {
                this.setErrorMessage(NLS.bind((String)XMLUIMessages.The_document_element__, (Object[])new Object[]{rootName}));
                return new ArrayList(0);
            }
            child = child.getNextSibling();
        }
        list = new ArrayList<CMElementDeclaration>(1);
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)document);
        if (modelQuery != null) {
            CMDocument cmdoc = modelQuery.getCorrespondingCMDocument((Node)document);
            if (cmdoc != null) {
                if (rootName != null) {
                    CMElementDeclaration rootDecl = (CMElementDeclaration)cmdoc.getElements().getNamedItem(rootName);
                    if (rootDecl != null) {
                        list.add(rootDecl);
                    } else {
                        list.add(new SimpleCMElementDeclaration(rootName));
                        String location = (docType.getPublicId() != null ? String.valueOf(docType.getPublicId()) + "/" : "") + (docType.getSystemId() != null ? docType.getSystemId() : "");
                        if (location.length() > 0) {
                            this.setErrorMessage(NLS.bind((String)XMLUIMessages.No_definition_for_in, (Object[])new Object[]{rootName, location}));
                        } else {
                            this.setErrorMessage(NLS.bind((String)XMLUIMessages.No_definition_for, (Object[])new Object[]{rootName}));
                        }
                    }
                }
            } else {
                String location = (docType.getPublicId() != null ? String.valueOf(docType.getPublicId()) + "/" : "") + (docType.getSystemId() != null ? docType.getSystemId() : "");
                if (location.length() > 0) {
                    this.setErrorMessage(NLS.bind((String)XMLUIMessages.No_content_model_for, (Object[])new Object[]{location}));
                } else {
                    this.setErrorMessage(XMLUIMessages.No_content_model_found_UI_);
                }
            }
        }
        return list;
    }

    protected CMElementDeclaration getCMElementDeclaration(Node node) {
        ModelQuery modelQuery;
        CMElementDeclaration result = null;
        if (node.getNodeType() == 1 && (modelQuery = ModelQueryUtil.getModelQuery((Document)node.getOwnerDocument())) != null) {
            result = modelQuery.getCMElementDeclaration((Element)node);
        }
        return result;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.completionProposalAutoActivationCharacters;
    }

    protected ITextRegion getCompletionRegion(int offset, IStructuredDocumentRegion sdRegion) {
        ITextRegion nextRegion;
        ITextRegion previousRegion;
        ITextRegion region = sdRegion.getRegionAtCharacterOffset(offset);
        if (region == null) {
            return null;
        }
        if (sdRegion.getStartOffset(region) == offset) {
            if (sdRegion.getStartOffset(region) == sdRegion.getStartOffset() && sdRegion.getPrevious() != null && !sdRegion.getPrevious().isEnded()) {
                region = sdRegion.getPrevious().getRegionAtCharacterOffset(offset - 1);
            } else {
                previousRegion = sdRegion.getRegionAtCharacterOffset(offset - 1);
                if (previousRegion != null && previousRegion != region && previousRegion.getTextLength() == previousRegion.getLength()) {
                    region = previousRegion;
                }
            }
        } else if (offset > sdRegion.getStartOffset(region) + region.getTextLength() && (nextRegion = sdRegion.getRegionAtCharacterOffset(sdRegion.getStartOffset(region) + region.getLength())) != null) {
            region = nextRegion;
        }
        if (region != null && region.getType() == "WHITE_SPACE" && (previousRegion = sdRegion.getRegionAtCharacterOffset(sdRegion.getStartOffset(region) - 1)) != null) {
            region = previousRegion;
        }
        return region;
    }

    protected ITextRegion getCompletionRegion(int documentPosition, Node domnode) {
        if (domnode == null) {
            return null;
        }
        ITextRegion region = null;
        int offset = documentPosition;
        IStructuredDocumentRegion flatNode = null;
        IDOMNode node = (IDOMNode)domnode;
        if (node.getNodeType() == 9) {
            if (node.getStructuredDocument().getLength() == 0) {
                return null;
            }
            ITextRegion result = node.getStructuredDocument().getRegionAtCharacterOffset(offset).getRegionAtCharacterOffset(offset);
            while (result == null) {
                result = node.getStructuredDocument().getRegionAtCharacterOffset(--offset).getRegionAtCharacterOffset(offset);
            }
            return result;
        }
        IStructuredDocumentRegion startTag = node.getStartStructuredDocumentRegion();
        IStructuredDocumentRegion endTag = node.getEndStructuredDocumentRegion();
        if (startTag != null && startTag.getStartOffset() <= offset && offset < startTag.getStartOffset() + startTag.getLength()) {
            flatNode = startTag;
        } else if (endTag != null && endTag.getStartOffset() <= offset && offset < endTag.getStartOffset() + endTag.getLength()) {
            flatNode = endTag;
        }
        region = flatNode != null ? this.getCompletionRegion(offset, flatNode) : ((flatNode = node.getStructuredDocument().getRegionAtCharacterOffset(offset)).getStartOffset() <= documentPosition && flatNode.getEndOffset() >= documentPosition ? (offset == flatNode.getStartOffset() && flatNode.getPrevious() != null && (flatNode.getRegionAtCharacterOffset(documentPosition) != null && flatNode.getRegionAtCharacterOffset(documentPosition).getType() != "XML_CONTENT" || flatNode.getPrevious().getLastRegion().getType() == "XML_TAG_OPEN" || flatNode.getPrevious().getLastRegion().getType() == "XML_END_TAG_OPEN") ? flatNode.getPrevious().getLastRegion() : (flatNode.getEndOffset() == documentPosition ? flatNode.getLastRegion() : flatNode.getFirstRegion())) : flatNode.getLastRegion());
        return region;
    }

    public XMLContentModelGenerator getContentGenerator() {
        if (this.fGenerator == null) {
            this.fGenerator = new XMLContentModelGenerator();
        }
        return this.fGenerator;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return this.contextInformationAutoActivationCharacters;
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this.fContextInformationPresenter == null) {
            this.fContextInformationPresenter = new AttributeContextInformationPresenter();
        }
        return this.fContextInformationPresenter;
    }

    protected int getElementPosition(Node child) {
        Node parent = child.getParentNode();
        if (parent == null) {
            return 0;
        }
        NodeList children = parent.getChildNodes();
        if (children == null) {
            return 0;
        }
        int count = 0;
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i) == child) {
                return count;
            }
            ++count;
            ++i;
        }
        return 0;
    }

    private int getElementPositionForModelQuery(Node child) {
        return this.getElementPosition(child);
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public MarkupTagInfoProvider getInfoProvider() {
        if (this.fInfoProvider == null) {
            this.fInfoProvider = new MarkupTagInfoProvider();
        }
        return this.fInfoProvider;
    }

    protected String getMatchString(IStructuredDocumentRegion parent, ITextRegion aRegion, int offset) {
        if (aRegion == null || this.isCloseRegion(aRegion)) {
            return "";
        }
        String matchString = null;
        String regionType = aRegion.getType();
        matchString = regionType == "XML_TAG_ATTRIBUTE_EQUALS" || regionType == "XML_TAG_OPEN" || offset > parent.getStartOffset(aRegion) + aRegion.getTextLength() ? "" : (regionType == "XML_CONTENT" ? "" : (parent.getText(aRegion).length() > 0 && parent.getStartOffset(aRegion) < offset ? parent.getText(aRegion).substring(0, offset - parent.getStartOffset(aRegion)) : ""));
        return matchString;
    }

    protected ITextRegion getNameRegion(IStructuredDocumentRegion flatNode) {
        if (flatNode == null) {
            return null;
        }
        Iterator regionList = flatNode.getRegions().iterator();
        while (regionList.hasNext()) {
            ITextRegion region = (ITextRegion)regionList.next();
            if (!this.isNameRegion(region)) continue;
            return region;
        }
        return null;
    }

    protected List getPossibleDataTypeValues(Node node, CMAttributeDeclaration ad) {
        ArrayList<String> list = null;
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            String[] dataTypeValues = null;
            ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument());
            if (modelQuery != null) {
                dataTypeValues = modelQuery.getPossibleDataTypeValues(element, (CMNode)ad);
            } else if (ad.getAttrType() != null) {
                dataTypeValues = ad.getAttrType().getEnumeratedValues();
            }
            if (dataTypeValues != null) {
                list = new ArrayList(dataTypeValues.length);
                int i = 0;
                while (i < dataTypeValues.length) {
                    list.add(dataTypeValues[i]);
                    ++i;
                }
            }
        }
        if (list == null) {
            list = new ArrayList<String>(0);
        }
        return list;
    }

    protected String getRequiredName(Node parentOrOwner, CMNode cmnode) {
        if (cmnode == null || parentOrOwner == null) {
            return "";
        }
        return this.getContentGenerator().getRequiredName(parentOrOwner, cmnode);
    }

    protected String getRequiredText(Node parentOrOwner, CMAttributeDeclaration attrDecl) {
        if (attrDecl == null) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        this.getContentGenerator().generateRequiredAttribute(parentOrOwner, attrDecl, buff);
        return buff.toString();
    }

    protected String getRequiredText(Node parentOrOwner, CMElementDeclaration elementDecl) {
        if (elementDecl == null) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        this.getContentGenerator().generateTag(parentOrOwner, elementDecl, buff);
        return buff.toString();
    }

    public IStructuredDocumentRegion getStructuredDocumentRegion(int pos) {
        return ContentAssistUtils.getStructuredDocumentRegion((ITextViewer)this.fTextViewer, (int)pos);
    }

    private String getTagName(IStructuredDocumentRegion sdRegion) {
        ITextRegionList regions = sdRegion.getRegions();
        ITextRegion region = null;
        String name = "";
        int i = 0;
        while (i < regions.size()) {
            region = regions.get(i);
            if (region.getType() == "XML_TAG_NAME") {
                name = sdRegion.getText(region);
                break;
            }
            ++i;
        }
        return name;
    }

    protected List getAvailableChildElementDeclarations(Element parent, int childPosition, int kindOfAction) {
        List modelQueryActions = this.getAvailableChildrenAtIndex(parent, childPosition, 0);
        Iterator iterator = modelQueryActions.iterator();
        Vector<CMNode> cmnodes = new Vector<CMNode>();
        while (iterator.hasNext()) {
            CMNode actionCMNode;
            ModelQueryAction action = (ModelQueryAction)iterator.next();
            if (childPosition >= 0 && (action.getStartIndex() > childPosition || childPosition > action.getEndIndex() || action.getKind() != kindOfAction) || (actionCMNode = action.getCMNode()) == null || cmnodes.contains(actionCMNode)) continue;
            cmnodes.add(actionCMNode);
        }
        return cmnodes;
    }

    protected List getValidChildElementDeclarations(Element parent, int childPosition, int kindOfAction) {
        List modelQueryActions = this.getAvailableChildrenAtIndex(parent, childPosition, 2);
        Iterator iterator = modelQueryActions.iterator();
        Vector<CMNode> cmnodes = new Vector<CMNode>();
        while (iterator.hasNext()) {
            CMNode actionCMNode;
            ModelQueryAction action = (ModelQueryAction)iterator.next();
            if (childPosition >= 0 && (action.getStartIndex() > childPosition || childPosition > action.getEndIndex() || action.getKind() != kindOfAction) || (actionCMNode = action.getCMNode()) == null || cmnodes.contains(actionCMNode)) continue;
            cmnodes.add(actionCMNode);
        }
        return cmnodes;
    }

    protected boolean getXML(Node node) {
        if (node == null) {
            return false;
        }
        Document doc = null;
        Document document = doc = node.getNodeType() != 9 ? node.getOwnerDocument() : (Document)node;
        return doc instanceof IDOMDocument && ((IDOMDocument)doc).isXMLType();
    }

    protected void init() {
    }

    protected boolean isCloseRegion(ITextRegion region) {
        String type = region.getType();
        return type == "XML_PI_CLOSE" || type == "XML_TAG_CLOSE" || type == "XML_EMPTY_TAG_CLOSE" || type == "XML_CDATA_CLOSE" || type == "XML_COMMENT_CLOSE" || type == "XML_ATTLIST_DECL_CLOSE" || type == "XML_ELEMENT_DECL_CLOSE" || type == "XML_DOCTYPE_DECLARATION_CLOSE" || type == "JSP_CLOSE" || type == "JSP_COMMENT_CLOSE" || type.equals("JSP_DIRECTIVE_CLOSE") || type == "XML_DECLARATION_CLOSE";
    }

    private boolean isCommentNode(IDOMNode node) {
        return node != null && node instanceof IDOMElement && ((IDOMElement)node).isCommentTag();
    }

    protected boolean isCursorAfterDoctype(ContentAssistRequest car) {
        Node aNode = car.getNode();
        Document parent = aNode.getOwnerDocument();
        int xmldoctypeNodePosition = -1;
        boolean isAfterDoctype = true;
        if (parent == null) {
            return true;
        }
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child instanceof IDOMNode && child.getNodeType() == 10) {
                xmldoctypeNodePosition = ((IDOMNode)child).getEndOffset();
                isAfterDoctype = car.getReplacementBeginPosition() >= xmldoctypeNodePosition;
                break;
            }
            child = child.getNextSibling();
        }
        return isAfterDoctype;
    }

    protected boolean isCursorAfterXMLPI(ContentAssistRequest car) {
        Node aNode = car.getNode();
        boolean xmlpiFound = false;
        Document parent = aNode.getOwnerDocument();
        int xmlpiNodePosition = -1;
        boolean isAfterXMLPI = false;
        if (parent == null) {
            return true;
        }
        Node child = parent.getFirstChild();
        while (child != null) {
            boolean xmlpi = child.getNodeType() == 7 && child.getNodeName().equals("xml");
            boolean bl = xmlpiFound = xmlpiFound || xmlpi;
            if (xmlpiFound) {
                if (!(child instanceof IDOMNode)) break;
                xmlpiNodePosition = ((IDOMNode)child).getEndOffset();
                isAfterXMLPI = car.getReplacementBeginPosition() >= xmlpiNodePosition;
                break;
            }
            child = child.getNextSibling();
        }
        return isAfterXMLPI;
    }

    protected boolean isNameRegion(ITextRegion region) {
        String type = region.getType();
        return type == "XML_TAG_NAME" || type == "JSP_DIRECTIVE_NAME" || type == "XML_ELEMENT_DECL_NAME" || type == "XML_DOCTYPE_NAME" || type == "XML_ATTLIST_DECL_NAME" || type == "JSP_ROOT_TAG_NAME" || type.equals("JSP_DIRECTIVE_NAME");
    }

    protected boolean isQuote(String string) {
        String trimmed = string.trim();
        if (trimmed.length() > 0) {
            return trimmed.charAt(0) == '\'' || trimmed.charAt(0) == '\"';
        }
        return false;
    }

    private boolean isSelfClosed(IStructuredDocumentRegion startTag) {
        ITextRegionList regions = startTag.getRegions();
        return regions.get(regions.size() - 1).getType() == "XML_EMPTY_TAG_CLOSE";
    }

    private boolean isStartTag(IStructuredDocumentRegion sdRegion) {
        boolean result = false;
        if (sdRegion.getRegions().size() > 0) {
            ITextRegion r = sdRegion.getRegions().get(0);
            result = r.getType() == "XML_TAG_OPEN" && sdRegion.isEnded();
        }
        return result;
    }

    protected Properties mapToProperties(CMNamedNodeMap map) {
        Properties p = new Properties();
        int i = 0;
        while (i < map.getLength()) {
            CMEntityDeclaration decl = (CMEntityDeclaration)map.item(i);
            p.put(decl.getName(), decl.getValue());
            ++i;
        }
        return p;
    }

    /*
     * Exception decompiling
     */
    private boolean needsEndTag(IStructuredDocumentRegion startTag) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 123->126)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected ContentAssistRequest newContentAssistRequest(Node node, Node possibleParent, IStructuredDocumentRegion documentRegion, ITextRegion completionRegion, int begin, int length, String filter) {
        return new ContentAssistRequest(node, possibleParent, documentRegion, completionRegion, begin, length, filter);
    }

    public void release() {
        this.fGenerator = null;
    }

    public void setErrorMessage(String errorMessage) {
        this.fErrorMessage = errorMessage;
    }

    protected void setErrorMessage(String errorMessage, String append) {
        this.setErrorMessage(String.valueOf(errorMessage) + append);
    }

    protected void setErrorMessage(String errorMessage, String prepend, String append) {
        this.setErrorMessage(String.valueOf(prepend) + errorMessage + append);
    }

    protected boolean stringsEqual(String a, String b) {
        return a.equalsIgnoreCase(b);
    }

    private class DOMJSPRegionContextsPrivateCopy {
        private static final String JSP_CLOSE = "JSP_CLOSE";
        private static final String JSP_COMMENT_CLOSE = "JSP_COMMENT_CLOSE";
        private static final String JSP_COMMENT_OPEN = "JSP_COMMENT_OPEN";
        private static final String JSP_DECLARATION_OPEN = "JSP_DECLARATION_OPEN";
        private static final String JSP_DIRECTIVE_CLOSE = "JSP_DIRECTIVE_CLOSE";
        private static final String JSP_DIRECTIVE_NAME = "JSP_DIRECTIVE_NAME";
        private static final String JSP_DIRECTIVE_OPEN = "JSP_DIRECTIVE_OPEN";
        private static final String JSP_EXPRESSION_OPEN = "JSP_EXPRESSION_OPEN";
        private static final String JSP_ROOT_TAG_NAME = "JSP_ROOT_TAG_NAME";
        private static final String JSP_SCRIPTLET_OPEN = "JSP_SCRIPTLET_OPEN";

        private DOMJSPRegionContextsPrivateCopy() {
        }
    }
}

