/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.dialogfield;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jst.jsf.common.ui.JSFUICommonPlugin;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.JavaClassWizardPage;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class JavaClassWizard
extends Wizard {
    private static String STORE_SECTION = "JavaClassWizard";
    private JavaClassWizardPage _mainPage;
    private String _className;
    private String _classArgs;
    private IProject _project;
    private String _superClass;
    private List _interfaceList;
    private boolean _autoOpenResource = true;

    public void setAutoOpenResource(boolean autoOpenResource) {
        this._autoOpenResource = autoOpenResource;
    }

    public JavaClassWizard(IProject project, String className) {
        this(project, className, null, null);
    }

    public JavaClassWizard(IProject project, String className, String superClass, List superInterfaces) {
        this._project = project;
        this._className = className;
        this._superClass = superClass;
        this._interfaceList = superInterfaces;
        IDialogSettings masterSettings = JSFUICommonPlugin.getDefault().getDialogSettings();
        this.setDialogSettings(this.getSettingsSection(masterSettings));
        this.setWindowTitle(JSFUICommonPlugin.getResourceString("DialogField.JavaClassWizard.NewClass"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this._mainPage = new JavaClassWizardPage(this._project, this._className, this._superClass, this._interfaceList);
        this.addPage((IWizardPage)this._mainPage);
        this._mainPage.init();
    }

    private IDialogSettings getSettingsSection(IDialogSettings master) {
        IDialogSettings setting = master.getSection(STORE_SECTION);
        if (setting == null) {
            setting = master.addNewSection(STORE_SECTION);
        }
        return setting;
    }

    public boolean performFinish() {
        if (this._mainPage.getPackageText() != null && this._mainPage.getPackageText().length() > 0) {
            StringBuffer buffer = new StringBuffer(this._mainPage.getPackageText());
            buffer.append(".");
            buffer.append(this._mainPage.getTypeName());
            this._className = buffer.toString();
        } else {
            this._className = this._mainPage.getTypeName();
        }
        this._classArgs = this._mainPage.getClassArgs();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                JavaClassWizard.this._mainPage.createType(monitor);
                IResource resource = JavaClassWizard.this._mainPage.getModifiedResource();
                if (resource != null && JavaClassWizard.this._autoOpenResource) {
                    JavaClassWizard.this.selectAndReveal(resource);
                    if (JavaClassWizard.this._project.hasNature("org.eclipse.jdt.core.javanature")) {
                        IJavaProject jProject = JavaCore.create((IProject)JavaClassWizard.this._project);
                        IJavaElement jElement = jProject.findElement(resource.getProjectRelativePath().removeFirstSegments(1));
                        if (jElement != null) {
                            JavaUI.openInEditor((IJavaElement)jElement);
                        }
                    } else if (resource instanceof IFile) {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)resource), (boolean)true);
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return true;
    }

    protected void selectAndReveal(IResource newResource) {
        BasicNewResourceWizard.selectAndReveal((IResource)newResource, (IWorkbenchWindow)this.getWorkbenchWindow());
    }

    private IWorkbenchWindow getWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    protected ISchedulingRule getSchedulingRule() {
        return this._mainPage.getModifiedResource();
    }

    public String getClassName() {
        return this._className;
    }

    public String getClassNameWithArgs() {
        if (this._classArgs != null && this._classArgs.length() > 0) {
            StringBuffer buffer = new StringBuffer(this._className);
            buffer.append(":");
            buffer.append(this._classArgs);
            return buffer.toString();
        }
        return this.getClassName();
    }
}

