/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.providers;

import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.virtual.IKnownConnectionNode;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.content.ServerExplorerConnectionManagedListener;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.services.IServerExplorerContentService;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.services.IServerExplorerNavigationService;

public class ServerExplorerManager {
    public static final ServerExplorerManager INSTANCE = new ServerExplorerManager();
    private IKnownConnectionNode knownServer;
    private IServerExplorerContentService serverExplorerService;
    private ServerExplorerConnectionManagedListener connectionListener;

    private void initializeListeners() {
    }

    private void removeListeners() {
        if (this.connectionListener != null) {
            this.connectionListener.dispose();
            this.connectionListener = null;
        }
    }

    public void setServerExplorerService(IServerExplorerContentService serverExplorerService) {
        this.serverExplorerService = serverExplorerService;
        if (this.serverExplorerService != null) {
            this.initializeListeners();
        } else {
            this.removeListeners();
            if (this.knownServer != null) {
                this.knownServer.removeAllChildren();
            }
        }
    }

    public void setRootKnownServerNode(IKnownConnectionNode knownServer) {
        this.knownServer = knownServer;
    }

    public IKnownConnectionNode getRootKnownServerNode() {
        return this.knownServer;
    }

    public void initializeConnectionInfo(ConnectionInfo info) {
        this.connectionListener.connectionInfoCreated(info);
    }

    public IServerExplorerContentService getServerExplorerContentService() {
        return this.serverExplorerService;
    }

    public IServerExplorerNavigationService getServerExplorerNavigationService() {
        return (IServerExplorerNavigationService)((Object)this.serverExplorerService);
    }
}

