/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Iterator;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jpt.core.internal.mappings.INonOwningMapping;
import org.eclipse.jpt.core.internal.mappings.IRelationshipMapping;
import org.eclipse.jpt.ui.internal.details.BaseJpaController;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class MappedByCombo
extends BaseJpaController {
    private INonOwningMapping nonOwningMapping;
    private Adapter nonOwningMappingListener = this.buildListener();
    private CCombo combo;

    public MappedByCombo(Composite parent, CommandStack commandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, commandStack, widgetFactory);
    }

    private Adapter buildListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                MappedByCombo.this.nonOwningMappingChanged(notification);
            }
        };
    }

    protected void buildWidget(Composite parent) {
        this.combo = this.getWidgetFactory().createCCombo(parent, 0x800000);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.combo, "org.eclipse.jpt.ui.mapping_mappedBy");
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (MappedByCombo.this.isPopulating()) {
                    return;
                }
                String mappedBy = ((CCombo)e.getSource()).getText();
                if (mappedBy.equals("")) {
                    mappedBy = null;
                    if (MappedByCombo.this.getNonOwningMapping().getMappedBy() == null || MappedByCombo.this.getNonOwningMapping().getMappedBy().equals("")) {
                        return;
                    }
                }
                if (MappedByCombo.this.getNonOwningMapping().getMappedBy() == null || !MappedByCombo.this.getNonOwningMapping().getMappedBy().equals(mappedBy)) {
                    MappedByCombo.this.getNonOwningMapping().setMappedBy(mappedBy);
                }
            }
        });
    }

    private INonOwningMapping getNonOwningMapping() {
        return this.nonOwningMapping;
    }

    protected void doPopulate(EObject obj) {
        this.nonOwningMapping = (INonOwningMapping)obj;
        if (this.nonOwningMapping == null) {
            return;
        }
        this.populateCombo();
    }

    private void populateCombo() {
        this.populateChoices();
        this.populateMappedByText();
    }

    private void populateChoices() {
        if (this.combo.getItemCount() > 0) {
            this.combo.removeAll();
        }
        Iterator i = this.nonOwningMapping.candidateMappedByAttributeNames();
        while (i.hasNext()) {
            this.combo.add((String)i.next());
        }
    }

    private void populateMappedByText() {
        String mappedBy = this.nonOwningMapping.getMappedBy();
        if (mappedBy != null && !this.combo.getText().equals(mappedBy)) {
            this.combo.setText(mappedBy);
        }
    }

    protected void doPopulate() {
    }

    protected void engageListeners() {
        if (this.nonOwningMapping != null) {
            this.nonOwningMapping.eAdapters().add((Object)this.nonOwningMappingListener);
        }
    }

    protected void disengageListeners() {
        if (this.nonOwningMapping != null) {
            this.nonOwningMapping.eAdapters().remove((Object)this.nonOwningMappingListener);
        }
    }

    protected void nonOwningMappingChanged(Notification notification) {
        if (notification.getFeatureID(INonOwningMapping.class) == 5) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (MappedByCombo.this.getControl().isDisposed()) {
                        return;
                    }
                    MappedByCombo.this.populateMappedByText();
                }
            });
        } else if (notification.getFeatureID(IRelationshipMapping.class) == 3) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (MappedByCombo.this.getControl().isDisposed()) {
                        return;
                    }
                    MappedByCombo.this.populateChoices();
                }
            });
        }
    }

    public Control getControl() {
        return this.combo;
    }
}

