/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Iterator;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jpt.core.internal.mappings.ITable;
import org.eclipse.jpt.db.internal.Connection;
import org.eclipse.jpt.db.internal.ConnectionListener;
import org.eclipse.jpt.db.internal.ConnectionProfile;
import org.eclipse.jpt.db.internal.Database;
import org.eclipse.jpt.db.internal.Schema;
import org.eclipse.jpt.db.internal.Table;
import org.eclipse.jpt.ui.internal.details.BaseJpaController;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class TableCombo
extends BaseJpaController {
    private ITable table;
    private Adapter listener = this.buildTableListener();
    private ConnectionProfile connectionProfile;
    private ConnectionListener connectionListener = this.buildConnectionListener();
    private CCombo combo;

    public TableCombo(Composite parent, CommandStack theCommandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, theCommandStack, widgetFactory);
    }

    private Adapter buildTableListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                TableCombo.this.tableChanged(notification);
            }
        };
    }

    private ConnectionListener buildConnectionListener() {
        return new ConnectionListener(){

            public void aboutToClose(Connection connection) {
            }

            public void closed(Connection connection) {
                TableCombo.this.getCombo().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (TableCombo.this.getControl().isDisposed()) {
                            return;
                        }
                        TableCombo.this.populateTableCombo();
                    }
                });
            }

            public void modified(Connection connection) {
                TableCombo.this.getCombo().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (TableCombo.this.getControl().isDisposed()) {
                            return;
                        }
                        TableCombo.this.populateTableCombo();
                    }
                });
            }

            public boolean okToClose(Connection connection) {
                return true;
            }

            public void opened(Connection connection) {
                TableCombo.this.getCombo().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (TableCombo.this.getControl().isDisposed()) {
                            return;
                        }
                        TableCombo.this.populateTableCombo();
                    }
                });
            }

            public void databaseChanged(Connection connection, final Database database) {
                TableCombo.this.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (database == TableCombo.this.getDatabase() && !TableCombo.this.getControl().isDisposed()) {
                            TableCombo.this.populateTableCombo();
                        }
                    }
                });
            }

            public void schemaChanged(Connection connection, final Schema schema) {
                TableCombo.this.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (schema == TableCombo.this.getTableSchema() && !TableCombo.this.getControl().isDisposed()) {
                            TableCombo.this.populateTableCombo();
                        }
                    }
                });
            }

            public void tableChanged(Connection connection, Table table) {
            }
        };
    }

    protected void buildWidget(Composite parent) {
        this.combo = this.getWidgetFactory().createCCombo(parent, 0x800000);
        this.combo.add(JptUiMappingsMessages.TableComposite_defaultEmpty);
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TableCombo.this.isPopulating()) {
                    return;
                }
                String tableText = ((CCombo)e.getSource()).getText();
                if (tableText.equals("")) {
                    tableText = null;
                    if (TableCombo.this.table.getSpecifiedName() == null || TableCombo.this.table.getSpecifiedName().equals("")) {
                        return;
                    }
                }
                if (tableText != null && TableCombo.this.combo.getItemCount() > 0 && tableText.equals(TableCombo.this.combo.getItem(0))) {
                    tableText = null;
                }
                if (TableCombo.this.table.getSpecifiedName() == null && tableText != null) {
                    TableCombo.this.table.setSpecifiedName(tableText);
                }
                if (TableCombo.this.table.getSpecifiedName() != null && !TableCombo.this.table.getSpecifiedName().equals(tableText)) {
                    TableCombo.this.table.setSpecifiedName(tableText);
                }
            }
        });
    }

    protected void tableChanged(Notification notification) {
        if (notification.getFeatureID(ITable.class) == 1) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (TableCombo.this.getControl().isDisposed()) {
                        return;
                    }
                    TableCombo.this.populateTableName();
                }
            });
        } else if (notification.getFeatureID(ITable.class) == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (TableCombo.this.getControl().isDisposed()) {
                        return;
                    }
                    TableCombo.this.populateDefaultTableName();
                }
            });
        } else if (notification.getFeatureID(ITable.class) == 8) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (TableCombo.this.getControl().isDisposed()) {
                        return;
                    }
                    TableCombo.this.populateTableCombo();
                }
            });
        } else if (notification.getFeatureID(ITable.class) == 7) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (TableCombo.this.getControl().isDisposed()) {
                        return;
                    }
                    TableCombo.this.populateTableCombo();
                }
            });
        }
    }

    public void doPopulate(EObject obj) {
        this.table = (ITable)obj;
        if (this.table != null) {
            this.populateTableCombo();
        } else {
            this.connectionProfile = null;
        }
    }

    public void doPopulate() {
        if (this.table != null) {
            this.populateTableCombo();
        }
    }

    protected Database getDatabase() {
        return this.getConnectionProfile().getDatabase();
    }

    protected Schema getTableSchema() {
        return this.getConnectionProfile().getDatabase().schemaNamed(this.table.getSchema());
    }

    private ConnectionProfile getConnectionProfile() {
        if (this.connectionProfile == null) {
            this.connectionProfile = this.table.getJpaProject().connectionProfile();
        }
        return this.connectionProfile;
    }

    private void populateTableCombo() {
        if (this.table == null) {
            return;
        }
        this.populateDefaultTableName();
        if (this.getConnectionProfile().isConnected()) {
            this.combo.remove(1, this.combo.getItemCount() - 1);
            Schema schema = this.getTableSchema();
            if (schema != null) {
                Iterator tables = schema.tableNames();
                Iterator stream = CollectionTools.sort((Iterator)tables);
                while (stream.hasNext()) {
                    this.combo.add((String)stream.next());
                }
            }
        } else {
            this.combo.remove(1, this.combo.getItemCount() - 1);
        }
        this.populateTableName();
    }

    protected void populateDefaultTableName() {
        if (this.table == null) {
            return;
        }
        String defaultTableName = this.table.getDefaultName();
        int selectionIndex = this.combo.getSelectionIndex();
        this.combo.setItem(0, NLS.bind((String)JptUiMappingsMessages.TableComposite_defaultWithOneParam, (Object)defaultTableName));
        if (selectionIndex == 0) {
            this.combo.clearSelection();
            this.combo.select(0);
        }
    }

    protected void populateTableName() {
        if (this.table == null) {
            return;
        }
        String tableName = this.table.getSpecifiedName();
        String defaultTableName = this.table.getDefaultName();
        if (tableName != null) {
            if (!this.combo.getText().equals(tableName)) {
                this.combo.setText(tableName);
            }
        } else if (!this.combo.getText().equals(NLS.bind((String)JptUiMappingsMessages.TableComposite_defaultWithOneParam, (Object)defaultTableName))) {
            this.combo.select(0);
        }
    }

    public CCombo getCombo() {
        return this.combo;
    }

    public Control getControl() {
        return this.getCombo();
    }

    protected void disengageListeners() {
        if (this.table != null) {
            this.removeConnectionListener();
            this.table.eAdapters().remove((Object)this.listener);
        }
    }

    protected void engageListeners() {
        if (this.table != null) {
            this.table.eAdapters().add((Object)this.listener);
            this.addConnectionListener();
        }
    }

    private void addConnectionListener() {
        this.getConnectionProfile().addConnectionListener(this.connectionListener);
    }

    private void removeConnectionListener() {
        this.getConnectionProfile().removeConnectionListener(this.connectionListener);
    }
}

