/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.xml.details;

import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jpt.core.internal.content.orm.PersistenceUnitDefaults;
import org.eclipse.jpt.ui.internal.details.BaseJpaController;
import org.eclipse.jpt.ui.internal.xml.JptUiXmlMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class CascadePersistCheckBox
extends BaseJpaController {
    private PersistenceUnitDefaults persistenceUnitDefaults;
    private Adapter persistenceUnitDefaultsListener;
    private Button button;

    public CascadePersistCheckBox(Composite parent, CommandStack theCommandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, theCommandStack, widgetFactory);
        this.buildPeristenceUnitDefaultsListener();
    }

    private void buildPeristenceUnitDefaultsListener() {
        this.persistenceUnitDefaultsListener = new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                CascadePersistCheckBox.this.persistenceUnitDefaultsChanged(notification);
            }
        };
    }

    protected void buildWidget(Composite parent) {
        this.button = this.getWidgetFactory().createButton(parent, JptUiXmlMessages.XMLEntityMappingsPage_CascadePersistCheckBox, 32);
        this.button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                CascadePersistCheckBox.this.cascadePersistSelectionChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CascadePersistCheckBox.this.cascadePersistSelectionChanged();
            }
        });
    }

    void cascadePersistSelectionChanged() {
        boolean cascadePersist = this.button.getSelection();
        if (this.persistenceUnitDefaults.isCascadePersist() != cascadePersist) {
            this.persistenceUnitDefaults.setCascadePersist(cascadePersist);
        }
    }

    private void persistenceUnitDefaultsChanged(Notification notification) {
        if (notification.getFeatureID(PersistenceUnitDefaults.class) == 3) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    CascadePersistCheckBox.this.populate();
                }
            });
        }
    }

    protected void engageListeners() {
        if (this.persistenceUnitDefaults != null) {
            this.persistenceUnitDefaults.eAdapters().add((Object)this.persistenceUnitDefaultsListener);
        }
    }

    protected void disengageListeners() {
        if (this.persistenceUnitDefaults != null) {
            this.persistenceUnitDefaults.eAdapters().remove((Object)this.persistenceUnitDefaultsListener);
        }
    }

    public void doPopulate(EObject obj) {
        this.persistenceUnitDefaults = (PersistenceUnitDefaults)obj;
        this.populateButton();
    }

    protected void doPopulate() {
        this.populateButton();
    }

    private void populateButton() {
        boolean cascadePersist = false;
        if (this.persistenceUnitDefaults != null) {
            cascadePersist = this.persistenceUnitDefaults.isCascadePersist();
        }
        if (this.button.getSelection() != cascadePersist) {
            this.button.setSelection(cascadePersist);
        }
    }

    public Control getControl() {
        return this.button;
    }
}

