/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.launching;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.internal.core.phpIni.IniModifier;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.xdebug.GeneralUtils;
import org.eclipse.php.internal.debug.core.xdebug.IDELayer;
import org.eclipse.php.internal.debug.core.xdebug.IDELayerFactory;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpBreakpointFacade;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.DBGpSessionHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class XDebugExeLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        Object object;
        String string2;
        Serializable serializable;
        Path path;
        if (iProgressMonitor.isCanceled()) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(iLaunch);
            return;
        }
        IDELayer iDELayer = IDELayerFactory.getIDELayer();
        String string3 = iLaunchConfiguration.getAttribute(iDELayer.getEXELocationAttrName(), null);
        String string4 = iLaunchConfiguration.getAttribute(iDELayer.getEXEFileAttrName(), null);
        if (string4 == null || string4.trim().length() == 0) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(iLaunch);
            this.displayErrorMessage("No script specified");
            return;
        }
        if (iProgressMonitor.isCanceled()) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(iLaunch);
            return;
        }
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource iResource = iWorkspaceRoot.findMember((IPath)(path = new Path(string4)));
        if (iResource == null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(iLaunch);
            this.displayErrorMessage("Specified script cannot be found");
            return;
        }
        IProject iProject = iResource.getProject();
        boolean bl = false;
        bl = iLaunchConfiguration.getAttribute(iDELayer.getEXEOverrideFirstLineAttrName(), false) ? iLaunchConfiguration.getAttribute(iDELayer.getEXEFirstLineAttrName(), false) : iDELayer.getStopAtFirstLine(iProject);
        String string5 = iProject.getFullPath().toString();
        ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfiguration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)iLaunchConfiguration : iLaunchConfiguration.getWorkingCopy();
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.php.debug.core.PHP_Project", string5);
        if (iProgressMonitor.isCanceled()) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(iLaunch);
            return;
        }
        Path path2 = new Path(string3);
        IPath iPath = iProject.getRawLocation();
        if (iPath == null) {
            iPath = iProject.getLocation();
        }
        String string6 = iPath.toOSString();
        Path path3 = new Path(string6);
        File file = path3.toFile();
        Path path4 = new Path(string4);
        if (string4.startsWith("/")) {
            path4 = path4.removeFirstSegments(1);
        }
        if (iProgressMonitor.isCanceled()) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(iLaunch);
            return;
        }
        File file2 = IniModifier.findPHPIni((String)string3);
        if (iProject.hasNature("org.eclipse.php.core.PHPNature")) {
            if (file2 != null && (serializable = IniModifier.addIncludePath((File)file2, (IProject)iProject)) != null) {
                iLaunchConfigurationWorkingCopy.setAttribute("PHPIniLocation", ((File)serializable).getAbsolutePath());
            }
        } else if (file2 != null) {
            iLaunchConfigurationWorkingCopy.setAttribute("PHPIniLocation", file2.getAbsolutePath());
        }
        iLaunchConfigurationWorkingCopy.doSave();
        serializable = new HashMap();
        String string7 = path2.lastSegment();
        String string8 = path2.getFileExtension();
        if (string8 != null) {
            string7 = string7.substring(0, string7.length() - (string8.length() + 1));
        }
        string7 = string7.toLowerCase();
        serializable.put(IProcess.ATTR_PROCESS_TYPE, string7);
        serializable.put(IProcess.ATTR_CMDLINE, string4);
        if (iProgressMonitor.isCanceled()) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(iLaunch);
            return;
        }
        String[] stringArray = null;
        String[] stringArray2 = this.createCommandLine(iLaunchConfiguration, file.toString(), path2.toOSString(), path4.toOSString());
        DBGpTarget dBGpTarget = null;
        if (string.equals("debug")) {
            string2 = DBGpSessionHandler.getInstance().generateSessionId();
            object = DBGpSessionHandler.getInstance().getIDEKey();
            dBGpTarget = new DBGpTarget(iLaunch, path4.toOSString(), (String)object, string2, bl);
            DBGpSessionHandler.getInstance().addSessionListener(dBGpTarget);
            stringArray = this.createDebugLaunchEnvironment(iLaunchConfiguration, string2, (String)object);
        } else {
            stringArray = PHPLaunchUtilities.getEnvironment(iLaunchConfiguration, null);
        }
        string2 = new SubProgressMonitor(iProgressMonitor, 30);
        string2.beginTask("Launching script", 10);
        object = DebugPlugin.exec((String[])stringArray2, (File)file, (String[])stringArray);
        IProcess iProcess = null;
        if (object != null) {
            string2.worked(10);
            iProcess = DebugPlugin.newProcess((ILaunch)iLaunch, (Process)object, (String)path2.toOSString(), (Map)((Object)serializable));
            if (iProcess == null) {
                ((Process)object).destroy();
                string2.done();
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(iLaunch);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.php.debug.core", 0, null, null));
            }
            if (string.equals("debug") && dBGpTarget != null) {
                dBGpTarget.setProcess(iProcess);
                iLaunch.addDebugTarget((IDebugTarget)dBGpTarget);
                string2.subTask("waiting for XDebug session");
                dBGpTarget.waitForInitialSession((DBGpBreakpointFacade)((Object)IDELayerFactory.getIDELayer()), GeneralUtils.createSessionPreferences(), iProgressMonitor);
            }
        } else {
            if (string.equals("debug")) {
                DBGpSessionHandler.getInstance().removeSessionListener(dBGpTarget);
            }
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(iLaunch);
        }
        string2.done();
    }

    public String[] createDebugLaunchEnvironment(ILaunchConfiguration iLaunchConfiguration, String string, String string2) throws CoreException {
        String string3 = "XDEBUG_CONFIG=remote_enable=1 idekey=" + string2;
        String string4 = "DBGP_IDEKEY=" + string2;
        String string5 = "DBGP_COOKIE=" + string;
        Logger.debugMSG("env=" + string3 + ", Cookie=" + string5);
        String[] stringArray = PHPLaunchUtilities.getEnvironment(iLaunchConfiguration, new String[]{string3, string4, string5});
        return stringArray;
    }

    public String[] createCommandLine(ILaunchConfiguration iLaunchConfiguration, String string, String string2, String string3) throws CoreException {
        String string4 = iLaunchConfiguration.getAttribute("PHPIniLocation", "");
        return PHPLaunchUtilities.getCommandLine(iLaunchConfiguration, string2, string, string3, string4);
    }

    protected void displayErrorMessage(final String string) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Debug Error", (String)string);
            }
        });
    }
}

