/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.preferences.AbstractDebuggerConfigurationDialog;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.zend.debugger.ZendDebuggerConfiguration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ZendDebuggerConfigurationDialog
extends AbstractDebuggerConfigurationDialog {
    private Text fDebugTextBox;
    private Button fRunWithDebugInfo;
    private ZendDebuggerConfiguration zendDebuggerConfiguration;

    public ZendDebuggerConfigurationDialog(ZendDebuggerConfiguration zendDebuggerConfiguration, Shell shell) {
        super(shell);
        this.zendDebuggerConfiguration = zendDebuggerConfiguration;
    }

    protected Point getInitialSize() {
        Point point = super.getInitialSize();
        point.y -= 50;
        return point;
    }

    protected Control createDialogArea(Composite composite) {
        composite = (Composite)super.createDialogArea(composite);
        this.setTitle(PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_zendDebuggerSettings);
        Composite composite2 = this.createSubsection(composite, PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_zendDebugger);
        this.addLabelControl(composite2, PHPDebugCoreMessages.DebuggerConfigurationDialog_debugPort, PHPDebugCorePreferenceNames.ZEND_DEBUG_PORT);
        this.fDebugTextBox = this.addTextField(composite2, PHPDebugCorePreferenceNames.ZEND_DEBUG_PORT, 6, 2);
        this.fDebugTextBox.addModifyListener((ModifyListener)new DebugPortValidateListener());
        this.fRunWithDebugInfo = this.addCheckBox(composite2, PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_runWithDebugInfo, PHPDebugCorePreferenceNames.RUN_WITH_DEBUG_INFO, 0);
        this.internalInitializeValues();
        return composite2;
    }

    private void internalInitializeValues() {
        Preferences preferences = PHPProjectPreferences.getModelPreferences();
        this.fRunWithDebugInfo.setSelection(preferences.getBoolean(PHPDebugCorePreferenceNames.RUN_WITH_DEBUG_INFO));
        this.fDebugTextBox.setText(Integer.toString(preferences.getInt(PHPDebugCorePreferenceNames.ZEND_DEBUG_PORT)));
    }

    protected void okPressed() {
        Preferences preferences = PHPProjectPreferences.getModelPreferences();
        preferences.setValue(PHPDebugCorePreferenceNames.RUN_WITH_DEBUG_INFO, this.fRunWithDebugInfo.getSelection());
        preferences.setValue(PHPDebugCorePreferenceNames.ZEND_DEBUG_PORT, this.fDebugTextBox.getText());
        PHPDebugPlugin.getDefault().savePluginPreferences();
        super.okPressed();
    }

    class DebugPortValidateListener
    implements ModifyListener {
        DebugPortValidateListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            Integer n;
            String string = null;
            boolean bl = true;
            String string2 = ((Text)modifyEvent.widget).getText();
            try {
                n = new Integer(string2);
                int n2 = n;
                if (n2 < 0 || n2 > 65535) {
                    bl = false;
                    string = PHPDebugCoreMessages.DebuggerConfigurationDialog_invalidPort;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                string = PHPDebugCoreMessages.DebuggerConfigurationDialog_invalidPort;
            }
            catch (Exception exception) {
                bl = false;
                string = PHPDebugCoreMessages.DebuggerConfigurationDialog_invalidPort;
            }
            ZendDebuggerConfigurationDialog.this.setErrorMessage(string);
            n = ZendDebuggerConfigurationDialog.this.getButton(0);
            if (n != null) {
                n.setEnabled(bl);
            }
        }
    }
}

