/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.debugger.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.datatools.sqltools.debugger.actions.AbstractBreakpointRulerAction;
import org.eclipse.datatools.sqltools.debugger.core.internal.DebuggerMessages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;

public class EnableDisableBreakpointRulerAction
extends AbstractBreakpointRulerAction {
    public EnableDisableBreakpointRulerAction(ITextEditor editor, IVerticalRulerInfo info) {
        this.setInfo(info);
        this.setTextEditor(editor);
        this.setText(DebuggerMessages.EnableDisableBreakpointRulerAction_enableBreakpoint);
    }

    public void run() {
        if (this.getBreakpoint() != null) {
            try {
                this.getBreakpoint().setEnabled(!this.getBreakpoint().isEnabled());
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.getTextEditor().getEditorSite().getShell(), (String)DebuggerMessages.EnableDisableBreakpointRulerAction_error, (String)DebuggerMessages.EnableDisableBreakpointRulerAction_enableFailed, (IStatus)e.getStatus());
            }
        }
    }

    public void update() {
        this.setBreakpoint(this.determineBreakpoint());
        if (this.getBreakpoint() == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
        try {
            boolean enabled = this.getBreakpoint().isEnabled();
            this.setText(enabled ? DebuggerMessages.EnableDisableBreakpointRulerAction_disableBreakpoint : DebuggerMessages.EnableDisableBreakpointRulerAction_enableBreakpoint);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }
}

