/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.console;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaExceptionBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.JavaBreakpointPropertiesAction;
import org.eclipse.jdt.internal.debug.ui.breakpoints.AddExceptionAction;
import org.eclipse.jdt.internal.debug.ui.console.JavaStackTraceHyperlink;
import org.eclipse.jdt.internal.debug.ui.propertypages.JavaBreakpointPage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.console.TextConsole;

public class JavaExceptionHyperLink
extends JavaStackTraceHyperlink {
    private String fExceptionName = null;

    public JavaExceptionHyperLink(TextConsole console, String exceptionName) {
        super(console);
        this.fExceptionName = exceptionName;
    }

    public void linkActivated() {
        try {
            IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(JDIDebugModel.getPluginIdentifier());
            int i = 0;
            while (i < breakpoints.length) {
                IJavaExceptionBreakpoint exceptionBreakpoint;
                IBreakpoint breakpoint = breakpoints[i];
                if (breakpoint instanceof IJavaExceptionBreakpoint && this.fExceptionName.equals((exceptionBreakpoint = (IJavaExceptionBreakpoint)breakpoint).getTypeName())) {
                    this.showProperties(exceptionBreakpoint);
                    return;
                }
                ++i;
            }
            this.startSourceSearch(this.fExceptionName, -1);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.statusDialog(e.getStatus());
            return;
        }
    }

    private void showProperties(IJavaExceptionBreakpoint breakpoint) {
        JavaBreakpointPropertiesAction action = new JavaBreakpointPropertiesAction();
        action.selectionChanged(null, (ISelection)new StructuredSelection((Object)breakpoint));
        action.run(null);
    }

    protected void processSearchResult(Object source, String typeName, int lineNumber) {
        try {
            IWorkspaceRoot res = ResourcesPlugin.getWorkspace().getRoot();
            IType type = null;
            if (source instanceof ICompilationUnit) {
                type = ((ICompilationUnit)source).findPrimaryType();
            } else if (source instanceof IClassFile) {
                type = ((IClassFile)source).getType();
            } else if (source instanceof IType) {
                type = (IType)source;
            }
            if (type != null) {
                res = BreakpointUtils.getBreakpointResource((IMember)type);
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(JavaBreakpointPage.ATTR_DELETE_ON_CANCEL, JavaBreakpointPage.ATTR_DELETE_ON_CANCEL);
            IJavaExceptionBreakpoint breakpoint = JDIDebugModel.createExceptionBreakpoint((IResource)res, (String)this.fExceptionName, (boolean)true, (boolean)true, (boolean)AddExceptionAction.isChecked(type), (boolean)false, map);
            this.showProperties(breakpoint);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.statusDialog(e.getStatus());
        }
    }
}

