/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class StyledTextDropTargetEffect
extends DropTargetEffect {
    static final int CARET_WIDTH = 2;
    static final int SCROLL_HYSTERESIS = 100;
    static final int SCROLL_TOLERANCE = 20;
    int currentOffset = -1;
    long scrollBeginTime;
    int scrollX = -1;
    int scrollY = -1;
    Listener paintListener = new Listener(){

        public void handleEvent(Event event) {
            if (StyledTextDropTargetEffect.this.currentOffset != -1) {
                StyledText text = (StyledText)StyledTextDropTargetEffect.this.getControl();
                Point position = text.getLocationAtOffset(StyledTextDropTargetEffect.this.currentOffset);
                int height = text.getLineHeight(StyledTextDropTargetEffect.this.currentOffset);
                event.gc.setBackground(event.display.getSystemColor(2));
                event.gc.fillRectangle(position.x, position.y, 2, height);
            }
        }
    };

    public StyledTextDropTargetEffect(StyledText styledText) {
        super(styledText);
    }

    public void dragEnter(DropTargetEvent event) {
        this.currentOffset = -1;
        this.scrollBeginTime = 0L;
        this.scrollX = -1;
        this.scrollY = -1;
        this.getControl().removeListener(9, this.paintListener);
        this.getControl().addListener(9, this.paintListener);
    }

    public void dragLeave(DropTargetEvent event) {
        StyledText text = (StyledText)this.getControl();
        if (this.currentOffset != -1) {
            this.refreshCaret(text, this.currentOffset, -1);
        }
        text.removeListener(9, this.paintListener);
        this.scrollBeginTime = 0L;
        this.scrollX = -1;
        this.scrollY = -1;
    }

    public void dragOver(DropTargetEvent event) {
        int effect = event.feedback;
        StyledText text = (StyledText)this.getControl();
        Point pt = text.getDisplay().map(null, text, event.x, event.y);
        if ((effect & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollY = -1;
            this.scrollX = -1;
        } else if (text.getCharCount() == 0) {
            this.scrollBeginTime = 0L;
            this.scrollY = -1;
            this.scrollX = -1;
        } else if (this.scrollX != -1 && this.scrollY != -1 && this.scrollBeginTime != 0L && (pt.x >= this.scrollX && pt.x <= this.scrollX + 20 || pt.y >= this.scrollY && pt.y <= this.scrollY + 20)) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                int topPixel;
                int lineHeight;
                int leftPixel;
                Rectangle area = text.getClientArea();
                Rectangle bounds = text.getTextBounds(0, 0);
                int charWidth = bounds.width;
                int scrollAmount = 10 * charWidth;
                if (pt.x < area.x + 3 * charWidth) {
                    leftPixel = text.getHorizontalPixel();
                    text.setHorizontalPixel(leftPixel - scrollAmount);
                    if (text.getHorizontalPixel() != leftPixel) {
                        text.redraw();
                    }
                }
                if (pt.x > area.width - 3 * charWidth) {
                    leftPixel = text.getHorizontalPixel();
                    text.setHorizontalPixel(leftPixel + scrollAmount);
                    if (text.getHorizontalPixel() != leftPixel) {
                        text.redraw();
                    }
                }
                if (pt.y < area.y + (lineHeight = bounds.height)) {
                    topPixel = text.getTopPixel();
                    text.setTopPixel(topPixel - lineHeight);
                    if (text.getTopPixel() != topPixel) {
                        text.redraw();
                    }
                }
                if (pt.y > area.height - lineHeight) {
                    topPixel = text.getTopPixel();
                    text.setTopPixel(topPixel + lineHeight);
                    if (text.getTopPixel() != topPixel) {
                        text.redraw();
                    }
                }
                this.scrollBeginTime = 0L;
                this.scrollY = -1;
                this.scrollX = -1;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 100L;
            this.scrollX = pt.x;
            this.scrollY = pt.y;
        }
        if ((effect & 1) != 0) {
            StyledTextContent content = text.getContent();
            int newOffset = -1;
            try {
                newOffset = text.getOffsetAtLocation(pt);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                int maxOffset = content.getCharCount();
                Point maxLocation = text.getLocationAtOffset(maxOffset);
                if (pt.y >= maxLocation.y) {
                    try {
                        newOffset = text.getOffsetAtLocation(new Point(pt.x, maxLocation.y));
                    }
                    catch (IllegalArgumentException illegalArgumentException2) {
                        newOffset = maxOffset;
                    }
                }
                try {
                    int startOffset = text.getOffsetAtLocation(new Point(0, pt.y));
                    int endOffset = maxOffset;
                    int line = content.getLineAtOffset(startOffset);
                    int lineCount = content.getLineCount();
                    if (line + 1 < lineCount) {
                        endOffset = content.getOffsetAtLine(line + 1) - 1;
                    }
                    int lineHeight = text.getLineHeight(startOffset);
                    int i = endOffset;
                    while (i >= startOffset) {
                        Point p = text.getLocationAtOffset(i);
                        if (p.x < pt.x && p.y < pt.y && p.y + lineHeight > pt.y) {
                            newOffset = i;
                        }
                        --i;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException3) {
                    newOffset = -1;
                }
            }
            if (newOffset != -1 && newOffset != this.currentOffset) {
                int line = content.getLineAtOffset(newOffset);
                int lineOffset = content.getOffsetAtLine(line);
                int offsetInLine = newOffset - lineOffset;
                if (offsetInLine > content.getLine(line).length()) {
                    newOffset = Math.max(0, newOffset - 1);
                }
                this.refreshCaret(text, this.currentOffset, newOffset);
                this.currentOffset = newOffset;
            }
        }
    }

    void refreshCaret(StyledText text, int oldOffset, int newOffset) {
        if (oldOffset != newOffset) {
            if (oldOffset != -1) {
                Point oldPos = text.getLocationAtOffset(oldOffset);
                int oldHeight = text.getLineHeight(oldOffset);
                text.redraw(oldPos.x, oldPos.y, 2, oldHeight, false);
            }
            if (newOffset != -1) {
                Point newPos = text.getLocationAtOffset(newOffset);
                int newHeight = text.getLineHeight(newOffset);
                text.redraw(newPos.x, newPos.y, 2, newHeight, false);
            }
        }
    }

    public void dropAccept(DropTargetEvent event) {
        if (this.currentOffset != -1) {
            StyledText text = (StyledText)this.getControl();
            text.setSelection(this.currentOffset);
            this.currentOffset = -1;
        }
    }
}

