/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.daemon.communication;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.php.debug.daemon.communication.ICommunicationDaemon;
import org.eclipse.php.internal.debug.daemon.DaemonPlugin;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommunicationDaemonRegistry {
    private static final String EXTENSION_POINT_NAME = "debugCommunicationDaemon";
    private static final String DAEMON_TAG = "daemon";
    private static final String ID_ATTRIBUTE = "id";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String DEFAULT_DEBUG_DAEMONS_NAMESPACE = "org.eclipse.php.debug.core";
    private Dictionary<String, CommunicationDaemonFactory> daemons = new Hashtable<String, CommunicationDaemonFactory>();
    private static CommunicationDaemonRegistry instance = null;

    private CommunicationDaemonRegistry() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(DaemonPlugin.getID(), EXTENSION_POINT_NAME);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (DAEMON_TAG.equals(iConfigurationElement.getName())) {
                this.daemons.put(iConfigurationElement.getAttribute(ID_ATTRIBUTE), new CommunicationDaemonFactory(iConfigurationElement));
            }
            ++n;
        }
    }

    private static CommunicationDaemonRegistry getInstance() {
        if (instance == null) {
            instance = new CommunicationDaemonRegistry();
        }
        return instance;
    }

    private Dictionary<String, CommunicationDaemonFactory> getDaemons() {
        return this.daemons;
    }

    public static ICommunicationDaemon getDaemon(String string) throws Exception {
        return (ICommunicationDaemon)((Object)CommunicationDaemonRegistry.getInstance().getDaemons().get(string));
    }

    public static ICommunicationDaemon[] getBestMatchCommunicationDaemons() {
        try {
            Object object32;
            Object object2;
            Dictionary<String, CommunicationDaemonFactory> dictionary = CommunicationDaemonRegistry.getInstance().getDaemons();
            Enumeration<CommunicationDaemonFactory> enumeration = dictionary.elements();
            ArrayList<Object> arrayList = new ArrayList<Object>(5);
            ArrayList<Object> arrayList2 = new ArrayList<Object>(5);
            while (enumeration.hasMoreElements()) {
                object2 = enumeration.nextElement();
                object32 = ((CommunicationDaemonFactory)object2).createDaemon();
                boolean bl = WorkbenchActivityHelper.filterItem((Object)new IPluginContribution((ICommunicationDaemon)object32, (CommunicationDaemonFactory)object2){
                    private final /* synthetic */ ICommunicationDaemon val$initializerDaemon;
                    private final /* synthetic */ CommunicationDaemonFactory val$initializerFactory;
                    {
                        this.val$initializerDaemon = iCommunicationDaemon;
                        this.val$initializerFactory = communicationDaemonFactory;
                    }

                    public String getLocalId() {
                        return this.val$initializerDaemon.getDebuggerID();
                    }

                    public String getPluginId() {
                        return this.val$initializerFactory.element.getNamespaceIdentifier();
                    }
                });
                if (bl) continue;
                if (DEFAULT_DEBUG_DAEMONS_NAMESPACE.equals(((CommunicationDaemonFactory)object2).element.getNamespaceIdentifier())) {
                    if (!object32.isEnabled()) continue;
                    arrayList.add(object32);
                    continue;
                }
                if (!object32.isEnabled()) continue;
                arrayList2.add(object32);
            }
            object2 = new ArrayList(arrayList.size() + 4);
            ((ArrayList)object2).addAll(arrayList);
            for (Object object32 : arrayList2) {
                ((ArrayList)object2).add(object32);
                for (ICommunicationDaemon iCommunicationDaemon : arrayList) {
                    if (!iCommunicationDaemon.getClass().isAssignableFrom(object32.getClass())) continue;
                    ((ArrayList)object2).remove(iCommunicationDaemon);
                }
            }
            object32 = new ICommunicationDaemon[((ArrayList)object2).size()];
            ((ArrayList)object2).toArray((T[])object32);
            return object32;
        }
        catch (Exception exception) {
            DaemonPlugin.log(exception);
            return null;
        }
    }

    class CommunicationDaemonFactory {
        ICommunicationDaemon daemon;
        IConfigurationElement element;

        public CommunicationDaemonFactory(IConfigurationElement iConfigurationElement) {
            this.element = iConfigurationElement;
        }

        public ICommunicationDaemon createDaemon() {
            if (this.daemon == null) {
                SafeRunner.run((ISafeRunnable)new SafeRunnable("Error creation extension for extension-point org.eclipse.php.internal.debug.daemon.communication"){

                    public void run() throws Exception {
                        CommunicationDaemonFactory.this.daemon = (ICommunicationDaemon)CommunicationDaemonFactory.this.element.createExecutableExtension(CommunicationDaemonRegistry.CLASS_ATTRIBUTE);
                    }
                });
            }
            return this.daemon;
        }
    }
}

