/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class IfStatement
extends Statement {
    private final Expression condition;
    private final Statement trueStatement;
    private final Statement falseStatement;

    public IfStatement(int n, int n2, Expression expression, Statement statement, Statement statement2) {
        super(n, n2);
        assert (expression != null && statement != null);
        this.condition = expression;
        this.trueStatement = statement;
        this.falseStatement = statement2;
        expression.setParent(this);
        statement.setParent(this);
        if (statement2 != null) {
            statement2.setParent(this);
        }
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.condition.accept(visitor);
        this.trueStatement.accept(visitor);
        if (this.falseStatement != null) {
            this.falseStatement.accept(visitor);
        }
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.condition.traverseTopDown(visitor);
        this.trueStatement.traverseTopDown(visitor);
        if (this.falseStatement != null) {
            this.falseStatement.traverseTopDown(visitor);
        }
    }

    public void traverseBottomUp(Visitor visitor) {
        this.condition.traverseBottomUp(visitor);
        this.trueStatement.traverseBottomUp(visitor);
        if (this.falseStatement != null) {
            this.falseStatement.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    public void toString(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string).append("<IfStatement");
        this.appendInterval(stringBuffer);
        stringBuffer.append(">\n");
        stringBuffer.append("\t").append(string).append("<Condition>\n");
        this.condition.toString(stringBuffer, "\t\t" + string);
        stringBuffer.append("\n");
        stringBuffer.append("\t").append(string).append("</Condition>\n");
        stringBuffer.append("\t").append(string).append("<TrueStatement>\n");
        this.trueStatement.toString(stringBuffer, "\t\t" + string);
        stringBuffer.append("\n");
        stringBuffer.append("\t").append(string).append("</TrueStatement>\n");
        stringBuffer.append("\t").append(string).append("<FalseStatement>\n");
        if (this.falseStatement != null) {
            this.falseStatement.toString(stringBuffer, "\t\t" + string);
            stringBuffer.append("\n");
        }
        stringBuffer.append("\t").append(string).append("</FalseStatement>\n");
        stringBuffer.append(string).append("</IfStatement>");
    }

    public int getType() {
        return 34;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Statement getFalseStatement() {
        return this.falseStatement;
    }

    public Statement getTrueStatement() {
        return this.trueStatement;
    }
}

