/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.php.internal.core.ast.locator.Locator;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Comment;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class Program
extends ASTNode {
    private final Statement[] statements;
    private final Map comments;

    private Program(int n, int n2, Statement[] statementArray, Map map) {
        super(n, n2);
        assert (statementArray != null && map != null);
        this.statements = statementArray;
        this.comments = map;
        int n3 = 0;
        while (n3 < statementArray.length) {
            statementArray[n3].setParent(this);
            ++n3;
        }
        for (Comment comment : this.getComments()) {
            comment.setParent(this);
        }
    }

    public Program(int n, int n2, List list, List list2) {
        this(n, n2, list.toArray(new Statement[list.size()]), Program.createCommentsMap(list2));
    }

    public Collection getComments() {
        return this.comments.values();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        int n = 0;
        while (n < this.statements.length) {
            this.statements[n].accept(visitor);
            ++n;
        }
        for (Comment comment : this.getComments()) {
            comment.accept(visitor);
        }
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        int n = 0;
        while (n < this.statements.length) {
            this.statements[n].traverseTopDown(visitor);
            ++n;
        }
        for (Comment comment : this.getComments()) {
            comment.traverseTopDown(visitor);
        }
    }

    public void traverseBottomUp(Visitor visitor) {
        int n = 0;
        while (n < this.statements.length) {
            this.statements[n].traverseBottomUp(visitor);
            ++n;
        }
        for (Comment comment : this.getComments()) {
            comment.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    public void toString(StringBuffer stringBuffer, String string) {
        stringBuffer.append("<Program");
        this.appendInterval(stringBuffer);
        stringBuffer.append(">\n").append("\t").append("<Statements>\n");
        int n = 0;
        while (this.statements != null && n < this.statements.length) {
            this.statements[n].toString(stringBuffer, "\t\t" + string);
            stringBuffer.append("\n");
            ++n;
        }
        stringBuffer.append("\t").append("</Statements>\n").append("\t").append("<Comments>\n");
        for (Comment comment : this.getComments()) {
            comment.toString(stringBuffer, "\t\t" + string);
            stringBuffer.append("\n");
        }
        stringBuffer.append("\t").append("</Comments>\n").append("</Program>");
    }

    private static Map createCommentsMap(List list) {
        TreeMap<Integer, Comment> treeMap = new TreeMap<Integer, Comment>();
        for (Comment comment : list) {
            treeMap.put(new Integer(comment.getEnd()), comment);
        }
        return treeMap;
    }

    public int getType() {
        return 46;
    }

    public Statement[] getStatements() {
        return this.statements;
    }

    public ASTNode getElementAt(int n) {
        return Locator.locateNode(this, n);
    }
}

