/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPUserModel;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.preferences.PreferencesSupport;
import org.eclipse.php.internal.core.util.ICachable;
import org.eclipse.php.internal.core.util.IncludeCacheManager;
import org.eclipse.php.internal.core.util.SerializationUtil;
import org.eclipse.php.internal.core.util.StreamUtils;

public class DefaultCacheManager {
    private static final String DATA_MODEL_FILE_NAME = ".dataModel";
    private static final String CACHE_DIR_NAME = ".cache";
    public static final int DEFAULT_CACHE_POLICY = 0;
    public static final int VERSION_IDENTIFIER = 210607;
    private HashMap projectToCacheDir;
    private File sharedCacheDir;
    private PreferencesSupport preferencesSupport;
    private IncludeCacheManager includeCacheManager;
    private Object writeLock = new Object();
    public static DefaultCacheManager instance;

    public static DefaultCacheManager instance() {
        if (instance == null) {
            instance = new DefaultCacheManager();
        }
        return instance;
    }

    private DefaultCacheManager() {
        this.projectToCacheDir = new HashMap();
        IPath iPath = PHPCorePlugin.getDefault().getStateLocation();
        this.sharedCacheDir = new File(iPath.toFile(), CACHE_DIR_NAME);
        if (!this.sharedCacheDir.exists()) {
            this.sharedCacheDir.mkdirs();
        }
        this.preferencesSupport = new PreferencesSupport("org.eclipse.php.core", PHPCorePlugin.getDefault().getPreferenceStore());
        this.includeCacheManager = new IncludeCacheManager(this);
    }

    public IncludeCacheManager getIncludeCacheManager() {
        return this.includeCacheManager;
    }

    public void deleteCacheFromDisk(IProject iProject) {
        File file = this.getCacheDir(iProject);
        File file2 = new File(file, DATA_MODEL_FILE_NAME);
        if (file2.exists()) {
            file2.delete();
        }
    }

    protected File getCacheDir(IProject iProject) {
        File file = (File)this.projectToCacheDir.get(iProject);
        if (file == null && iProject != null) {
            IPath iPath = iProject.getLocation();
            if (iPath == null) {
                return null;
            }
            File file2 = iPath.toFile();
            if (file2 != null) {
                file = new File(file2, CACHE_DIR_NAME);
                this.projectToCacheDir.put(iProject, file);
            }
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public long getSharedCacheModificationTime(IProject iProject, IPhpModel iPhpModel) {
        File file = this.getSharedCacheFile(iProject, iPhpModel);
        return file.lastModified();
    }

    public File getSharedCacheDirectory() {
        return this.sharedCacheDir;
    }

    protected File getSharedCacheFile(IProject iProject, IPhpModel iPhpModel) {
        return this.getSharedCacheFile(iProject, iPhpModel.getID());
    }

    public File getSharedCacheFile(IProject iProject, String string) {
        String string2 = this.preferencesSupport.getPreferencesValue("phpVersion", null, iProject);
        return this.getSharedCacheFile(string2, string);
    }

    public File getSharedCacheFile(String string, String string2) {
        String string3 = String.valueOf(string2.hashCode());
        String string4 = String.valueOf(string3) + '_' + (string != null ? string : "");
        return new File(this.sharedCacheDir, string4);
    }

    public void load(IProject iProject, IPhpModel iPhpModel, boolean bl) {
        if (iProject == null || !(iPhpModel instanceof PHPUserModel)) {
            return;
        }
        PHPUserModel pHPUserModel = (PHPUserModel)iPhpModel;
        File file = null;
        file = bl ? this.getSharedCacheFile(iProject, iPhpModel) : new File(this.getCacheDir(iProject), DATA_MODEL_FILE_NAME);
        this.innerLoadModel(pHPUserModel, file);
    }

    private void innerLoadModel(PHPUserModel pHPUserModel, File file) {
        block20: {
            if (!file.exists()) {
                return;
            }
            boolean bl = false;
            Runtime.getRuntime().gc();
            FileInputStream fileInputStream = null;
            BufferedInputStream bufferedInputStream = null;
            DataInputStream dataInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                bufferedInputStream = new BufferedInputStream(fileInputStream, 2048);
                dataInputStream = new DataInputStream(bufferedInputStream);
                int n = dataInputStream.readInt();
                if (n == 210607) {
                    PHPFileData[] pHPFileDataArray = SerializationUtil.deserializePHPFileDataArray(dataInputStream);
                    int n2 = 0;
                    while (n2 < pHPFileDataArray.length) {
                        PHPFileData pHPFileData = pHPFileDataArray[n2];
                        pHPUserModel.insert(pHPFileData);
                        ++n2;
                    }
                    Runtime.getRuntime().gc();
                } else {
                    bl = true;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                StreamUtils.closeStream(dataInputStream);
                StreamUtils.closeStream(bufferedInputStream);
                StreamUtils.closeStream(fileInputStream);
                if (bl) {
                    if (file.delete()) {
                        String string = "Invalid cache version. The cache file was deleted.";
                        PHPCorePlugin.log((IStatus)new Status(1, "org.eclipse.php.core", string, null));
                    } else {
                        String string = "Invalid cache version. Could not delete the file: " + file.getPath();
                        PHPCorePlugin.log((IStatus)new Status(1, "org.eclipse.php.core", string, null));
                    }
                }
                break block20;
            }
            catch (Exception exception) {
                try {
                    PHPCorePlugin.log(exception);
                    break block20;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    StreamUtils.closeStream(dataInputStream);
                    StreamUtils.closeStream(bufferedInputStream);
                    StreamUtils.closeStream(fileInputStream);
                    if (bl) {
                        if (file.delete()) {
                            String string = "Invalid cache version. The cache file was deleted.";
                            PHPCorePlugin.log((IStatus)new Status(1, "org.eclipse.php.core", string, null));
                        } else {
                            String string = "Invalid cache version. Could not delete the file: " + file.getPath();
                            PHPCorePlugin.log((IStatus)new Status(1, "org.eclipse.php.core", string, null));
                        }
                    }
                }
            }
            StreamUtils.closeStream(dataInputStream);
            StreamUtils.closeStream(bufferedInputStream);
            StreamUtils.closeStream(fileInputStream);
            if (bl) {
                if (file.delete()) {
                    String string = "Invalid cache version. The cache file was deleted.";
                    PHPCorePlugin.log((IStatus)new Status(1, "org.eclipse.php.core", string, null));
                } else {
                    String string = "Invalid cache version. Could not delete the file: " + file.getPath();
                    PHPCorePlugin.log((IStatus)new Status(1, "org.eclipse.php.core", string, null));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(IProject iProject, IPhpModel iPhpModel, boolean bl) {
        if (!(iPhpModel instanceof PHPUserModel)) {
            return;
        }
        PHPUserModel pHPUserModel = (PHPUserModel)iPhpModel;
        File file = null;
        if (bl) {
            file = this.getSharedCacheFile(iProject, iPhpModel);
            Object object = this.writeLock;
            synchronized (object) {
                if (file.exists()) {
                    if (System.currentTimeMillis() - file.lastModified() > 60000L) {
                        this.innerSaveModel(pHPUserModel, file);
                    }
                } else {
                    this.innerSaveModel(pHPUserModel, file);
                }
            }
        } else {
            file = new File(this.getCacheDir(iProject), DATA_MODEL_FILE_NAME);
            this.innerSaveModel(pHPUserModel, file);
        }
    }

    private void innerSaveModel(PHPUserModel pHPUserModel, File file) {
        block5: {
            FileOutputStream fileOutputStream = null;
            BufferedOutputStream bufferedOutputStream = null;
            DataOutputStream dataOutputStream = null;
            try {
                try {
                    CodeData[] codeDataArray = pHPUserModel.getFileDatas();
                    ICachable[] iCachableArray = Arrays.asList(codeDataArray).toArray(new ICachable[codeDataArray.length]);
                    fileOutputStream = new FileOutputStream(file);
                    bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 2048);
                    dataOutputStream = new DataOutputStream(bufferedOutputStream);
                    dataOutputStream.writeInt(210607);
                    SerializationUtil.serialize(iCachableArray, dataOutputStream);
                    dataOutputStream.flush();
                }
                catch (IOException iOException) {
                    PHPCorePlugin.log(iOException);
                    StreamUtils.closeStream(dataOutputStream);
                    StreamUtils.closeStream(fileOutputStream);
                    StreamUtils.closeStream(bufferedOutputStream);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(dataOutputStream);
                StreamUtils.closeStream(fileOutputStream);
                StreamUtils.closeStream(bufferedOutputStream);
                throw throwable;
            }
            StreamUtils.closeStream(dataOutputStream);
            StreamUtils.closeStream(fileOutputStream);
            StreamUtils.closeStream(bufferedOutputStream);
        }
        Runtime.getRuntime().gc();
    }
}

