/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.ddl;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.sqm.core.rte.DDLGenerator;
import org.eclipse.datatools.connectivity.sqm.core.rte.EngineeringOption;
import org.eclipse.datatools.connectivity.sqm.core.rte.fe.GenericDdlGenerator;
import org.eclipse.datatools.enablement.sybase.ddl.ISybaseDdlGenerator;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlBuilder;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlGenerationOptions;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlScript;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.routines.RoutineResultTable;
import org.eclipse.datatools.modelbase.sql.routines.UserDefinedFunction;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Event;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.SQLSchemaPackage;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.SQLTablesPackage;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.emf.ecore.EClass;

public abstract class SybaseDdlGenerator
extends GenericDdlGenerator
implements ISybaseDdlGenerator,
DDLGenerator {
    protected SybaseDdlBuilder sybaseDdlBuilder;

    public EngineeringOption[] getOptions() {
        return SybaseDdlGenerationOptions.getGlobalSybaseDDLGenerationOptions();
    }

    public EngineeringOption[] getGenrerationOptions() {
        byte[] optionIndices = this.getCommonGenerateOptionIndices();
        EngineeringOption[] results = new EngineeringOption[optionIndices.length];
        int i = 0;
        while (i < optionIndices.length) {
            results[i] = this.getOptions()[optionIndices[i]];
            ++i;
        }
        return results;
    }

    public EngineeringOption[] createGenerationOptions() {
        byte[] generateionIndices = this.getCommonGenerateOptionIndices();
        EngineeringOption[] results = new EngineeringOption[generateionIndices.length];
        int i = 0;
        while (i < generateionIndices.length) {
            results[i] = this.createEngineeringOption(SybaseDdlGenerationOptions.getGlobalSybaseDDLGenerationOptions()[generateionIndices[i]]);
            ++i;
        }
        return results;
    }

    public EngineeringOption[] createSelectedOptions(SQLObject[] elements) {
        return null;
    }

    private EngineeringOption createEngineeringOption(EngineeringOption oldOption) {
        EngineeringOption newOption = null;
        switch (oldOption.getOptionType()) {
            case 0: {
                newOption = new EngineeringOption(oldOption.getId(), oldOption.getOptionName(), oldOption.getOptionDescription(), oldOption.getBoolean(), oldOption.getCategory());
                break;
            }
            case 2: {
                newOption = new EngineeringOption(oldOption.getId(), oldOption.getOptionName(), oldOption.getOptionDescription(), oldOption.getString(), oldOption.getCategory());
                break;
            }
            case 1: {
                newOption = new EngineeringOption(oldOption.getId(), oldOption.getOptionName(), oldOption.getOptionDescription(), oldOption.getInt(), oldOption.getCategory());
                break;
            }
            case 3: {
                newOption = new EngineeringOption(oldOption.getId(), oldOption.getOptionName(), oldOption.getOptionDescription(), oldOption.getInt(), oldOption.getEnumLiterals(), oldOption.getCategory());
            }
        }
        return newOption;
    }

    protected byte[] getCommonGenerateOptionIndices() {
        byte[] byArray = new byte[6];
        byArray[1] = 1;
        byArray[2] = 26;
        byArray[3] = 27;
        byArray[4] = 3;
        byArray[5] = 2;
        return byArray;
    }

    protected byte[] getAdditionalObjectTypeOptionIndices(EClass objectType) {
        if (SQLSchemaPackage.eINSTANCE.getSchema().isSuperTypeOf(objectType)) {
            return new byte[]{8, 5, 4, 15, 6, 16};
        }
        if (SQLTablesPackage.eINSTANCE.getPersistentTable().isSuperTypeOf(objectType)) {
            return new byte[]{5, 14, 12, 11, 13, 7};
        }
        return new byte[0];
    }

    public String[] generateDDL(SQLObject[] elements, EngineeringOption[] options, IProgressMonitor progressMonitor) {
        String[] creations = new String[]{};
        String[] drops = new String[]{};
        if (this.generateCreateStatement(options)) {
            creations = this.createSQLObjects(elements, options, progressMonitor);
        }
        if (this.generateDropStatement(options)) {
            drops = this.dropSQLObjects(elements, options, progressMonitor);
        }
        String[] statements = new String[creations.length + drops.length];
        System.arraycopy(creations, 0, statements, 0, creations.length);
        System.arraycopy(drops, 0, statements, creations.length, drops.length);
        return statements;
    }

    public String[] generateDDL(SQLObject[] elements, IProgressMonitor progressMonitor) {
        return this.generateDDL(elements, this.getOptions(), progressMonitor);
    }

    public String[] createSQLObjects(SQLObject[] elements, EngineeringOption[] options, IProgressMonitor progressMonitor) {
        SybaseDdlScript script = new SybaseDdlScript();
        this.createStatements(elements, options, script, progressMonitor, 100);
        return script.getStatements();
    }

    public String[] createSQLObjects(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor) {
        return this.createSQLObjects(elements, quoteIdentifiers, qualifyNames, true, progressMonitor);
    }

    public String[] createSQLObjects(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, IProgressMonitor progressMonitor) {
        SybaseDdlScript script = new SybaseDdlScript();
        this.createStatements(elements, quoteIdentifiers, qualifyNames, fullSyntax, script, progressMonitor, 100);
        return script.getStatements();
    }

    public String[] dropSQLObjects(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor) {
        SybaseDdlScript script = new SybaseDdlScript();
        this.dropStatements(elements, quoteIdentifiers, qualifyNames, script, progressMonitor, 100);
        return script.getStatements();
    }

    public String[] dropSQLObjects(SQLObject[] elements, EngineeringOption[] options, IProgressMonitor progressMonitor) {
        SybaseDdlScript script = new SybaseDdlScript();
        this.dropStatements(elements, options, script, progressMonitor, 100);
        return script.getStatements();
    }

    protected void createStatements(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script, IProgressMonitor progressMonitor, int task) {
        if (this.sybaseDdlBuilder == null) {
            this.sybaseDdlBuilder = this.createBuilder();
        }
        int i = 0;
        while (i < elements.length) {
            this.createStatement(elements[i], quoteIdentifiers, qualifyNames, fullSyntax, script, progressMonitor, task);
            ++i;
        }
    }

    public void createStatement(SQLObject element, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script, IProgressMonitor progressMonitor, int task) {
        block20: {
            String[] statement;
            block35: {
                block34: {
                    block33: {
                        block32: {
                            block31: {
                                block30: {
                                    block29: {
                                        block28: {
                                            block27: {
                                                block26: {
                                                    block25: {
                                                        block24: {
                                                            block23: {
                                                                block22: {
                                                                    block21: {
                                                                        block19: {
                                                                            if (this.sybaseDdlBuilder == null) {
                                                                                this.sybaseDdlBuilder = this.createBuilder();
                                                                            }
                                                                            if (!(element instanceof BaseTable)) break block19;
                                                                            String[] statements = this.sybaseDdlBuilder.createTable((BaseTable)element, quoteIdentifiers, qualifyNames, fullSyntax);
                                                                            int j = 0;
                                                                            while (j < statements.length) {
                                                                                script.addCreateTableStatement(statements[j]);
                                                                                ++j;
                                                                            }
                                                                            break block20;
                                                                        }
                                                                        if (!(element instanceof ViewTable)) break block21;
                                                                        String[] statements = this.sybaseDdlBuilder.createView((ViewTable)element, quoteIdentifiers, qualifyNames, fullSyntax);
                                                                        int j = 0;
                                                                        while (j < statements.length) {
                                                                            script.addCreateViewStatement(statements[j]);
                                                                            ++j;
                                                                        }
                                                                        break block20;
                                                                    }
                                                                    if (!(element instanceof Trigger)) break block22;
                                                                    String[] statement2 = this.sybaseDdlBuilder.createTrigger((Trigger)element, quoteIdentifiers, qualifyNames, fullSyntax);
                                                                    if (statement2 == null) break block20;
                                                                    int j = 0;
                                                                    while (j < statement2.length) {
                                                                        script.addCreateTriggerStatement(statement2[j]);
                                                                        ++j;
                                                                    }
                                                                    break block20;
                                                                }
                                                                if (!(element instanceof CheckConstraint)) break block23;
                                                                String[] statement3 = this.sybaseDdlBuilder.addCheckConstraint((CheckConstraint)element, quoteIdentifiers, qualifyNames, fullSyntax);
                                                                if (statement3 == null || statement3.length <= 0) break block20;
                                                                int j = 0;
                                                                while (j < statement3.length) {
                                                                    script.addAlterTableAddConstraintStatement(statement3[j]);
                                                                    ++j;
                                                                }
                                                                break block20;
                                                            }
                                                            if (!(element instanceof PrimaryKey)) break block24;
                                                            String[] statement4 = this.sybaseDdlBuilder.addUniqueConstraint((UniqueConstraint)element, quoteIdentifiers, qualifyNames, fullSyntax);
                                                            if (statement4 == null || statement4.length <= 0) break block20;
                                                            int j = 0;
                                                            while (j < statement4.length) {
                                                                script.addAlterTableAddConstraintStatement(statement4[j]);
                                                                ++j;
                                                            }
                                                            break block20;
                                                        }
                                                        if (!(element instanceof UniqueConstraint)) break block25;
                                                        String[] statement5 = this.sybaseDdlBuilder.addUniqueConstraint((UniqueConstraint)element, quoteIdentifiers, qualifyNames, fullSyntax);
                                                        if (statement5 == null || statement5.length <= 0) break block20;
                                                        int j = 0;
                                                        while (j < statement5.length) {
                                                            script.addAlterTableAddConstraintStatement(statement5[j]);
                                                            ++j;
                                                        }
                                                        break block20;
                                                    }
                                                    if (!(element instanceof ForeignKey)) break block26;
                                                    String[] statement6 = this.sybaseDdlBuilder.addForeignKey((ForeignKey)element, quoteIdentifiers, qualifyNames, fullSyntax);
                                                    if (statement6 == null || statement6.length <= 0) break block20;
                                                    int j = 0;
                                                    while (j < statement6.length) {
                                                        script.addAlterTableAddConstraintStatement(statement6[j]);
                                                        ++j;
                                                    }
                                                    break block20;
                                                }
                                                if (!(element instanceof Index)) break block27;
                                                String[] statement7 = this.sybaseDdlBuilder.createIndex((Index)element, quoteIdentifiers, qualifyNames, fullSyntax);
                                                if (statement7 == null) break block20;
                                                int j = 0;
                                                while (j < statement7.length) {
                                                    script.addCreateIndexStatement(statement7[j]);
                                                    ++j;
                                                }
                                                break block20;
                                            }
                                            if (!(element instanceof Column)) break block28;
                                            Table table = ((Column)element).getTable();
                                            if (table instanceof RoutineResultTable) break block20;
                                            String[] statement8 = this.sybaseDdlBuilder.createColumn((Column)element, quoteIdentifiers, qualifyNames, fullSyntax);
                                            int j = 0;
                                            while (j < statement8.length) {
                                                script.addAlterTableStatement(statement8[j]);
                                                ++j;
                                            }
                                            break block20;
                                        }
                                        if (!(element instanceof Event)) break block29;
                                        String[] statement9 = this.sybaseDdlBuilder.createEvent((Event)element, quoteIdentifiers, qualifyNames, fullSyntax);
                                        if (statement9 == null) break block20;
                                        int j = 0;
                                        while (j < statement9.length) {
                                            script.addCreateEventStatements(statement9[j]);
                                            ++j;
                                        }
                                        break block20;
                                    }
                                    if (!(element instanceof Procedure)) break block30;
                                    String[] statement10 = this.sybaseDdlBuilder.createProcedure((Procedure)element, quoteIdentifiers, qualifyNames, fullSyntax);
                                    if (statement10 == null) break block20;
                                    int j = 0;
                                    while (j < statement10.length) {
                                        script.addCreateRoutineStatements(statement10[j]);
                                        ++j;
                                    }
                                    break block20;
                                }
                                if (!(element instanceof UserDefinedFunction)) break block31;
                                String[] statement11 = this.sybaseDdlBuilder.createUserDefinedFunction((UserDefinedFunction)element, quoteIdentifiers, qualifyNames, fullSyntax);
                                if (statement11 == null) break block20;
                                int j = 0;
                                while (j < statement11.length) {
                                    script.addCreateRoutineStatements(statement11[j]);
                                    ++j;
                                }
                                break block20;
                            }
                            if (!(element instanceof Database)) break block32;
                            String[] statement12 = this.sybaseDdlBuilder.createDatabase((Database)element, quoteIdentifiers, qualifyNames, fullSyntax);
                            if (statement12 == null) break block20;
                            int j = 0;
                            while (j < statement12.length) {
                                script.addCreateDatabaseStatements(statement12[j]);
                                ++j;
                            }
                            break block20;
                        }
                        if (!(element instanceof Catalog)) break block33;
                        String[] statement13 = this.sybaseDdlBuilder.createCatalogs((Catalog)element, quoteIdentifiers, qualifyNames, fullSyntax);
                        if (statement13 == null) break block20;
                        int j = 0;
                        while (j < statement13.length) {
                            script.addCreateDatabaseStatements(statement13[j]);
                            ++j;
                        }
                        break block20;
                    }
                    if (!(element instanceof UserDefinedType)) break block34;
                    String[] statement14 = this.sybaseDdlBuilder.createUserDefinedType((UserDefinedType)element, quoteIdentifiers, qualifyNames, fullSyntax);
                    if (statement14 == null) break block20;
                    int j = 0;
                    while (j < statement14.length) {
                        script.addCreateUDDStatements(statement14[j]);
                        ++j;
                    }
                    break block20;
                }
                if (!(element instanceof AuthorizationIdentifier)) break block35;
                String[] statement15 = this.sybaseDdlBuilder.createAuthorizationId((AuthorizationIdentifier)element, quoteIdentifiers, qualifyNames, fullSyntax);
                if (statement15 == null) break block20;
                int j = 0;
                while (j < statement15.length) {
                    script.addCreateAuthIdStatements(statement15[j]);
                    ++j;
                }
                break block20;
            }
            if (element instanceof Privilege && (statement = this.sybaseDdlBuilder.grantPrivilege((Privilege)element, quoteIdentifiers, qualifyNames, fullSyntax)) != null) {
                int j = 0;
                while (j < statement.length) {
                    script.addGrantPrivilegeStatement(statement[j]);
                    ++j;
                }
            }
        }
    }

    protected void createStatements(SQLObject[] elements, EngineeringOption[] options, SybaseDdlScript script, IProgressMonitor progressMonitor, int task) {
        boolean quoteIdentifiers = this.generateQuotedIdentifiers(options);
        boolean qualifyNames = this.generateFullyQualifiedNames(options);
        boolean fullSyntax = this.generateFullSyntax(options);
        this.createStatements(elements, quoteIdentifiers, qualifyNames, fullSyntax, script, progressMonitor, task);
    }

    protected void dropStatements(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, SybaseDdlScript script, IProgressMonitor progressMonitor, int task) {
        if (this.sybaseDdlBuilder == null) {
            this.sybaseDdlBuilder = this.createBuilder();
        }
        int i = 0;
        while (i < elements.length) {
            this.dropStatement(elements[i], quoteIdentifiers, qualifyNames, script, progressMonitor, task);
            ++i;
        }
    }

    protected void dropStatements(SQLObject[] elements, EngineeringOption[] options, SybaseDdlScript script, IProgressMonitor progressMonitor, int task) {
        boolean quoteIdentifiers = this.generateQuotedIdentifiers(options);
        boolean qualifyNames = this.generateFullyQualifiedNames(options);
        this.dropStatements(elements, quoteIdentifiers, qualifyNames, script, progressMonitor, task);
    }

    public void dropStatement(SQLObject element, boolean quoteIdentifiers, boolean qualifyNames, SybaseDdlScript script, IProgressMonitor progressMonitor, int task) {
        String statement;
        Table table;
        if (element instanceof BaseTable) {
            String statement2 = this.sybaseDdlBuilder.dropTable((BaseTable)element, quoteIdentifiers, qualifyNames);
            if (statement2 != null) {
                script.addDropTableStatement(statement2);
            }
        } else if (element instanceof ViewTable) {
            String statement3 = this.sybaseDdlBuilder.dropView((ViewTable)element, quoteIdentifiers, qualifyNames);
            if (statement3 != null) {
                script.addDropViewStatement(statement3);
            }
        } else if (element instanceof Trigger) {
            String statement4 = this.sybaseDdlBuilder.dropTrigger((Trigger)element, quoteIdentifiers, qualifyNames);
            if (statement4 != null) {
                script.addDropTriggerStatement(statement4);
            }
        } else if (element instanceof CheckConstraint) {
            String statement5 = this.sybaseDdlBuilder.dropCheckConstraint((CheckConstraint)element, quoteIdentifiers, qualifyNames);
            if (statement5 != null) {
                script.addAlterTableDropConstraintStatement(statement5);
            }
        } else if (element instanceof PrimaryKey) {
            String statement6 = this.sybaseDdlBuilder.dropUniqueConstraint((UniqueConstraint)element, quoteIdentifiers, qualifyNames);
            if (statement6 != null) {
                script.addAlterTableDropConstraintStatement(statement6);
            }
        } else if (element instanceof UniqueConstraint) {
            String statement7 = this.sybaseDdlBuilder.dropUniqueConstraint((UniqueConstraint)element, quoteIdentifiers, qualifyNames);
            if (statement7 != null) {
                script.addAlterTableDropConstraintStatement(statement7);
            }
        } else if (element instanceof ForeignKey) {
            String statement8 = this.sybaseDdlBuilder.dropForeignKey((ForeignKey)element, quoteIdentifiers, qualifyNames);
            if (statement8 != null) {
                script.addAlterTableDropForeignKeyStatement(statement8);
            }
        } else if (element instanceof Index) {
            String statement9 = this.sybaseDdlBuilder.dropIndex((Index)element, quoteIdentifiers, qualifyNames);
            if (statement9 != null) {
                script.addDropIndexStatement(statement9);
            }
        } else if (element instanceof Event) {
            String statement10 = this.sybaseDdlBuilder.dropEvent((Event)element, quoteIdentifiers, qualifyNames);
            if (statement10 != null) {
                script.addDropEventStatements(statement10);
            }
        } else if (element instanceof Procedure) {
            String statement11 = this.sybaseDdlBuilder.dropProcedure((Procedure)element, quoteIdentifiers, qualifyNames);
            if (statement11 != null) {
                script.addDropRoutineStatement(statement11);
            }
        } else if (element instanceof UserDefinedFunction) {
            String statement12 = this.sybaseDdlBuilder.dropFunction((UserDefinedFunction)element, quoteIdentifiers, qualifyNames);
            if (statement12 != null) {
                script.addDropRoutineStatement(statement12);
            }
        } else if (element instanceof UserDefinedType) {
            String statement13 = this.sybaseDdlBuilder.dropUserDefinedType((UserDefinedType)element, quoteIdentifiers, qualifyNames);
            if (statement13 != null) {
                script.addDropUDDStatements(statement13);
            }
        } else if (element instanceof AuthorizationIdentifier) {
            String statement14 = this.sybaseDdlBuilder.dropAuthorizationId((AuthorizationIdentifier)element, quoteIdentifiers, qualifyNames);
            if (statement14 != null) {
                script.addDropAuthIdStatements(statement14);
            }
        } else if (element instanceof Privilege) {
            String statement15 = this.sybaseDdlBuilder.revokePrivilege((Privilege)element, quoteIdentifiers, qualifyNames);
            if (statement15 != null) {
                script.addRevokePrivilegeStatement(statement15);
            }
        } else if (element instanceof Database) {
            String statement16 = this.sybaseDdlBuilder.dropDatabase((Database)element, quoteIdentifiers, qualifyNames);
            if (statement16 != null) {
                script.addDropDatabaseStatements(statement16);
            }
        } else if (element instanceof Catalog) {
            String statement17 = this.sybaseDdlBuilder.dropCatalog((Catalog)element, quoteIdentifiers, qualifyNames);
            if (statement17 != null) {
                script.addDropDatabaseStatements(statement17);
            }
        } else if (element instanceof Column && !((table = ((Column)element).getTable()) instanceof RoutineResultTable) && (statement = this.sybaseDdlBuilder.dropColumn((Column)element, quoteIdentifiers, qualifyNames)) != null) {
            script.addAlterTableStatement(statement);
        }
    }

    public boolean generateFullSyntax(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_FULL_SYNTAX", options);
    }

    protected boolean getOptionValueByID(String optionID, EngineeringOption[] options) {
        boolean ret = false;
        int i = 0;
        while (i < options.length) {
            EngineeringOption option = options[i];
            if (option != null && option.getId().equals(optionID)) {
                ret = option.getBoolean();
                break;
            }
            ++i;
        }
        return ret;
    }

    public abstract byte[] getAdditionalOptionIndices(int var1);

    protected abstract SybaseDdlBuilder createBuilder();

    public SybaseDdlBuilder getSybaseDdlBuilder() {
        if (this.sybaseDdlBuilder == null) {
            this.createBuilder();
        }
        return this.sybaseDdlBuilder;
    }
}

