/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.connectivity.internal.ui.ConnectionProfileManagerUI;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.ui.manifest.DataSetUIElement;
import org.eclipse.datatools.connectivity.oda.design.ui.manifest.DataSetWizardInfo;
import org.eclipse.datatools.connectivity.oda.design.ui.manifest.UIManifestExplorer;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.Messages;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizard;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSourceEditorPage;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.NewDataSourceWizard;
import org.eclipse.datatools.connectivity.oda.profile.OdaProfileExplorer;
import org.eclipse.jface.wizard.IWizard;

public class OdaProfileUIExplorer {
    private static OdaProfileUIExplorer sm_instance;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static synchronized OdaProfileUIExplorer getInstance() {
        if (sm_instance == null) {
            sm_instance = new OdaProfileUIExplorer();
        }
        return sm_instance;
    }

    private OdaProfileUIExplorer() {
    }

    public NewDataSourceWizard getNewDataSourceWizard(String profileInstanceId) throws OdaException {
        String odaDataSourceId = OdaProfileExplorer.getInstance().getProfile(profileInstanceId).getProviderId();
        return this.getNewDataSourceWizardByType(odaDataSourceId);
    }

    public NewDataSourceWizard getNewDataSourceWizardByType(String odaDataSourceId) throws OdaException {
        if (!$assertionsDisabled && odaDataSourceId == null) {
            throw new AssertionError();
        }
        IWizard dataSourceWizard = null;
        try {
            dataSourceWizard = ConnectionProfileManagerUI.getInstance().getNewWizard(odaDataSourceId);
        }
        catch (RuntimeException ex) {
            throw new OdaException((Throwable)ex);
        }
        if (dataSourceWizard == null) {
            return null;
        }
        if (!(dataSourceWizard instanceof NewDataSourceWizard)) {
            throw new OdaException(Messages.bind((String)Messages.extension_mustInheritFromODAWizard, (Object)dataSourceWizard.getClass().getName(), (Object)NewDataSourceWizard.class.getName()));
        }
        return (NewDataSourceWizard)dataSourceWizard;
    }

    public DataSourceEditorPage getDataSourceEditorPage(String odaDataSourceId) throws OdaException {
        IConfigurationElement pageElement = UIManifestExplorer.getInstance().getPropertyPageElement(odaDataSourceId);
        if (pageElement == null) {
            return null;
        }
        Object propPage = null;
        try {
            propPage = pageElement.createExecutableExtension("class");
        }
        catch (CoreException ex) {
            throw new OdaException((Throwable)ex);
        }
        if (!(propPage instanceof DataSourceEditorPage)) {
            return null;
        }
        String pageName = pageElement.getAttribute("name");
        if (pageName == null || pageName.length() == 0) {
            pageName = Messages.page_defaultDataSourceTitle;
        }
        ((DataSourceEditorPage)((Object)propPage)).setTitle(pageName);
        return (DataSourceEditorPage)((Object)propPage);
    }

    public DataSetWizard getDataSetWizard(String odaDataSourceId, DataSetUIElement dataSetElement) throws OdaException {
        DataSetWizardInfo wizardInfo = dataSetElement.getWizardInfo();
        if (wizardInfo == null) {
            return new DataSetWizard();
        }
        Object wizardInstance = null;
        try {
            IConfigurationElement wizardElement = DataSetUIElement.getWizardElement(dataSetElement.getElement());
            wizardInstance = wizardElement.createExecutableExtension("class");
        }
        catch (CoreException ex) {
            throw new OdaException((Throwable)ex);
        }
        if (!(wizardInstance instanceof DataSetWizard)) {
            throw new OdaException(Messages.bind((String)Messages.extension_mustInheritFromODAWizard, (Object)wizardInfo.getClassName(), (Object)DataSetWizard.class.getName()));
        }
        String wizardTitle = wizardInfo.getWindowTitle();
        if (wizardTitle != null && wizardTitle.length() > 0) {
            ((DataSetWizard)((Object)wizardInstance)).setWindowTitle(wizardTitle);
        }
        return (DataSetWizard)((Object)wizardInstance);
    }

    static {
        $assertionsDisabled = !OdaProfileUIExplorer.class.desiredAssertionStatus();
        sm_instance = null;
    }
}

