/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.dialogs.saveFiles;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.php.internal.ui.dialogs.saveFiles.ContainerContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.DrillDownComposite;

public class ContainerSelectionGroup
extends Composite {
    private Listener listener;
    private boolean allowNewContainerName = true;
    private boolean showClosedProjects = true;
    private IContainer selectedContainer;
    private Text containerNameField;
    private ContainerContentProvider cp;
    TreeViewer treeViewer;
    private static final String DEFAULT_MSG_NEW_ALLOWED = IDEWorkbenchMessages.ContainerGroup_message;
    private static final String DEFAULT_MSG_SELECT_ONLY = IDEWorkbenchMessages.ContainerGroup_selectFolder;
    private static final int SIZING_SELECTION_PANE_WIDTH = 320;
    private static final int SIZING_SELECTION_PANE_HEIGHT = 300;

    public ContainerSelectionGroup(Composite composite, Listener listener, boolean bl) {
        this(composite, listener, bl, null);
    }

    public ContainerSelectionGroup(Composite composite, Listener listener, boolean bl, String string) {
        this(composite, listener, bl, string, true);
    }

    public ContainerSelectionGroup(Composite composite, Listener listener, boolean bl, String string, boolean bl2) {
        this(composite, listener, bl, string, bl2, 300, 320);
    }

    public ContainerSelectionGroup(Composite composite, Listener listener, boolean bl, String string, boolean bl2, int n, int n2) {
        super(composite, 0);
        this.listener = listener;
        this.allowNewContainerName = bl;
        this.showClosedProjects = bl2;
        if (string != null) {
            this.createContents(string, n, n2);
        } else if (bl) {
            this.createContents(DEFAULT_MSG_NEW_ALLOWED, n, n2);
        } else {
            this.createContents(DEFAULT_MSG_SELECT_ONLY, n, n2);
        }
    }

    public void containerSelectionChanged(IContainer iContainer) {
        String string;
        this.selectedContainer = iContainer;
        if (this.allowNewContainerName) {
            if (iContainer == null) {
                this.containerNameField.setText("");
            } else {
                string = iContainer.getFullPath().makeRelative().toString();
                this.containerNameField.setText(string);
                this.containerNameField.setToolTipText(string);
            }
        }
        if (this.listener != null) {
            string = new Event();
            ((Event)string).type = 13;
            ((Event)string).widget = this;
            this.listener.handleEvent((Event)string);
        }
    }

    public void createContents(String string) {
        this.createContents(string, 300, 320);
    }

    public void createContents(String string, int n, int n2) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(new GridData(4, 4, true, true));
        Label label = new Label((Composite)this, 64);
        label.setText(string);
        label.setFont(this.getFont());
        if (this.allowNewContainerName) {
            this.containerNameField = new Text((Composite)this, 2052);
            GridData gridData = new GridData(768);
            gridData.widthHint = n2;
            this.containerNameField.setLayoutData((Object)gridData);
            this.containerNameField.addListener(24, this.listener);
            this.containerNameField.setFont(this.getFont());
        } else {
            new Label((Composite)this, 0);
        }
        this.createTreeViewer(n);
        Dialog.applyDialogFont((Control)this);
    }

    protected void createTreeViewer(int n) {
        DrillDownComposite drillDownComposite = new DrillDownComposite((Composite)this, 2048);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 320;
        gridData.heightHint = n;
        drillDownComposite.setLayoutData((Object)gridData);
        this.treeViewer = new TreeViewer((Composite)drillDownComposite, 0);
        drillDownComposite.setChildTree(this.treeViewer);
        this.cp = new ContainerContentProvider();
        this.cp.showClosedProjects(this.showClosedProjects);
        this.treeViewer.setContentProvider((IContentProvider)this.cp);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.treeViewer.setComparator(new ViewerComparator());
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
                ContainerSelectionGroup.this.containerSelectionChanged((IContainer)iStructuredSelection.getFirstElement());
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                ISelection iSelection = doubleClickEvent.getSelection();
                if (iSelection instanceof IStructuredSelection) {
                    Object object = ((IStructuredSelection)iSelection).getFirstElement();
                    if (object == null) {
                        return;
                    }
                    if (ContainerSelectionGroup.this.treeViewer.getExpandedState(object)) {
                        ContainerSelectionGroup.this.treeViewer.collapseToLevel(object, 1);
                    } else {
                        ContainerSelectionGroup.this.treeViewer.expandToLevel(object, 1);
                    }
                }
            }
        });
        this.treeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
    }

    void refreshResources() {
        this.treeViewer.refresh();
    }

    public IPath getContainerFullPath() {
        if (this.allowNewContainerName) {
            String string = this.containerNameField.getText();
            if (string == null || string.length() < 1) {
                return null;
            }
            return new Path(string).makeAbsolute();
        }
        if (this.selectedContainer == null) {
            return null;
        }
        return this.selectedContainer.getFullPath();
    }

    public void setInitialFocus() {
        if (this.allowNewContainerName) {
            this.containerNameField.setFocus();
        } else {
            this.treeViewer.getTree().setFocus();
        }
    }

    public void setSelectedContainer(IContainer iContainer) {
        this.selectedContainer = iContainer;
        ArrayList<IContainer> arrayList = new ArrayList<IContainer>();
        IContainer iContainer2 = iContainer.getParent();
        while (iContainer2 != null) {
            arrayList.add(0, iContainer2);
            iContainer2 = iContainer2.getParent();
        }
        this.treeViewer.setExpandedElements(arrayList.toArray());
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)iContainer), true);
    }
}

