/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.explorer;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.php.internal.ui.dnd.PHPViewerDropAdapter;
import org.eclipse.php.internal.ui.dnd.TransferDropTargetListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class SelectionTransferDropAdapter
extends PHPViewerDropAdapter
implements TransferDropTargetListener {
    private List fElements;
    private int fCanMoveElements;
    private int fCanCopyElements;
    private ISelection fSelection;
    private static final long DROP_TIME_DIFF_TRESHOLD = 150L;

    public SelectionTransferDropAdapter(StructuredViewer structuredViewer) {
        super(structuredViewer, 24);
    }

    public Transfer getTransfer() {
        return LocalSelectionTransfer.getInstance();
    }

    public void dragEnter(DropTargetEvent dropTargetEvent) {
        this.clear();
        super.dragEnter(dropTargetEvent);
    }

    public void dragLeave(DropTargetEvent dropTargetEvent) {
        this.clear();
        super.dragLeave(dropTargetEvent);
    }

    private void clear() {
        this.fElements = null;
        this.fSelection = null;
        this.fCanMoveElements = 0;
        this.fCanCopyElements = 0;
    }

    public void validateDrop(Object object, DropTargetEvent dropTargetEvent, int n) {
        dropTargetEvent.detail = 0;
        if (this.tooFast(dropTargetEvent)) {
            return;
        }
        this.initializeSelection();
        switch (n) {
            case 16: {
                dropTargetEvent.detail = this.handleValidateDefault(object, dropTargetEvent);
                break;
            }
            case 1: {
                dropTargetEvent.detail = this.handleValidateCopy(object, dropTargetEvent);
                break;
            }
            case 2: {
                dropTargetEvent.detail = this.handleValidateMove(object, dropTargetEvent);
                break;
            }
            case 4: {
                dropTargetEvent.detail = this.handleValidateLink(object, dropTargetEvent);
            }
        }
    }

    protected void initializeSelection() {
        if (this.fElements != null) {
            return;
        }
        ISelection iSelection = LocalSelectionTransfer.getInstance().getSelection();
        if (!(iSelection instanceof IStructuredSelection)) {
            return;
        }
        this.fSelection = iSelection;
        this.fElements = ((IStructuredSelection)iSelection).toList();
    }

    protected ISelection getSelection() {
        return this.fSelection;
    }

    private boolean tooFast(DropTargetEvent dropTargetEvent) {
        return Math.abs(LocalSelectionTransfer.getInstance().getSelectionSetTime() - ((long)dropTargetEvent.time & 0xFFFFFFFFL)) < 150L;
    }

    public void drop(Object object, DropTargetEvent dropTargetEvent) {
        try {
            try {
                switch (dropTargetEvent.detail) {
                    case 2: {
                        this.handleDropMove(object, dropTargetEvent);
                        break;
                    }
                    case 1: {
                        this.handleDropCopy(object, dropTargetEvent);
                        break;
                    }
                    case 4: {
                        this.handleDropLink(object, dropTargetEvent);
                    }
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
                dropTargetEvent.detail = 0;
            }
            catch (InterruptedException interruptedException) {
                dropTargetEvent.detail = 0;
            }
        }
        finally {
            dropTargetEvent.detail = 0;
        }
    }

    private int handleValidateDefault(Object object, DropTargetEvent dropTargetEvent) {
        if (object == null) {
            return 0;
        }
        return this.handleValidateMove(object, dropTargetEvent);
    }

    private int handleValidateMove(Object object, DropTargetEvent dropTargetEvent) {
        if (object == null) {
            return 0;
        }
        if (!this.canMoveElements()) {
            return 0;
        }
        return 0;
    }

    private boolean canMoveElements() {
        if (this.fCanMoveElements == 0) {
            this.fCanMoveElements = 2;
        }
        return this.fCanMoveElements == 2;
    }

    private void handleDropLink(Object object, DropTargetEvent dropTargetEvent) {
    }

    private int handleValidateLink(Object object, DropTargetEvent dropTargetEvent) {
        return 0;
    }

    private void handleDropMove(Object object, DropTargetEvent dropTargetEvent) throws InvocationTargetException, InterruptedException {
    }

    private int handleValidateCopy(Object object, DropTargetEvent dropTargetEvent) {
        if (!this.canCopyElements()) {
            return 0;
        }
        return 0;
    }

    private boolean canCopyElements() {
        if (this.fCanCopyElements == 0) {
            this.fCanCopyElements = 2;
        }
        return this.fCanCopyElements == 2;
    }

    private void handleDropCopy(Object object, DropTargetEvent dropTargetEvent) throws InvocationTargetException, InterruptedException {
    }

    private Shell getShell() {
        return this.getViewer().getControl().getShell();
    }
}

