/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.folding.projection;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.projection.IProjectionPosition;
import org.eclipse.php.internal.ui.text.DocumentCharacterIterator;

public final class CommentPosition
extends Position
implements IProjectionPosition {
    CommentPosition(int n, int n2) {
        super(n, n2);
    }

    public IRegion[] computeProjectionRegions(IDocument iDocument) throws BadLocationException {
        Region region;
        IRegion iRegion;
        int n;
        DocumentCharacterIterator documentCharacterIterator = new DocumentCharacterIterator(iDocument, this.offset, this.offset + this.length);
        int n2 = 0;
        int n3 = this.findFirstContent(documentCharacterIterator, n2);
        int n4 = iDocument.getLineOfOffset(this.offset + n2);
        int n5 = iDocument.getLineOfOffset(this.offset + n3);
        int n6 = iDocument.getLineOfOffset(this.offset + this.length);
        Assert.isTrue((n4 <= n5 ? 1 : 0) != 0, (String)"first folded line is greater than the caption line");
        Assert.isTrue((n5 <= n6 ? 1 : 0) != 0, (String)"caption line is greater than the last folded line");
        if (n4 < n5) {
            n = iDocument.getLineOffset(n4);
            iRegion = iDocument.getLineInformation(n5);
            int n7 = iRegion.getOffset();
            region = new Region(n, n7 - n);
        } else {
            region = null;
        }
        if (n5 < n6) {
            n = iDocument.getLineOffset(n5 + 1);
            iRegion = new Region(n, this.offset + this.length - n);
            if (region == null) {
                return new IRegion[]{iRegion};
            }
            return new IRegion[]{region, iRegion};
        }
        if (region != null) {
            return new IRegion[]{region};
        }
        return null;
    }

    private int findFirstContent(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        int n3 = n;
        while (n3 < n2) {
            if (Character.isUnicodeIdentifierPart(charSequence.charAt(n3))) {
                return n3;
            }
            ++n3;
        }
        return 0;
    }

    public int computeCaptionOffset(IDocument iDocument) {
        DocumentCharacterIterator documentCharacterIterator = new DocumentCharacterIterator(iDocument, this.offset, this.offset + this.length);
        return this.findFirstContent(documentCharacterIterator, 0);
    }
}

