/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.treecontent;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.ModelListener;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.core.project.options.IPhpProjectOptionChangeListener;
import org.eclipse.php.internal.ui.treecontent.IncludeModelPathRootConverter;
import org.eclipse.php.internal.ui.treecontent.IncludePathTreeContent;
import org.eclipse.php.internal.ui.treecontent.PHPTreeNode;
import org.eclipse.swt.graphics.Image;

class IncludesNode
extends PHPTreeNode
implements IPhpProjectOptionChangeListener,
ModelListener {
    private IncludePathTreeContent provider;

    IncludesNode(String string, Image image, String string2, IProject iProject, IncludePathTreeContent includePathTreeContent) {
        super(string, image, string2, iProject, null);
        this.provider = includePathTreeContent;
    }

    public void notifyOptionChanged(Object object, Object object2) {
        List<IIncludePathEntry> list = Arrays.asList((IIncludePathEntry[])object);
        List<IIncludePathEntry> list2 = Arrays.asList((IIncludePathEntry[])object2);
        boolean bl = false;
        for (IIncludePathEntry iIncludePathEntry : list2) {
            if (list.contains(iIncludePathEntry)) continue;
            bl = true;
        }
        for (IIncludePathEntry iIncludePathEntry : list) {
            if (list2.contains(iIncludePathEntry)) continue;
            bl = true;
        }
        if (bl) {
            IncludePathTreeContent.includePathTree.getDataTree().empty();
            this.refresh();
        }
    }

    public void fileDataChanged(PHPFileData pHPFileData) {
        this.refreshFile(pHPFileData, false);
    }

    public void fileDataAdded(PHPFileData pHPFileData) {
        this.refreshFile(pHPFileData, false);
    }

    public void fileDataRemoved(PHPFileData pHPFileData) {
        this.refreshFile(pHPFileData, true);
    }

    public void dataCleared() {
        this.refresh();
    }

    private void refresh() {
        this.refresh(this);
    }

    private void refresh(final Object object) {
        if (this.provider.getTreeViewer() != null && !this.provider.getTreeViewer().getControl().isDisposed()) {
            this.provider.getTreeViewer().getControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (IncludesNode.this.provider.getTreeViewer() != null && !IncludesNode.this.provider.getTreeViewer().getControl().isDisposed()) {
                        IncludesNode.this.provider.getTreeViewer().refresh(object);
                    }
                }
            });
        }
    }

    private void refreshFile(PHPFileData pHPFileData, boolean bl) {
        IPhpModel iPhpModel = IncludePathTreeContent.findModel(pHPFileData);
        if (iPhpModel == null) {
            return;
        }
        Path path = new Path(pHPFileData.getName());
        IPath iPath = PHPModelUtil.getIncludeModelLocation((IPhpModel)iPhpModel);
        IPath iPath2 = IncludePathTreeContent.INCLUDE_PATHS_ROOT_PATH.append(IncludeModelPathRootConverter.toString(iPhpModel));
        IPath iPath3 = iPath2.append(path.removeFirstSegments(iPath.segmentCount()));
        if (IncludePathTreeContent.includePathTree.includes(iPath3)) {
            this.refreshExistingFileNode(iPath3, bl);
            if (!bl) {
                IncludePathTreeContent.includePathTree.createElement(iPath3, (Object)pHPFileData);
            }
        } else {
            this.refreshMissingFileNode(iPath3, bl);
        }
    }

    private void refreshExistingFileNode(IPath iPath, boolean bl) {
        if (bl) {
            IPath iPath2 = iPath;
            while (IncludePathTreeContent.includePathTree.getChildCount(iPath2) < 1 && iPath2.segmentCount() > 1) {
                if (IncludePathTreeContent.includePathTree.includes(iPath2)) {
                    IncludePathTreeContent.includePathTree.deleteElement(iPath2);
                }
                iPath2 = iPath2.removeLastSegments(1);
            }
            this.refresh(IncludePathTreeContent.includePathTree.getElementData(iPath2));
        } else {
            this.refresh(IncludePathTreeContent.includePathTree.getElementData(iPath));
        }
    }

    private void refreshMissingFileNode(IPath iPath, boolean bl) {
        IPath iPath2 = iPath;
        while (!IncludePathTreeContent.includePathTree.includes(iPath2) && iPath2.segmentCount() > 1) {
            if (bl && IncludePathTreeContent.includePathTree.includes(iPath2) && IncludePathTreeContent.includePathTree.getChildCount(iPath2) < 1) {
                IncludePathTreeContent.includePathTree.deleteElement(iPath2);
            }
            iPath2 = iPath2.removeLastSegments(1);
        }
        this.refresh(IncludePathTreeContent.includePathTree.getElementData(iPath2));
    }
}

