/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.flatfile.util;

import com.ibm.icu.util.ULocale;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.flatfile.i18n.Messages;
import org.eclipse.datatools.connectivity.oda.flatfile.util.DateFormatFactory;
import org.eclipse.datatools.connectivity.oda.flatfile.util.DateFormatISO8601;

public final class DateUtil {
    private static ULocale DEFAULT_LOCALE = ULocale.US;
    private static int DEFAULT_DATE_STYLE = 2;
    public static long count = 0L;

    public static synchronized Date toDate(Object source) throws OdaException {
        if (source == null) {
            return null;
        }
        if (source instanceof Date) {
            return new Date(((Date)source).getTime());
        }
        if (source instanceof String) {
            return DateUtil.toDate((String)source);
        }
        throw new OdaException(Messages.getString("dateUtil.ConvertFails") + source.toString());
    }

    public static synchronized Date toDate(String source, ULocale locale) throws OdaException {
        if (source == null) {
            return null;
        }
        DateFormat dateFormat = null;
        Date resultDate = null;
        boolean existTime = source.matches(".*[0-9]+:[0-9]+:[0-9]+.*") || source.matches(".*[0-9]+:[0-9]+.*");
        for (int i = DEFAULT_DATE_STYLE; i <= 3; ++i) {
            for (int j = DEFAULT_DATE_STYLE; j <= 3; ++j) {
                dateFormat = DateFormatFactory.getDateTimeInstance(i, j, locale);
                try {
                    resultDate = dateFormat.parse(source);
                    return resultDate;
                }
                catch (ParseException e1) {
                    continue;
                }
            }
            if (existTime) continue;
            dateFormat = DateFormatFactory.getDateInstance(i, locale);
            try {
                resultDate = dateFormat.parse(source);
                return resultDate;
            }
            catch (ParseException e1) {
                // empty catch block
            }
        }
        if (resultDate == null) {
            throw new OdaException(Messages.getString("dateUtil.ConvertFails") + source.toString());
        }
        return resultDate;
    }

    private static Date toDate(String source) throws OdaException {
        try {
            return DateUtil.toDateISO8601(source);
        }
        catch (OdaException e) {
            try {
                return DateUtil.toDate(source, ULocale.getDefault());
            }
            catch (OdaException use) {
                return DateUtil.toDate(source, DEFAULT_LOCALE);
            }
        }
    }

    private static Date toDateISO8601(String source) throws OdaException {
        Date resultDate = null;
        try {
            resultDate = DateFormatISO8601.parse(source);
            return resultDate;
        }
        catch (ParseException e1) {
            throw new OdaException(Messages.getString("dateUtil.ConvertFails") + source.toString());
        }
    }
}

