/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSResourceVariantFileRevision;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class RemoteFileEditorInput
extends PlatformObject
implements IWorkbenchAdapter,
IStorageEditorInput {
    ICVSRemoteFile file;
    IStorage storage;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public RemoteFileEditorInput(ICVSRemoteFile file, IProgressMonitor monitor) {
        this.file = file;
        try {
            this.initializeStorage(file, monitor);
        }
        catch (TeamException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
        }
    }

    protected void initializeStorage(ICVSRemoteFile file, IProgressMonitor monitor) throws TeamException {
        this.storage = ((IResourceVariant)file).getStorage(monitor);
    }

    public boolean exists() {
        return true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RemoteFileEditorInput)) {
            return false;
        }
        RemoteFileEditorInput input = (RemoteFileEditorInput)((Object)o);
        return this.file.equals((Object)input.file);
    }

    public Object getAdapter(Class adapter) {
        block32: {
            block31: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (adapter == clazz) {
                    return this;
                }
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.team.ui.history.IHistoryPageSource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (adapter == clazz2) {
                    Class<?> clazz3 = class$1;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$1 = Class.forName("org.eclipse.team.ui.history.IHistoryPageSource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return this.file.getAdapter((Class)clazz3);
                }
                Class<?> clazz4 = class$2;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$2 = Class.forName("org.eclipse.team.internal.ccvs.core.ICVSFile");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (adapter == clazz4) break block31;
                Class<?> clazz5 = class$3;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$3 = Class.forName("org.eclipse.team.core.variants.IResourceVariant");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (adapter != clazz5) break block32;
            }
            return this.file;
        }
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.team.core.history.IFileRevision");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this.getFileRevision();
        }
        return super.getAdapter(adapter);
    }

    public CVSResourceVariantFileRevision getFileRevision() {
        return new CVSResourceVariantFileRevision((IResourceVariant)this.file);
    }

    public Object[] getChildren(Object o) {
        return new Object[0];
    }

    public String getContentType() {
        String name = this.file.getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public String getFullPath() {
        String fullPath;
        ICVSRepositoryLocation location = this.file.getRepository();
        Path path = new Path(null, location.getRootDirectory());
        path = path.setDevice(String.valueOf(location.getHost()) + ':');
        path = path.append(this.file.getRepositoryRelativePath());
        try {
            String revision = this.file.getRevision();
            fullPath = NLS.bind((String)CVSUIMessages.RemoteFileEditorInput_fullPathAndRevision, (Object[])new String[]{path.toString(), revision});
        }
        catch (TeamException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
            fullPath = path.toString();
        }
        return fullPath;
    }

    public ImageDescriptor getImageDescriptor() {
        IWorkbenchAdapter fileAdapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (fileAdapter = (IWorkbenchAdapter)this.file.getAdapter((Class)clazz)) == null ? null : fileAdapter.getImageDescriptor((Object)this.file);
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        IWorkbenchAdapter fileAdapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (fileAdapter = (IWorkbenchAdapter)this.file.getAdapter((Class)clazz)) == null ? null : fileAdapter.getImageDescriptor((Object)this.file);
    }

    public String getLabel(Object o) {
        return this.file.getName();
    }

    public String getName() {
        String name = this.file.getName();
        try {
            return NLS.bind((String)CVSUIMessages.nameAndRevision, (Object[])new String[]{name, this.file.getRevision()});
        }
        catch (TeamException teamException) {
            return name;
        }
    }

    public Object getParent(Object o) {
        return null;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public IStorage getStorage() throws CoreException {
        if (this.storage == null) {
            this.initializeStorage(this.file, (IProgressMonitor)new NullProgressMonitor());
        }
        return this.storage;
    }

    public String getToolTipText() {
        return this.getFullPath();
    }

    public ICVSRemoteFile getCVSRemoteFile() {
        return this.file;
    }
}

