/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.preferences;

import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.ui.util.SWTUtil;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class PHPDebuggersTable {
    private TableViewer fPHPDebuggers;
    private Button fSettingsButton;
    private float fWeight1 = 0.6f;
    private float fWeight2 = 0.38f;
    private boolean fResizingTable = false;

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        composite2.setLayoutData((Object)gridData);
        final Group group = new Group(composite2, 0);
        group.setText(PHPDebugUIMessages.PHPDebuggersTable_installedDebuggers);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        group.setLayout((Layout)gridLayout);
        Font font = composite.getFont();
        group.setFont(font);
        gridData = new GridData(1808);
        group.setLayoutData((Object)gridData);
        final Table table = new Table((Composite)group, 67586);
        gridData = new GridData(1808);
        gridData.heightHint = 35;
        table.setLayoutData((Object)gridData);
        table.setFont(font);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        final TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setText(PHPDebugUIMessages.PHPDebuggersTable_debuggerType);
        final TableColumn tableColumn2 = new TableColumn(table, 0);
        tableColumn2.setText(PHPDebugUIMessages.PHPDebuggersTable_port);
        this.fPHPDebuggers = new CheckboxTableViewer(table);
        this.fPHPDebuggers.setLabelProvider((IBaseLabelProvider)new PHPDebuggersLabelProvider());
        this.fPHPDebuggers.setContentProvider((IContentProvider)new PHPDebuggersContentProvider());
        this.fPHPDebuggers.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                PHPDebuggersTable.this.enableButtons();
            }
        });
        this.fPHPDebuggers.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                if (!PHPDebuggersTable.this.fPHPDebuggers.getSelection().isEmpty()) {
                    PHPDebuggersTable.this.editSettings();
                }
            }
        });
        final Composite composite3 = new Composite((Composite)group, 0);
        composite3.setLayoutData((Object)new GridData(2));
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        composite3.setFont(font);
        this.fSettingsButton = this.createPushButton(composite3, PHPDebugUIMessages.PHPDebuggersTable_configure);
        this.fSettingsButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PHPDebuggersTable.this.editSettings();
            }
        });
        this.fPHPDebuggers.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object object, Object object2) {
                if (object instanceof IDebuggerConfiguration && object2 instanceof IDebuggerConfiguration) {
                    return ((IDebuggerConfiguration)object2).getName().compareTo(((IDebuggerConfiguration)object).getName());
                }
                return super.compare(viewer, object, object2);
            }
        });
        this.configureTableResizing((Composite)group, composite3, table, tableColumn, tableColumn2);
        this.fillWithWorkspaceDebuggers();
        this.enableButtons();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                PHPDebuggersTable.this.resizeTable((Composite)group, composite3, table, tableColumn, tableColumn2);
            }
        });
    }

    public void performDefaults() {
        AbstractDebuggerConfiguration[] abstractDebuggerConfigurationArray = PHPDebuggersRegistry.getDebuggersConfigurations();
        if (abstractDebuggerConfigurationArray == null) {
            return;
        }
        AbstractDebuggerConfiguration[] abstractDebuggerConfigurationArray2 = abstractDebuggerConfigurationArray;
        int n = abstractDebuggerConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractDebuggerConfiguration abstractDebuggerConfiguration = abstractDebuggerConfigurationArray2[n2];
            abstractDebuggerConfiguration.applyDefaults();
            ++n2;
        }
        this.fPHPDebuggers.refresh();
    }

    private void configureTableResizing(final Composite composite, final Composite composite2, final Table table, final TableColumn tableColumn, final TableColumn tableColumn2) {
        composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                PHPDebuggersTable.this.resizeTable(composite, composite2, table, tableColumn, tableColumn2);
            }
        });
        table.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                table.removeListener(9, (Listener)this);
                PHPDebuggersTable.this.resizeTable(composite, composite2, table, tableColumn, tableColumn2);
            }
        });
        tableColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                if (tableColumn.getWidth() > 0 && !PHPDebuggersTable.this.fResizingTable) {
                    PHPDebuggersTable.this.fWeight1 = PHPDebuggersTable.this.getColumnWeight(0);
                }
            }
        });
        tableColumn2.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                if (tableColumn2.getWidth() > 0 && !PHPDebuggersTable.this.fResizingTable) {
                    PHPDebuggersTable.this.fWeight2 = PHPDebuggersTable.this.getColumnWeight(1);
                }
            }
        });
    }

    private void resizeTable(Composite composite, Composite composite2, Table table, TableColumn tableColumn, TableColumn tableColumn2) {
        Point point;
        Rectangle rectangle;
        this.fResizingTable = true;
        int n = -1;
        int n2 = -1;
        if (composite.isVisible()) {
            rectangle = composite.getClientArea();
            n = rectangle.width;
            n2 = rectangle.height;
        } else {
            rectangle = composite.computeSize(-1, -1);
            n = rectangle.x;
            n2 = rectangle.y;
        }
        rectangle = table.computeSize(-1, -1);
        int n3 = n - 2 * table.getBorderWidth();
        if (rectangle.y > n2) {
            point = table.getVerticalBar().getSize();
            n3 -= point.x;
        }
        point = table.getSize();
        if (point.x > (n3 -= composite2.getSize().x)) {
            tableColumn.setWidth(Math.round((float)n3 * this.fWeight1));
            tableColumn2.setWidth(Math.round((float)n3 * this.fWeight2));
            table.setSize(n3, n2);
        } else {
            table.setSize(n3, n2);
            tableColumn.setWidth(Math.round((float)n3 * this.fWeight1));
            tableColumn2.setWidth(Math.round((float)n3 * this.fWeight2));
        }
        this.fResizingTable = false;
    }

    private float getColumnWeight(int n) {
        Table table;
        int n2 = table.getSize().x;
        table = this.fPHPDebuggers.getTable();
        int n3 = table.getColumn(n).getWidth();
        if (n2 > n3) {
            return (float)n3 / (float)n2;
        }
        switch (n) {
            case 0: {
                return 0.6f;
            }
            case 1: {
                return 0.38f;
            }
        }
        return 0.38f;
    }

    private void fillWithWorkspaceDebuggers() {
        AbstractDebuggerConfiguration[] abstractDebuggerConfigurationArray = PHPDebuggersRegistry.getDebuggersConfigurations();
        this.fPHPDebuggers.setInput((Object)abstractDebuggerConfigurationArray);
        this.fPHPDebuggers.refresh();
    }

    private void enableButtons() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fPHPDebuggers.getSelection();
        this.fSettingsButton.setEnabled(iStructuredSelection.size() == 1);
    }

    protected Button createPushButton(Composite composite, String string) {
        return SWTUtil.createPushButton((Composite)composite, (String)string, null);
    }

    private void editSettings() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fPHPDebuggers.getSelection();
        AbstractDebuggerConfiguration abstractDebuggerConfiguration = (AbstractDebuggerConfiguration)iStructuredSelection.getFirstElement();
        if (abstractDebuggerConfiguration == null) {
            return;
        }
        abstractDebuggerConfiguration.openConfigurationDialog(Display.getDefault().getActiveShell());
        this.fPHPDebuggers.refresh((Object)abstractDebuggerConfiguration);
        this.commitChanges();
    }

    protected void commitChanges() {
    }

    class PHPDebuggersContentProvider
    implements IStructuredContentProvider {
        PHPDebuggersContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            return PHPDebuggersRegistry.getDebuggersConfigurations();
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    class PHPDebuggersLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        PHPDebuggersLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof IDebuggerConfiguration) {
                IDebuggerConfiguration iDebuggerConfiguration = (IDebuggerConfiguration)object;
                switch (n) {
                    case 0: {
                        return iDebuggerConfiguration.getName();
                    }
                    case 1: {
                        int n2 = iDebuggerConfiguration.getPort();
                        if (n2 < 0) {
                            return PHPDebugUIMessages.PHPDebuggersTable_notDefined;
                        }
                        return String.valueOf(n2);
                    }
                }
            }
            return object.toString();
        }
    }
}

