/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ws.ui.wizards;

import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.datatools.enablement.oda.ws.soap.SOAPParameter;
import org.eclipse.datatools.enablement.oda.ws.soap.SOAPRequest;
import org.eclipse.datatools.enablement.oda.ws.ui.i18n.Messages;
import org.eclipse.datatools.enablement.oda.ws.ui.util.WSConsole;
import org.eclipse.datatools.enablement.oda.ws.ui.util.WSUIUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SOAPRequestPage
extends DataSetWizardPage {
    private transient Text queryText;
    private SOAPParameter[] parameters;
    private static String DEFAULT_MESSAGE = Messages.getString("soapRequestPage.message.default");
    private boolean saved = false;

    public SOAPRequestPage(String pageName) {
        super(pageName);
        this.setMessage(DEFAULT_MESSAGE);
    }

    public void createPageCustomControl(Composite parent) {
        this.setControl(this.createPageControl(parent));
        this.initializeControl();
    }

    private Control createPageControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(272);
        composite.setLayoutData((Object)layoutData);
        this.setupQueryTextComposite(composite);
        this.setupButtonComposite(composite);
        return composite;
    }

    private void setupQueryTextComposite(Composite parent) {
        this.queryText = new Text(parent, 2816);
        GridData layoutData = new GridData(1808);
        this.queryText.setLayoutData((Object)layoutData);
    }

    private void setupButtonComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData layoutData = new GridData(272);
        composite.setLayoutData((Object)layoutData);
        Button button = new Button(composite, 0);
        button.setText(Messages.getString("soapRequestPage.button.regenerateTemplate"));
        layoutData = new GridData();
        layoutData.widthHint = 120;
        button.setLayoutData((Object)layoutData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageDialog.openConfirm(null, (String)Messages.getString("soapRequestPage.title.regenerateTemplate"), (String)Messages.getString("soapRequestPage.message.regenerateTemplate"))) {
                    SOAPRequestPage.this.regenerateTemplate();
                }
            }
        });
        button = new Button(composite, 0);
        button.setText(Messages.getString("soapRequestPage.button.insertParameter"));
        layoutData = new GridData();
        layoutData.widthHint = 120;
        button.setLayoutData((Object)layoutData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterInputDialog dlg = new ParameterInputDialog();
                if (dlg.open() == 0) {
                    SOAPRequestPage.this.parameters = dlg.getSOAPParameters();
                }
            }
        });
        button = new Button(composite, 0);
        button.setText(Messages.getString("soapRequestPage.button.clear"));
        layoutData = new GridData();
        layoutData.widthHint = 120;
        button.setLayoutData((Object)layoutData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SOAPRequestPage.this.queryText.setText("");
            }
        });
    }

    private void regenerateTemplate() {
        this.queryText.setText(WSUIUtil.getNonNullString((String)WSConsole.getInstance().getTemplate()));
    }

    private void initializeControl() {
        this.initWSConsole();
        this.initFromModel();
    }

    private void initWSConsole() {
        if (!WSConsole.getInstance().isSessionOK()) {
            WSConsole.getInstance().start(this.getInitializationDesign());
        }
    }

    private void initFromModel() {
        String wsQueryText = WSConsole.getInstance().getPropertyValue("wsQueryText");
        this.queryText.setText(WSUIUtil.getNonNullString((String)wsQueryText));
        this.parameters = WSConsole.getInstance().getParameters();
        this.saved = false;
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        this.savePage(design);
        WSUIUtil.savePage(design);
        return design;
    }

    private void savePage(DataSetDesign dataSetDesign) {
        if (!WSConsole.getInstance().isSessionOK()) {
            return;
        }
        if (this.isControlCreated() && !this.saved) {
            this.saveToModel();
        }
        dataSetDesign.setQueryText(WSConsole.getInstance().getPropertyValue("wsQueryText"));
    }

    protected void refresh(DataSetDesign dataSetDesign) {
        super.refresh(dataSetDesign);
        this.initFromModel();
    }

    void refresh() {
        this.queryText.setText(WSUIUtil.getNonNullString((String)WSConsole.getInstance().manipulateTemplate()));
        this.parameters = WSConsole.getInstance().getParameters();
        this.saved = false;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public IWizardPage getNextPage() {
        this.saveToModel();
        return super.getNextPage();
    }

    protected boolean canLeave() {
        this.saveToModel();
        return super.canLeave();
    }

    private void saveToModel() {
        WSConsole.getInstance().setPropertyValue("wsQueryText", this.queryText.getText());
        WSConsole.getInstance().setParameters(this.parameters);
        this.saved = true;
    }

    protected void cleanup() {
        WSConsole.getInstance().terminateSession();
    }

    class ParameterInputDialog
    extends StatusDialog {
        private TableViewer viewer;
        private SOAPRequest soapRequest;
        private final String COLUMN_NAME = Messages.getString("parameterInputDialog.column.name");
        private final String COLUMN_DATATYPE = Messages.getString("parameterInputDialog.column.type");
        private final String COLUMN_DEFAULTVALUE = Messages.getString("parameterInputDialog.column.defaultValue");

        public ParameterInputDialog() {
            super(PlatformUI.getWorkbench().getDisplay().getActiveShell());
        }

        public void create() {
            super.create();
            Point pt = this.getShell().computeSize(-1, -1);
            pt.x = Math.max(pt.x, 400);
            pt.y = Math.max(pt.y, 200);
            this.getShell().setSize(pt);
            this.getShell().setText(SOAPRequestPage.this.getTitle());
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 10;
            layout.marginWidth = 10;
            composite.setLayout((Layout)layout);
            composite.setLayout((Layout)layout);
            this.createCustomControls(composite);
            this.initParameters();
            return composite;
        }

        private void createCustomControls(Composite parent) {
            Table table = new Table(parent, 67584);
            TableLayout tableLayout = new TableLayout();
            table.setLayout((Layout)tableLayout);
            GridData layouData = new GridData(1808);
            table.setLayoutData((Object)layouData);
            table.setHeaderVisible(true);
            table.setLinesVisible(true);
            TableColumn column0 = new TableColumn(table, 0);
            column0.setText(this.COLUMN_NAME);
            column0.setWidth(150);
            TableColumn column1 = new TableColumn(table, 0);
            column1.setText(this.COLUMN_DATATYPE);
            column1.setWidth(100);
            TableColumn column2 = new TableColumn(table, 0);
            column2.setText(this.COLUMN_DEFAULTVALUE);
            column2.setWidth(150);
            this.viewer = new TableViewer(table);
            this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(this){
                final /* synthetic */ ParameterInputDialog this$1;
                {
                    this.this$1 = parameterInputDialog;
                }

                public Object[] getElements(Object inputElement) {
                    if (inputElement == null || !(inputElement instanceof SOAPParameter[])) {
                        return new Object[0];
                    }
                    return (SOAPParameter[])inputElement;
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }
            });
            this.viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(this){
                final /* synthetic */ ParameterInputDialog this$1;
                {
                    this.this$1 = parameterInputDialog;
                }

                public Image getColumnImage(Object element, int columnIndex) {
                    return null;
                }

                public String getColumnText(Object element, int columnIndex) {
                    SOAPParameter param = (SOAPParameter)element;
                    String value = "";
                    switch (columnIndex) {
                        case 0: {
                            value = param.getName();
                            break;
                        }
                        case 1: {
                            value = "";
                            break;
                        }
                        case 2: {
                            value = param.getDefaultValue();
                        }
                    }
                    return WSUIUtil.getNonNullString((String)value);
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            });
            this.setupEditors();
        }

        private void setupEditors() {
            CellEditor[] editors = new CellEditor[3];
            int i = 0;
            while (i < editors.length) {
                editors[i] = new TextCellEditor((Composite)this.viewer.getTable(), 0);
                ++i;
            }
            this.viewer.setCellEditors(editors);
            this.viewer.setColumnProperties(new String[]{this.COLUMN_NAME, this.COLUMN_DATATYPE, this.COLUMN_DEFAULTVALUE});
            this.viewer.setCellModifier(new ICellModifier(this){
                final /* synthetic */ ParameterInputDialog this$1;
                {
                    this.this$1 = parameterInputDialog;
                }

                public boolean canModify(Object element, String property) {
                    return property.equals(ParameterInputDialog.access$0(this.this$1));
                }

                public Object getValue(Object element, String property) {
                    return WSUIUtil.getNonNullString((String)((SOAPParameter)element).getDefaultValue());
                }

                public void modify(Object element, String property, Object value) {
                    SOAPParameter soapParameter = (SOAPParameter)((TableItem)element).getData();
                    soapParameter.setDefaultValue(value.toString());
                    ParameterInputDialog.access$1(this.this$1).refresh();
                }
            });
        }

        private void initParameters() {
            this.soapRequest = new SOAPRequest(SOAPRequestPage.this.queryText.getText());
            this.mergeParameters();
            this.viewer.setInput((Object)this.soapRequest.getParameters());
        }

        private void mergeParameters() {
            if (!this.canMerge()) {
                return;
            }
            SOAPParameter[] soapParameters = this.soapRequest.getParameters();
            int i = 0;
            while (i < SOAPRequestPage.this.parameters.length) {
                if (!WSUIUtil.isNull((Object)SOAPRequestPage.this.parameters[i])) {
                    soapParameters[i].setDefaultValue(SOAPRequestPage.this.parameters[i].getDefaultValue());
                }
                ++i;
            }
        }

        private boolean canMerge() {
            SOAPParameter[] soapParameters = this.soapRequest.getParameters();
            if (SOAPRequestPage.this.parameters == null || soapParameters == null) {
                return false;
            }
            if (SOAPRequestPage.this.parameters.length != soapParameters.length) {
                return false;
            }
            int i = 0;
            while (i < SOAPRequestPage.this.parameters.length) {
                if (!WSUIUtil.isNull((Object)SOAPRequestPage.this.parameters[i]) && !SOAPRequestPage.this.parameters[i].getName().equals(soapParameters[i].getName())) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        SOAPParameter[] getSOAPParameters() {
            return this.soapRequest.getParameters();
        }

        static /* synthetic */ String access$0(ParameterInputDialog parameterInputDialog) {
            return parameterInputDialog.COLUMN_DEFAULTVALUE;
        }

        static /* synthetic */ TableViewer access$1(ParameterInputDialog parameterInputDialog) {
            return parameterInputDialog.viewer;
        }
    }
}

