/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class CCOverLayIconUtility {
    private static final URL BASE_URL = ConnectivityUIPlugin.getDefault().getBundle().getEntry("/");
    public static final ImageDescriptor RUNNING = CCOverLayIconUtility.create("icons/full/ovr16/", "obj_ovr_server.gif");
    public static final ImageDescriptor OFFLINE = CCOverLayIconUtility.create("icons/full/ovr16/", "obj_ovr_server_off.gif");
    private static CCOverLayIconUtility _Default;

    private CCOverLayIconUtility() {
    }

    public static CCOverLayIconUtility getDefault() {
        if (_Default == null) {
            _Default = new CCOverLayIconUtility();
        }
        return _Default;
    }

    public Image addOverlayIcon(Image baseImage, ImageDescriptor overlay) {
        InternalOverlayIcon icon = overlay == RUNNING ? new InternalOverlayIcon(baseImage, RUNNING, true, false) : (overlay == OFFLINE ? new InternalOverlayIcon(baseImage, OFFLINE, true, false) : new InternalOverlayIcon(baseImage, null, true, true));
        return icon.createImage();
    }

    private static ImageDescriptor create(String prefix, String name) {
        return ImageDescriptor.createFromURL((URL)CCOverLayIconUtility.makeImageURL(prefix, name));
    }

    private static URL makeImageURL(String prefix, String name) {
        String path = prefix + name;
        URL url = null;
        try {
            url = new URL(BASE_URL, path);
        }
        catch (MalformedURLException e) {
            return null;
        }
        return url;
    }

    private class InternalOverlayIcon
    extends CompositeImageDescriptor {
        private ImageDescriptor m_Overlay;
        private Image m_image;
        private boolean m_left;
        private boolean m_top;

        public InternalOverlayIcon(Image baseImage, ImageDescriptor overlay, boolean left, boolean top) {
            this.m_image = baseImage;
            this.m_Overlay = overlay;
            this.m_left = left;
            this.m_top = top;
        }

        protected void drawCompositeImage(int width, int height) {
            this.drawImage(this.m_image.getImageData(), 0, 0);
            if (this.m_Overlay != null) {
                ImageData id = this.m_Overlay.getImageData();
                int ox = this.m_left ? 0 : width - id.width;
                int oy = this.m_top ? 0 : height - id.height;
                if (id != null) {
                    this.drawImage(id, ox, oy);
                }
            }
        }

        protected Point getSize() {
            return new Point(16, 16);
        }
    }
}

