/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DefaultLabelProvider;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public abstract class AbstractDebugSelectionDialog
extends SelectionDialog {
    protected StructuredViewer fViewer = null;

    public AbstractDebugSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    protected abstract String getDialogSettingsId();

    protected abstract Object getViewerInput();

    protected abstract StructuredViewer createViewer(Composite var1);

    protected IContentProvider getContentProvider() {
        return new ArrayContentProvider();
    }

    protected IBaseLabelProvider getLabelProvider() {
        return new DefaultLabelProvider();
    }

    protected abstract String getHelpContextId();

    protected void addViewerListeners(StructuredViewer viewer) {
    }

    protected void addCustomHeaderControls(Composite parent) {
    }

    protected void addCustomFooterControls(Composite parent) {
    }

    protected void initializeControls() {
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite comp = (Composite)super.createDialogArea(parent);
        this.addCustomHeaderControls(comp);
        String label = this.getMessage();
        if (label != null && !"".equals(label)) {
            SWTFactory.createWrapLabel(comp, label, 1);
        }
        if ((label = this.getViewerLabel()) != null && !"".equals(label)) {
            SWTFactory.createLabel(comp, label, 1);
        }
        this.fViewer = this.createViewer(comp);
        this.fViewer.setLabelProvider(this.getLabelProvider());
        this.fViewer.setContentProvider(this.getContentProvider());
        this.fViewer.setInput(this.getViewerInput());
        this.addViewerListeners(this.fViewer);
        this.addCustomFooterControls(comp);
        this.initializeControls();
        Dialog.applyDialogFont((Control)comp);
        String help = this.getHelpContextId();
        if (help != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, help);
        }
        return comp;
    }

    protected abstract String getViewerLabel();

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = DebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsId());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsId());
        }
        return section;
    }

    protected Point getInitialSize() {
        IDialogSettings settings = this.getDialogBoundsSettings();
        if (settings != null) {
            try {
                int width = settings.getInt("DIALOG_WIDTH");
                int height = settings.getInt("DIALOG_HEIGHT");
                if (width > 0 & height > 0) {
                    return new Point(width, height);
                }
            }
            catch (NumberFormatException numberFormatException) {
                return new Point(300, 350);
            }
        }
        return new Point(300, 350);
    }
}

