/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.PublishServerJob;
import org.eclipse.wst.server.core.internal.RestartServerJob;
import org.eclipse.wst.server.core.internal.ServerPreferences;
import org.eclipse.wst.server.core.internal.ServerType;
import org.eclipse.wst.server.core.internal.StartServerJob;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.provisional.UIDecoratorManager;
import org.eclipse.wst.server.ui.internal.view.servers.AbstractServerAction;

public class StartAction
extends AbstractServerAction {
    protected String launchMode = "run";

    public StartAction(Shell shell, ISelectionProvider selectionProvider, String launchMode) {
        super(shell, selectionProvider, "start");
        this.launchMode = launchMode;
        if (launchMode == "run") {
            this.setToolTipText(Messages.actionStartToolTip);
            this.setText(Messages.actionStart);
            this.setImageDescriptor(ImageResource.getImageDescriptor("IMG_ELCL_START"));
            this.setHoverImageDescriptor(ImageResource.getImageDescriptor("IMG_CLCL_START"));
            this.setDisabledImageDescriptor(ImageResource.getImageDescriptor("IMG_DLCL_START"));
        } else if (launchMode == "debug") {
            this.setToolTipText(Messages.actionDebugToolTip);
            this.setText(Messages.actionDebug);
            this.setImageDescriptor(ImageResource.getImageDescriptor("IMG_ELCL_START_DEBUG"));
            this.setHoverImageDescriptor(ImageResource.getImageDescriptor("IMG_CLCL_START_DEBUG"));
            this.setDisabledImageDescriptor(ImageResource.getImageDescriptor("IMG_DLCL_START_DEBUG"));
        } else if (launchMode == "profile") {
            this.setToolTipText(Messages.actionProfileToolTip);
            this.setText(Messages.actionProfile);
            this.setImageDescriptor(ImageResource.getImageDescriptor("IMG_ELCL_START_PROFILE"));
            this.setHoverImageDescriptor(ImageResource.getImageDescriptor("IMG_CLCL_START_PROFILE"));
            this.setDisabledImageDescriptor(ImageResource.getImageDescriptor("IMG_DLCL_START_PROFILE"));
        }
        try {
            this.selectionChanged((IStructuredSelection)selectionProvider.getSelection());
        }
        catch (Exception exception) {}
    }

    public boolean accept(IServer server) {
        if (server.getServerState() != 2) {
            return server.canStart(this.launchMode).isOK();
        }
        String mode2 = this.launchMode;
        if (mode2 == null) {
            mode2 = server.getMode();
        }
        return server.getServerType() != null && UIDecoratorManager.getUIDecorator(server.getServerType()).canRestart() && server.canRestart(mode2).isOK();
    }

    public void perform(IServer server) {
        block11: {
            if (server.getServerState() != 2) {
                if (!ServerUIPlugin.saveEditors()) {
                    return;
                }
                if (!ServerPreferences.getInstance().isAutoPublishing()) {
                    StartServerJob startJob = new StartServerJob(server, this.launchMode);
                    startJob.schedule();
                    return;
                }
                try {
                    PublishServerJob publishJob = new PublishServerJob(server, 1, false);
                    StartServerJob startJob = new StartServerJob(server, this.launchMode);
                    if (((ServerType)server.getServerType()).startBeforePublish()) {
                        startJob.setNextJob((Job)publishJob);
                        startJob.schedule();
                        break block11;
                    }
                    publishJob.setNextJob((Job)startJob);
                    publishJob.schedule();
                }
                catch (Exception e) {
                    Trace.trace((byte)3, "Error starting server", e);
                }
            } else {
                if (!ServerUIPlugin.promptIfDirty(this.shell, server)) {
                    return;
                }
                try {
                    String launchMode2 = this.launchMode;
                    if (launchMode2 == null) {
                        launchMode2 = server.getMode();
                    }
                    RestartServerJob restartJob = new RestartServerJob(server, launchMode2);
                    restartJob.schedule();
                }
                catch (Exception e) {
                    Trace.trace((byte)3, "Error restarting server", e);
                }
            }
        }
    }
}

