/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.ISite;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.extension.ExtensionUtility;
import org.eclipse.wst.server.ui.internal.viewers.ExtensionContentProvider;
import org.eclipse.wst.server.ui.internal.viewers.ExtensionTableLabelProvider;

public class ExtensionComposite
extends Composite {
    protected Table table;
    protected TableViewer tableViewer;
    protected Font font;
    protected HashMap images;
    protected String progress;
    protected int totalWork;
    protected double currentWork;
    protected int count;
    public FeatureSelectionListener listener;

    public ExtensionComposite(Composite parent, int style, FeatureSelectionListener listener) {
        super(parent, style);
        this.listener = listener;
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        this.setLayout((Layout)layout);
        Font currentFont = this.getFont();
        FontData[] fd = currentFont.getFontData();
        int size2 = fd.length;
        int i = 0;
        while (i < size2) {
            fd[i].setHeight(fd[i].getHeight() + 2);
            fd[i].setStyle(1);
            ++i;
        }
        this.font = new Font((Device)this.getDisplay(), fd);
        GridData data = new GridData(1808);
        data = new GridData(784);
        data.heightHint = 350;
        this.setLayoutData(data);
        this.table = new Table((Composite)this, 68354);
        data = new GridData(1808);
        data.widthHint = 350;
        this.table.setLayoutData((Object)data);
        this.table.setLinesVisible(true);
        this.tableViewer = new TableViewer(this.table);
        this.table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ExtensionComposite.this.disposeResources();
            }
        });
        TableLayout tableLayout = new TableLayout();
        this.table.setLayout((Layout)tableLayout);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, 250, false));
        TableColumn col = new TableColumn(this.table, 0);
        col.setText("null");
        this.table.setHeaderVisible(false);
        this.table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.gc.setFont(ExtensionComposite.this.font);
                Point size = event.gc.textExtent("A");
                int h = 9 + size.y;
                event.gc.setFont(null);
                size = event.gc.textExtent("A");
                h += size.y;
                h = Math.max(h, 46);
                event.width = 400;
                event.height = Math.max(event.height, h);
            }
        });
        this.table.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                event.detail &= 0xFFFFFFEF;
            }
        });
        this.table.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                Object obj = item.getData();
                int width = ExtensionComposite.this.table.getColumn(0).getWidth();
                GC gc = event.gc;
                if (obj instanceof String) {
                    String s = (String)obj;
                    if (ExtensionComposite.this.progress != null) {
                        s = ExtensionComposite.this.progress;
                    }
                    int h = event.y + event.height / 2;
                    Point size = event.gc.textExtent(s);
                    gc.drawText(s, event.x + 3, h - size.y / 2, true);
                    int hh = event.y + event.height - 5 - 3 - 1;
                    gc.setLineWidth(2);
                    Color color = ExtensionComposite.this.getDisplay().getSystemColor(26);
                    gc.setBackground(color);
                    int width2 = 0;
                    int step = 9;
                    if (ExtensionComposite.this.totalWork > 0) {
                        width2 = (int)((double)(width - step * 2 - 15 - 6) * ExtensionComposite.this.currentWork / (double)ExtensionComposite.this.totalWork);
                    }
                    int i = 0;
                    while (i < width2) {
                        gc.fillRectangle(event.x + 3 + i, hh, step - 2, 5);
                        i += step;
                    }
                    return;
                }
                IFeature ei = (IFeature)obj;
                if (ei == null) {
                    return;
                }
                String name = ei.getLabel();
                String provider = ei.getProvider();
                String version = "v" + ei.getVersionedIdentifier().getVersion().toString();
                Image image = ExtensionComposite.this.getImage(ei.getImage());
                if (image == null) {
                    image = ImageResource.getImage("newServerWiz");
                }
                int iw = image.getBounds().width;
                int ih = image.getBounds().height;
                gc.drawImage(image, 0, 0, iw, ih, event.x + 3, event.y + 3, 40, 40);
                iw = 46;
                int yOffset = 3;
                gc.setFont(ExtensionComposite.this.font);
                gc.drawText(name, event.x + iw, event.y + yOffset, true);
                Point size = event.gc.textExtent(name);
                gc.setFont(null);
                gc.drawText(provider, event.x + iw, event.y + (yOffset += size.y + 3), true);
                size = event.gc.textExtent(version);
                gc.drawText(version, event.x + width - 6 - size.x, event.y + yOffset, true);
            }
        });
        this.tableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                try {
                    IFeature f1 = (IFeature)e1;
                    IFeature f2 = (IFeature)e2;
                    return f1.getLabel().compareToIgnoreCase(f2.getLabel());
                }
                catch (Exception exception) {
                    return 0;
                }
            }
        });
        final Label description = new Label((Composite)this, 64);
        description.setText("Multi\nLine\nMessage");
        Dialog.applyDialogFont((Control)this);
        Point p = description.computeSize(-1, -1);
        description.setText("");
        data = new GridData(772);
        data.horizontalSpan = 2;
        data.heightHint = p.y > 10 ? p.y : 42;
        description.setLayoutData((Object)data);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection sel = (StructuredSelection)ExtensionComposite.this.tableViewer.getSelection();
                Object obj = sel.getFirstElement();
                IFeature feature = null;
                if (obj instanceof IFeature) {
                    feature = (IFeature)obj;
                }
                ExtensionComposite.this.handleSelection(feature);
                if (feature != null) {
                    description.setText(ExtensionUtility.getDescription(feature));
                } else {
                    description.setText("");
                }
            }
        });
        this.deferInitialization();
    }

    protected Image getImage(URL url) {
        if (url == null) {
            return null;
        }
        try {
            Image image = (Image)this.images.get(url.toString());
            if (image != null) {
                return image;
            }
        }
        catch (Exception exception) {}
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)url);
            Image image = id.createImage();
            if (this.images == null) {
                this.images = new HashMap();
            }
            this.images.put(url.toString(), image);
            return image;
        }
        catch (Exception e) {
            Trace.trace((byte)1, "Could not create image", e);
            return null;
        }
    }

    protected void disposeResources() {
        try {
            this.font.dispose();
            if (this.images != null) {
                Iterator iterator = this.images.values().iterator();
                while (iterator.hasNext()) {
                    Image image = (Image)iterator.next();
                    image.dispose();
                }
            }
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Could not dispose - possible resource leak", e);
        }
    }

    protected void handleSelection(IFeature feature) {
        this.listener.featureSelected(feature);
    }

    protected void deferInitialization() {
        Runnable[] animator;
        Object[] obj = new Object[]{Messages.viewInitializing};
        this.tableViewer.setContentProvider((IContentProvider)new ExtensionContentProvider(obj));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ExtensionTableLabelProvider());
        this.tableViewer.setInput((Object)"root");
        final Thread t = new Thread(){

            public void run() {
                ExtensionComposite.this.deferredInitialize(new IProgressMonitor(this){
                    final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void beginTask(String name, int totalWork2) {
                        7.access$0(this.this$1).totalWork = totalWork2;
                        7.access$0(this.this$1).progress = name;
                    }

                    public void setTaskName(String name) {
                        7.access$0(this.this$1).progress = name;
                    }

                    public void subTask(String name) {
                        7.access$0(this.this$1).progress = name;
                    }

                    public void done() {
                    }

                    public void internalWorked(double work) {
                        7.access$0(this.this$1).currentWork += work;
                    }

                    public boolean isCanceled() {
                        return false;
                    }

                    public void setCanceled(boolean value) {
                    }

                    public void worked(int work) {
                        7.access$0(this.this$1).currentWork += (double)work;
                    }
                });
            }

            static /* synthetic */ ExtensionComposite access$0(7 var0) {
                return var0.ExtensionComposite.this;
            }
        };
        t.setDaemon(true);
        t.start();
        final Display display = this.getDisplay();
        animator = new Runnable[]{new Runnable(){

            public void run() {
                if (t.isAlive()) {
                    ++ExtensionComposite.this.count;
                    try {
                        Object[] rootElements = ((IStructuredContentProvider)ExtensionComposite.this.tableViewer.getContentProvider()).getElements(null);
                        ExtensionComposite.this.tableViewer.update(rootElements, null);
                    }
                    catch (Exception exception) {}
                    display.timerExec(200, animator[0]);
                }
            }
        }};
        display.timerExec(200, animator[0]);
    }

    public void deferredInitialize(IProgressMonitor monitor) {
        final ArrayList list = new ArrayList();
        ExtensionUtility.FeatureListener listener2 = new ExtensionUtility.FeatureListener(){

            public void featureFound(IFeature feature) {
                list.add(feature);
                int size = list.size();
                Object[] obj = new Object[size + 1];
                list.toArray(obj);
                obj[size] = ExtensionComposite.this.progress != null ? ExtensionComposite.this.progress : Messages.viewInitializing;
                Display.getDefault().asyncExec(new Runnable(this, obj){
                    final /* synthetic */ 10 this$1;
                    private final /* synthetic */ Object[] val$obj;
                    {
                        this.this$1 = var1_1;
                        this.val$obj = objectArray;
                    }

                    public void run() {
                        if (!10.access$0(this.this$1).table.isDisposed()) {
                            10.access$0(this.this$1).tableViewer.setContentProvider((IContentProvider)new ExtensionContentProvider(this.val$obj));
                        }
                    }
                });
            }

            public void featureRemoved(IFeature feature) {
                list.remove(feature);
            }

            public void siteFailure(ISite site, CoreException ce) {
            }

            static /* synthetic */ ExtensionComposite access$0(10 var0) {
                return var0.ExtensionComposite.this;
            }
        };
        String id = "org.eclipse.wst.server.core.serverAdapter";
        try {
            final IFeature[] ef = ExtensionUtility.getAllFeatures(id, listener2, monitor);
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (!ExtensionComposite.this.table.isDisposed()) {
                        ExtensionComposite.this.tableViewer.setContentProvider((IContentProvider)new ExtensionContentProvider(ef));
                    }
                }
            });
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
    }

    protected Object getSelection(ISelection sel2) {
        IStructuredSelection sel = (IStructuredSelection)sel2;
        return sel.getFirstElement();
    }

    public static interface FeatureSelectionListener {
        public void featureSelected(IFeature var1);
    }
}

