/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.jdt.dbunit.internal.buildpath;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.buildpath.BuildPathSupport;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.buildpath.DbUnitContainerInitializer;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.ui.DbUnitMessages;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.ui.DbUnitPluginImages;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.util.DbUnitStatus;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.util.PixelConverter;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DbUnitContainerWizardPage
extends NewElementWizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension {
    private IClasspathEntry fContainerEntryResult;
    private Label fResolvedPath;

    public DbUnitContainerWizardPage() {
        super("DbUnitContainerPage");
        this.setTitle(DbUnitMessages.DbUnitContainerWizardPage_wizard_title);
        this.setDescription(DbUnitMessages.DbUnitContainerWizardPage_wizard_description);
        this.setImageDescriptor(DbUnitPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        this.fContainerEntryResult = JavaCore.newContainerEntry((IPath)DbUnitContainerInitializer.DBUNIT2_PATH);
    }

    public static IJavaProject getPlaceholderProject() {
        String name = "####internal";
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project;
        while ((project = root.getProject(name)).exists()) {
            name = String.valueOf(name) + '1';
        }
        return JavaCore.create((IProject)project);
    }

    public boolean finish() {
        try {
            IJavaProject[] javaProjects = new IJavaProject[]{DbUnitContainerWizardPage.getPlaceholderProject()};
            IClasspathContainer[] containers = new IClasspathContainer[1];
            JavaCore.setClasspathContainer((IPath)this.fContainerEntryResult.getPath(), (IJavaProject[])javaProjects, (IClasspathContainer[])containers, null);
        }
        catch (JavaModelException e) {
            ExceptionHandler.showException((Shell)this.getShell(), (String)DbUnitMessages.DbUnitContainerWizardPage_error_title, (String)DbUnitMessages.DbUnitContainerWizardPage_error_problem_configuring_container, (Throwable)e);
            return false;
        }
        return true;
    }

    public IClasspathEntry getSelection() {
        return this.fContainerEntryResult;
    }

    public void setSelection(IClasspathEntry containerEntry) {
        this.fContainerEntryResult = containerEntry;
    }

    public void createControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setFont(composite.getFont());
        label.setText(DbUnitMessages.DbUnitContainerWizardPage_resolved_label);
        label.setLayoutData((Object)new GridData(4, 1, false, false, 1, 1));
        this.fResolvedPath = new Label(composite, 64);
        GridData data = new GridData(4, 4, true, false, 1, 1);
        data.widthHint = converter.convertWidthInCharsToPixels(60);
        this.fResolvedPath.setFont(composite.getFont());
        this.fResolvedPath.setLayoutData((Object)data);
        this.doSelectionChanged();
        this.setControl((Control)composite);
    }

    protected void doSelectionChanged() {
        DbUnitStatus status = new DbUnitStatus();
        IPath containerPath = DbUnitContainerInitializer.DBUNIT2_PATH;
        IClasspathEntry libEntry = BuildPathSupport.getDbUnit2LibraryEntry();
        if (libEntry == null) {
            status.setError(DbUnitMessages.DbUnitContainerWizardPage_error_version_not_available);
        }
        this.fContainerEntryResult = JavaCore.newContainerEntry((IPath)containerPath);
        if (this.fResolvedPath != null && !this.fResolvedPath.isDisposed()) {
            if (libEntry != null) {
                this.fResolvedPath.setText(libEntry.getPath().toOSString());
            } else {
                this.fResolvedPath.setText(new String());
            }
        }
        this.updateStatus(status);
    }

    public void initialize(IJavaProject project, IClasspathEntry[] currentEntries) {
    }
}

