/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;

public class CompositeActionGroup
extends ActionGroup {
    private ActionGroup[] fGroups;

    public CompositeActionGroup() {
    }

    public CompositeActionGroup(ActionGroup[] actionGroupArray) {
        this.setGroups(actionGroupArray);
    }

    protected void setGroups(ActionGroup[] actionGroupArray) {
        Assert.isTrue((this.fGroups == null ? 1 : 0) != 0);
        Assert.isNotNull((Object)actionGroupArray);
        this.fGroups = actionGroupArray;
    }

    public ActionGroup get(int n) {
        if (this.fGroups == null) {
            return null;
        }
        return this.fGroups[n];
    }

    public void addGroup(ActionGroup actionGroup) {
        if (this.fGroups == null) {
            this.fGroups = new ActionGroup[]{actionGroup};
        } else {
            ActionGroup[] actionGroupArray = new ActionGroup[this.fGroups.length + 1];
            System.arraycopy(this.fGroups, 0, actionGroupArray, 0, this.fGroups.length);
            actionGroupArray[this.fGroups.length] = actionGroup;
            this.fGroups = actionGroupArray;
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fGroups == null) {
            return;
        }
        int n = 0;
        while (n < this.fGroups.length) {
            this.fGroups[n].dispose();
            ++n;
        }
    }

    public void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        if (this.fGroups == null) {
            return;
        }
        int n = 0;
        while (n < this.fGroups.length) {
            this.fGroups[n].fillActionBars(iActionBars);
            ++n;
        }
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        super.fillContextMenu(iMenuManager);
        if (this.fGroups == null) {
            return;
        }
        int n = 0;
        while (n < this.fGroups.length) {
            this.fGroups[n].fillContextMenu(iMenuManager);
            ++n;
        }
    }

    public void setContext(ActionContext actionContext) {
        super.setContext(actionContext);
        if (this.fGroups == null) {
            return;
        }
        int n = 0;
        while (n < this.fGroups.length) {
            this.fGroups[n].setContext(actionContext);
            ++n;
        }
    }

    public void updateActionBars() {
        super.updateActionBars();
        if (this.fGroups == null) {
            return;
        }
        int n = 0;
        while (n < this.fGroups.length) {
            this.fGroups[n].updateActionBars();
            ++n;
        }
    }
}

