/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.model;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;

public class ExtendedWorkbenchContentProvider
extends BaseWorkbenchContentProvider {
    private boolean isProvidingExternals;

    public ExtendedWorkbenchContentProvider() {
        this.isProvidingExternals = true;
    }

    public ExtendedWorkbenchContentProvider(boolean bl) {
        this.isProvidingExternals = bl;
    }

    public void setProvideExternalFiles(boolean bl) {
        this.isProvidingExternals = bl;
    }

    public boolean isProvidingExternalFiles() {
        return this.isProvidingExternals;
    }

    public Object[] getChildren(Object object) {
        Object[] objectArray = super.getChildren(object);
        if (this.isProvidingExternals && object instanceof IWorkspaceRoot) {
            Object[] objectArray2 = ExternalFilesRegistry.getInstance().getAllAsIFiles();
            if ((objectArray2 = this.filterNonExistingFiles((IFile[])objectArray2)).length > 0) {
                if (objectArray.length == 0) {
                    return objectArray2;
                }
                Object[] objectArray3 = new Object[objectArray.length + objectArray2.length];
                System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
                System.arraycopy(objectArray2, 0, objectArray3, objectArray.length, objectArray2.length);
                return objectArray3;
            }
        }
        return objectArray;
    }

    private IFile[] filterNonExistingFiles(IFile[] iFileArray) {
        ArrayList<IFile> arrayList = new ArrayList<IFile>(iFileArray.length);
        int n = 0;
        while (n < iFileArray.length) {
            if (iFileArray[n].getFullPath().toFile().exists()) {
                arrayList.add(iFileArray[n]);
            }
            ++n;
        }
        IFile[] iFileArray2 = new IFile[arrayList.size()];
        arrayList.toArray(iFileArray2);
        return iFileArray2;
    }
}

