/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.preferences;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.php.internal.ui.preferences.AbstractPHPPreferencePageBlock;
import org.eclipse.php.internal.ui.util.ScrolledPageContent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.internal.forms.widgets.FormUtil;
import org.eclipse.wst.xml.ui.internal.preferences.EncodingSettings;
import org.osgi.service.prefs.BackingStoreException;

public class PHPDebugPreferencesAddon
extends AbstractPHPPreferencePageBlock {
    private static final String SERVERS_PAGE_ID = "org.eclipse.php.server.internal.ui.PHPServersPreferencePage";
    private static final String PHP_EXE_PAGE_ID = "org.eclipse.php.debug.ui.preferencesphps.PHPsPreferencePage";
    private Button fStopAtFirstLine;
    private Combo fDefaultDebugger;
    private Combo fDefaultServer;
    private Combo fDefaultPHPExe;
    private Collection<String> debuggersIds;
    private EncodingSettings fDebugEncodingSettings;
    private EncodingSettings fOutputEncodingSettings;
    private PreferencePage propertyPage;
    private ExpandableComposite expandbleDebugEncoding;
    private ExpandableComposite expandbleOutputEncoding;

    public void setCompositeAddon(Composite composite) {
        Composite composite2 = this.addPageContents(composite);
        this.addProjectPreferenceSubsection(this.createSubsection(composite2, PHPDebugUIMessages.PhpDebugPreferencePage_6));
    }

    public void initializeValues(PreferencePage preferencePage) {
        String string;
        IEclipsePreferences iEclipsePreferences;
        this.propertyPage = preferencePage;
        Preferences preferences = PHPProjectPreferences.getModelPreferences();
        IScopeContext[] iScopeContextArray = this.createPreferenceScopes(preferencePage);
        boolean bl = preferences.getBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE);
        String string2 = PHPDebuggersRegistry.getDebuggerName((String)preferences.getString(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID));
        String string3 = ServersManager.getDefaultServer(null).getName();
        PHPexes pHPexes = PHPexes.getInstance();
        String string4 = PHPDebugUIMessages.PhpDebugPreferencePage_noExeDefined;
        if (pHPexes.hasItems(PHPDebugPlugin.getCurrentDebuggerId())) {
            string4 = pHPexes.getDefaultItem(PHPDebugPlugin.getCurrentDebuggerId()).getName();
        }
        String string5 = preferences.getString(PHPDebugCorePreferenceNames.TRANSFER_ENCODING);
        String string6 = preferences.getString(PHPDebugCorePreferenceNames.OUTPUT_ENCODING);
        this.loadDebuggers(this.fDefaultDebugger);
        this.loadServers(this.fDefaultServer);
        boolean bl2 = false;
        if (iScopeContextArray[0] instanceof ProjectScope && (iEclipsePreferences = iScopeContextArray[0].getNode(this.getPreferenceNodeQualifier())) != null && this.getProject(preferencePage) != null && !(string = ServersManager.getDefaultServer((IProject)this.getProject(preferencePage)).getName()).equals("")) {
            String string7 = iEclipsePreferences.get(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, PHPDebugPlugin.getCurrentDebuggerId());
            string2 = PHPDebuggersRegistry.getDebuggerName((String)string7);
            string3 = string;
            bl = iEclipsePreferences.getBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, bl);
            string5 = iEclipsePreferences.get(PHPDebugCorePreferenceNames.TRANSFER_ENCODING, "");
            string6 = iEclipsePreferences.get(PHPDebugCorePreferenceNames.OUTPUT_ENCODING, "");
            if (PHPDebugUIMessages.PhpDebugPreferencePage_noExeDefined.equals(string4 = iEclipsePreferences.get(PHPDebugCorePreferenceNames.DEFAULT_PHP, string4)) && pHPexes.hasItems(string7)) {
                string4 = pHPexes.getDefaultItem(string7).getName();
                iEclipsePreferences.put(PHPDebugCorePreferenceNames.DEFAULT_PHP, string4);
                try {
                    iEclipsePreferences.flush();
                }
                catch (BackingStoreException backingStoreException) {}
            }
            this.loadPHPExes(this.fDefaultPHPExe, pHPexes.getItems(iEclipsePreferences.get(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, PHPDebugPlugin.getCurrentDebuggerId())));
            bl2 = true;
        }
        if (!bl2) {
            this.loadPHPExes(this.fDefaultPHPExe, pHPexes.getItems(PHPDebugPlugin.getCurrentDebuggerId()));
        }
        this.fStopAtFirstLine.setSelection(bl);
        this.fDefaultDebugger.select(this.fDefaultDebugger.indexOf(string2));
        this.fDefaultServer.select(this.fDefaultServer.indexOf(string3));
        this.fDefaultPHPExe.select(this.fDefaultPHPExe.indexOf(string4));
        this.fDebugEncodingSettings.setIANATag(string5);
        this.fOutputEncodingSettings.setIANATag(string6);
    }

    public boolean performOK(boolean bl) {
        this.savePreferences(bl);
        return true;
    }

    public void performApply(boolean bl) {
        this.performOK(bl);
    }

    public boolean performCancel() {
        return true;
    }

    public void performDefaults() {
        Preferences preferences = PHPProjectPreferences.getModelPreferences();
        this.fStopAtFirstLine.setSelection(preferences.getDefaultBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE));
        this.loadDebuggers(this.fDefaultDebugger);
        this.loadServers(this.fDefaultServer);
        this.loadPHPExes(this.fDefaultPHPExe, PHPexes.getInstance().getItems(PHPDebugPlugin.getCurrentDebuggerId()));
        this.fDebugEncodingSettings.setIANATag(preferences.getDefaultString(PHPDebugCorePreferenceNames.TRANSFER_ENCODING));
        this.fOutputEncodingSettings.setIANATag(preferences.getDefaultString(PHPDebugCorePreferenceNames.OUTPUT_ENCODING));
    }

    protected String getPreferenceNodeQualifier() {
        return PHPProjectPreferences.getPreferenceNodeQualifier();
    }

    private void addProjectPreferenceSubsection(Composite composite) {
        GridData gridData = (GridData)composite.getLayoutData();
        gridData.heightHint = 240;
        composite.setLayoutData((Object)gridData);
        this.addLabelControl(composite, PHPDebugUIMessages.PhpDebugPreferencePage_phpDebugger, PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID);
        this.fDefaultDebugger = this.addCombo(composite, 2);
        new Label(composite, 0);
        this.addLabelControl(composite, PHPDebugUIMessages.PhpDebugPreferencePage_9, "defaultPHPServer");
        this.fDefaultServer = this.addCombo(composite, 2);
        this.addLink(composite, PHPDebugUIMessages.PhpDebugPreferencePage_serversLink, SERVERS_PAGE_ID);
        this.addLabelControl(composite, PHPDebugUIMessages.PhpDebugPreferencePage_12, PHPDebugCorePreferenceNames.DEFAULT_PHP);
        this.fDefaultPHPExe = this.addCombo(composite, 2);
        this.addLink(composite, PHPDebugUIMessages.PhpDebugPreferencePage_installedPHPsLink, PHP_EXE_PAGE_ID);
        ScrolledPageContent scrolledPageContent = new ScrolledPageContent(composite);
        Composite composite2 = scrolledPageContent.getBody();
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        scrolledPageContent.setLayoutData((Object)gridData);
        this.expandbleDebugEncoding = this.createStyleSection(composite2, PHPDebugUIMessages.PHPDebugPreferencesAddon_debugTransferEncoding, 3);
        Composite composite3 = new Composite((Composite)this.expandbleDebugEncoding, 0);
        composite3.setFont(composite.getFont());
        composite3.setLayout((Layout)new GridLayout(3, false));
        this.expandbleDebugEncoding.setClient((Control)composite3);
        this.fDebugEncodingSettings = this.addEncodingSettings(composite3, PHPDebugUIMessages.PHPDebugPreferencesAddon_selectedEncoding);
        this.expandbleOutputEncoding = this.createStyleSection(composite2, PHPDebugUIMessages.PHPDebugPreferencesAddon_debugOutputEncoding, 3);
        composite3 = new Composite((Composite)this.expandbleOutputEncoding, 0);
        composite3.setFont(composite.getFont());
        composite3.setLayout((Layout)new GridLayout(3, false));
        this.expandbleOutputEncoding.setClient((Control)composite3);
        this.fOutputEncodingSettings = this.addEncodingSettings(composite3, PHPDebugUIMessages.PHPDebugPreferencesAddon_selectedEncoding);
        this.expandbleOutputEncoding.setText(String.valueOf(PHPDebugUIMessages.PHPDebugPreferencesAddon_debugOutputEncoding) + " (" + this.fOutputEncodingSettings.getIANATag() + ")");
        this.fStopAtFirstLine = this.addCheckBox(composite, PHPDebugUIMessages.PhpDebugPreferencePage_1, PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, 0);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                PHPDebugPreferencesAddon.this.expandbleDebugEncoding.setExpanded(true);
                ScrolledPageContent scrolledPageContent = (ScrolledPageContent)FormUtil.getScrolledComposite((Control)PHPDebugPreferencesAddon.this.expandbleDebugEncoding);
                Point point = scrolledPageContent.getSize();
                scrolledPageContent.setSize(point.x, 70);
                scrolledPageContent.getParent().layout();
            }
        });
        this.fDefaultDebugger.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = PHPDebugPreferencesAddon.this.getSelectedDebuggerId();
                PHPexeItem[] pHPexeItemArray = PHPexes.getInstance().getItems(string);
                PHPDebugPreferencesAddon.this.loadPHPExes(PHPDebugPreferencesAddon.this.fDefaultPHPExe, pHPexeItemArray);
            }
        });
    }

    private void loadPHPExes(Combo combo, PHPexeItem[] pHPexeItemArray) {
        combo.removeAll();
        if (pHPexeItemArray == null || pHPexeItemArray.length == 0) {
            combo.add(PHPDebugUIMessages.PhpDebugPreferencePage_noExeDefined);
            combo.select(0);
            return;
        }
        int n = 0;
        while (n < pHPexeItemArray.length) {
            combo.add(pHPexeItemArray[n].getName());
            ++n;
        }
        if (this.fDefaultDebugger.getItemCount() > 0) {
            String string;
            PHPexeItem pHPexeItem = PHPexes.getInstance().getDefaultItem(this.getSelectedDebuggerId());
            if (pHPexeItem != null) {
                string = pHPexeItem.getName();
            } else {
                string = PHPDebugUIMessages.PHPDebuggersTable_notDefined;
                if (combo.indexOf(string) == -1) {
                    combo.add(string, 0);
                    combo.select(0);
                }
            }
            int n2 = combo.indexOf(string);
            if (n2 > -1) {
                combo.select(n2);
            } else if (combo.getItemCount() > 0) {
                combo.select(0);
            }
        }
    }

    private void loadServers(Combo combo) {
        combo.removeAll();
        Server[] serverArray = ServersManager.getServers();
        if (serverArray != null) {
            int n = 0;
            while (n < serverArray.length) {
                combo.add(serverArray[n].getName());
                ++n;
            }
            if (combo.getItemCount() > 0) {
                combo.select(0);
            }
        }
    }

    private void loadDebuggers(Combo combo) {
        this.debuggersIds = PHPDebuggersRegistry.getDebuggersIds();
        String string = "org.eclipse.php.debug.core.zendDebugger";
        combo.removeAll();
        Iterator<String> iterator = this.debuggersIds.iterator();
        int n = 0;
        int n2 = 0;
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (string.equals(string2)) {
                n = n2;
            } else {
                ++n2;
            }
            String string3 = PHPDebuggersRegistry.getDebuggerName((String)string2);
            combo.add(string3);
        }
        if (combo.getItemCount() > 0) {
            combo.select(n);
        }
    }

    private ExpandableComposite createStyleSection(Composite composite, String string, int n) {
        ExpandableComposite expandableComposite = new ExpandableComposite(composite, 0, 18);
        expandableComposite.setText(string);
        expandableComposite.setExpanded(false);
        expandableComposite.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        expandableComposite.setLayoutData((Object)new GridData(4, 4, true, false, n, 1));
        expandableComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent expansionEvent) {
                PHPDebugPreferencesAddon.this.expandedStateChanged((ExpandableComposite)expansionEvent.getSource());
            }
        });
        return expandableComposite;
    }

    private void expandedStateChanged(ExpandableComposite expandableComposite) {
        if (expandableComposite.isExpanded()) {
            if (expandableComposite == this.expandbleDebugEncoding) {
                this.expandbleDebugEncoding.setText(PHPDebugUIMessages.PHPDebugPreferencesAddon_debugTransferEncoding);
                this.expandbleOutputEncoding.setText(String.valueOf(PHPDebugUIMessages.PHPDebugPreferencesAddon_debugOutputEncoding) + " (" + this.fOutputEncodingSettings.getIANATag() + ")");
                this.expandbleOutputEncoding.setExpanded(false);
            } else {
                this.expandbleOutputEncoding.setText(PHPDebugUIMessages.PHPDebugPreferencesAddon_debugOutputEncoding);
                this.expandbleDebugEncoding.setText(String.valueOf(PHPDebugUIMessages.PHPDebugPreferencesAddon_debugTransferEncoding) + " (" + this.fDebugEncodingSettings.getIANATag() + ")");
                this.expandbleDebugEncoding.setExpanded(false);
            }
        } else if (expandableComposite == this.expandbleDebugEncoding) {
            this.expandbleDebugEncoding.setText(String.valueOf(PHPDebugUIMessages.PHPDebugPreferencesAddon_debugTransferEncoding) + " (" + this.fDebugEncodingSettings.getIANATag() + ")");
            this.expandbleOutputEncoding.setText(PHPDebugUIMessages.PHPDebugPreferencesAddon_debugOutputEncoding);
            this.expandbleOutputEncoding.setExpanded(true);
        } else {
            this.expandbleOutputEncoding.setText(String.valueOf(PHPDebugUIMessages.PHPDebugPreferencesAddon_debugOutputEncoding) + " (" + this.fOutputEncodingSettings.getIANATag() + ")");
            this.expandbleDebugEncoding.setText(PHPDebugUIMessages.PHPDebugPreferencesAddon_debugTransferEncoding);
            this.expandbleDebugEncoding.setExpanded(true);
        }
        ScrolledPageContent scrolledPageContent = this.getParentScrolledComposite((Control)expandableComposite);
        if (scrolledPageContent != null) {
            scrolledPageContent.reflow(true);
        }
    }

    private ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite composite = control.getParent();
        while (!(composite instanceof ScrolledPageContent) && composite != null) {
            composite = composite.getParent();
        }
        if (composite instanceof ScrolledPageContent) {
            return (ScrolledPageContent)composite;
        }
        return null;
    }

    private void addLink(Composite composite, String string, final String string2) {
        Link link = new Link(composite, 0);
        link.setFont(composite.getFont());
        link.setLayoutData((Object)new GridData(0x1000008, 1, true, false));
        link.setText(string);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)PHPDebugPreferencesAddon.this.propertyPage.getShell(), (String)string2, null, null);
                preferenceDialog.setBlockOnOpen(true);
                preferenceDialog.addPageChangedListener(new IPageChangedListener(){

                    public void pageChanged(PageChangedEvent pageChangedEvent) {
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                String string = PHPDebugPreferencesAddon.this.fDefaultDebugger.getText();
                                String string2 = PHPDebugPreferencesAddon.this.fDefaultServer.getText();
                                String string3 = PHPDebugPreferencesAddon.this.fDefaultPHPExe.getText();
                                PHPDebugPreferencesAddon.this.loadDebuggers(PHPDebugPreferencesAddon.this.fDefaultDebugger);
                                PHPDebugPreferencesAddon.this.loadServers(PHPDebugPreferencesAddon.this.fDefaultServer);
                                PHPDebugPreferencesAddon.this.loadPHPExes(PHPDebugPreferencesAddon.this.fDefaultPHPExe, PHPexes.getInstance().getItems(PHPDebugPreferencesAddon.this.getSelectedDebuggerId()));
                                PHPDebugPreferencesAddon.this.selectComboItem(PHPDebugPreferencesAddon.this.fDefaultDebugger, PHPDebugPreferencesAddon.this.fDefaultDebugger.indexOf(string));
                                PHPDebugPreferencesAddon.this.selectComboItem(PHPDebugPreferencesAddon.this.fDefaultServer, PHPDebugPreferencesAddon.this.fDefaultServer.indexOf(string2));
                                PHPDebugPreferencesAddon.this.selectComboItem(PHPDebugPreferencesAddon.this.fDefaultPHPExe, PHPDebugPreferencesAddon.this.fDefaultPHPExe.indexOf(string3));
                            }
                        });
                    }
                });
                preferenceDialog.open();
            }
        });
    }

    private void selectComboItem(Combo combo, int n) {
        if (n < 0) {
            if (combo.getItemCount() > 0) {
                combo.select(0);
            }
        } else {
            combo.select(n);
        }
    }

    private EncodingSettings addEncodingSettings(Composite composite, String string) {
        EncodingSettings encodingSettings = new EncodingSettings(composite, string);
        GridData gridData = (GridData)encodingSettings.getLayoutData();
        gridData.horizontalSpan = 3;
        gridData.verticalAlignment = 0;
        gridData.verticalIndent = -5;
        gridData.horizontalIndent = -5;
        encodingSettings.setLayoutData((Object)gridData);
        return encodingSettings;
    }

    private Combo addCombo(Composite composite, int n) {
        Combo combo = new Combo(composite, 2060);
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = n;
        combo.setLayoutData((Object)gridData);
        return combo;
    }

    private void savePreferences(boolean bl) {
        Preferences preferences;
        String string = this.fDefaultPHPExe.getText();
        PHPexes pHPexes = PHPexes.getInstance();
        if (pHPexes.getItem(this.getSelectedDebuggerId(), string) == null) {
            preferences = pHPexes.getDefaultItem(this.getSelectedDebuggerId());
            string = preferences != null ? preferences.getName() : "";
        }
        preferences = PHPProjectPreferences.getModelPreferences();
        IScopeContext[] iScopeContextArray = this.createPreferenceScopes(this.propertyPage);
        IEclipsePreferences iEclipsePreferences = iScopeContextArray[0].getNode(this.getPreferenceNodeQualifier());
        IProject iProject = this.getProject(this.propertyPage);
        if (bl && iEclipsePreferences != null && iScopeContextArray[0] instanceof ProjectScope && iProject != null) {
            iEclipsePreferences.putBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, this.fStopAtFirstLine.getSelection());
            iEclipsePreferences.put(PHPDebugCorePreferenceNames.DEFAULT_PHP, string);
            iEclipsePreferences.put(PHPDebugCorePreferenceNames.TRANSFER_ENCODING, this.fDebugEncodingSettings.getIANATag());
            iEclipsePreferences.put(PHPDebugCorePreferenceNames.OUTPUT_ENCODING, this.fOutputEncodingSettings.getIANATag());
            iEclipsePreferences.put(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, this.getSelectedDebuggerId());
            ServersManager.setDefaultServer((IProject)iProject, (String)this.fDefaultServer.getText());
        } else if (iProject == null) {
            preferences.setValue(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, this.fStopAtFirstLine.getSelection());
            preferences.setValue(PHPDebugCorePreferenceNames.TRANSFER_ENCODING, this.fDebugEncodingSettings.getIANATag());
            preferences.setValue(PHPDebugCorePreferenceNames.OUTPUT_ENCODING, this.fOutputEncodingSettings.getIANATag());
            preferences.setValue(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, this.getSelectedDebuggerId());
            pHPexes.setDefaultItem(this.getSelectedDebuggerId(), string);
            ServersManager.setDefaultServer(null, (String)this.fDefaultServer.getText());
        } else if (iEclipsePreferences != null) {
            iEclipsePreferences.remove(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE);
            iEclipsePreferences.remove(PHPDebugCorePreferenceNames.DEFAULT_PHP);
            ServersManager.setDefaultServer((IProject)iProject, null);
            iEclipsePreferences.remove(PHPDebugCorePreferenceNames.TRANSFER_ENCODING);
            iEclipsePreferences.remove(PHPDebugCorePreferenceNames.OUTPUT_ENCODING);
            iEclipsePreferences.remove(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID);
        }
        try {
            iEclipsePreferences.flush();
            pHPexes.save();
            PHPDebugPlugin.getDefault().savePluginPreferences();
        }
        catch (BackingStoreException backingStoreException) {
            Logger.logException(backingStoreException);
        }
    }

    private String getSelectedDebuggerId() {
        int n = this.fDefaultDebugger.getSelectionIndex();
        String string = "org.eclipse.php.debug.core.zendDebugger";
        if (n > -1 && this.debuggersIds.size() > n) {
            string = this.debuggersIds.toArray()[n].toString();
        }
        return string;
    }
}

