/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.watch;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpVariable;
import org.eclipse.php.internal.debug.ui.Logger;
import org.w3c.dom.Node;

public class XDebugWatchExpressionDelegate
implements IWatchExpressionDelegate {
    private String expressionText;
    private IWatchExpressionListener watchListener;
    private DBGpTarget debugTarget;
    private Job evalJob;

    public void evaluateExpression(String string, IDebugElement iDebugElement, IWatchExpressionListener iWatchExpressionListener) {
        this.expressionText = string;
        this.watchListener = iWatchExpressionListener;
        IDebugTarget iDebugTarget = iDebugElement.getDebugTarget();
        if (iDebugTarget instanceof DBGpTarget) {
            this.debugTarget = (DBGpTarget)iDebugTarget;
            if (!this.debugTarget.isSuspended()) {
                this.watchListener.watchEvaluationFinished(null);
            } else {
                this.evalJob = new EvaluationRunnable();
                this.evalJob.schedule();
            }
        }
    }

    private final class EvaluationRunnable
    extends Job {
        public EvaluationRunnable() {
            super("XDEbugEvaluationRunnable");
            this.setSystem(true);
        }

        public IStatus run(IProgressMonitor iProgressMonitor) {
            try {
                XDebugWatchExpressionResult xDebugWatchExpressionResult = new XDebugWatchExpressionResult();
                xDebugWatchExpressionResult.evaluate();
                XDebugWatchExpressionDelegate.this.watchListener.watchEvaluationFinished((IWatchExpressionResult)xDebugWatchExpressionResult);
            }
            catch (Exception exception) {
                Logger.logException(exception);
                XDebugWatchExpressionDelegate.this.watchListener.watchEvaluationFinished(null);
            }
            return Status.OK_STATUS;
        }
    }

    private class XDebugWatchExpressionResult
    implements IWatchExpressionResult {
        private boolean hasErrors = false;
        private IValue evalResult;

        private XDebugWatchExpressionResult() {
        }

        public IValue getValue() {
            return this.evalResult;
        }

        public void evaluate() {
            String string = "0";
            String string2 = XDebugWatchExpressionDelegate.this.expressionText.trim();
            Node node = null;
            node = XDebugWatchExpressionDelegate.this.debugTarget.eval(string2);
            DBGpVariable dBGpVariable = new DBGpVariable(XDebugWatchExpressionDelegate.this.debugTarget, node, string);
            this.evalResult = null;
            try {
                this.evalResult = dBGpVariable.getValue();
                if (this.evalResult == null) {
                    this.hasErrors = true;
                }
            }
            catch (Exception exception) {
                this.hasErrors = true;
            }
        }

        public boolean hasErrors() {
            return this.hasErrors;
        }

        public String[] getErrorMessages() {
            if (this.hasErrors) {
                return new String[]{"Failed to evaluation Expression"};
            }
            return null;
        }

        public String getExpressionText() {
            return XDebugWatchExpressionDelegate.this.expressionText;
        }

        public DebugException getException() {
            return null;
        }
    }
}

