/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.project.options;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.internal.resources.XMLWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.php.internal.core.IncludePathContainerInitializer;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.project.IIncludePathContainer;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.core.project.PHPNature;
import org.eclipse.php.internal.core.project.options.IPhpProjectOptionChangeListener;
import org.eclipse.php.internal.core.project.options.includepath.IncludePathEntry;
import org.eclipse.php.internal.core.project.options.includepath.IncludePathVariableManager;
import org.osgi.service.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class PHPProjectOptions {
    private static final String LOCATION_INCLUDE_PATH = "Include Path";
    private static final String OWNER_PHP_INCLUDE_PATH = "phpIncludePath";
    private static final String OWNER_ATTRIBUTE = "Owner";
    public static final String BUILDER_ID = "org.eclipse.php.core.PhpIncrementalProjectBuilder";
    static final IIncludePathEntry[] EMPTY_INCLUDEPATH = new IIncludePathEntry[0];
    private static final String PREF_QUALIFIER = "org.eclipse.php.core.projectOptions";
    private static final String OLD_FILE_NAME = ".projectOptions";
    private static final String TAG_OPTION = "projectOption";
    private static final String TAG_OPTIONS = "phpProjectOptions";
    public static final String USER_LIBRARY_CONTAINER_ID = "org.eclipse.php.USER_LIBRARY";
    private IIncludePathEntry[] includePathEntries = new IIncludePathEntry[0];
    private final Map<String, List<IPhpProjectOptionChangeListener>> optionsChangeListenersMap = new HashMap<String, List<IPhpProjectOptionChangeListener>>();
    private IProject project;
    private IEclipsePreferences preferences;

    public static PHPProjectOptions forProject(IProject iProject) {
        if (!iProject.exists() || !iProject.isAccessible()) {
            return null;
        }
        PHPNature pHPNature = null;
        try {
            pHPNature = (PHPNature)iProject.getNature("org.eclipse.php.core.PHPNature");
        }
        catch (CoreException coreException) {
            PHPCorePlugin.log(coreException);
        }
        if (pHPNature != null) {
            return pHPNature.getOptions();
        }
        return null;
    }

    public static IIncludePathContainer getIncludePathContainer(IPath iPath, IProject iProject) {
        return null;
    }

    public static IncludePathContainerInitializer getIncludePathContainerInitializer(String string) {
        return null;
    }

    public static IPath getIncludePathVariable(String string) {
        return IncludePathVariableManager.instance().getIncludePathVariable(string);
    }

    public static String[] getIncludePathVariableNames() {
        return IncludePathVariableManager.instance().getIncludePathVariableNames();
    }

    public static IPath getResolvedVariablePath(IPath iPath) {
        return IncludePathVariableManager.instance().getIncludePathVariable(iPath.toString());
    }

    public static void setIncludePathVariables(String[] stringArray, IPath[] iPathArray, SubProgressMonitor subProgressMonitor) {
        IncludePathVariableManager.instance().setIncludePathVariables(stringArray, iPathArray, subProgressMonitor);
    }

    public PHPProjectOptions(IProject iProject) {
        this.project = iProject;
        ProjectScope projectScope = new ProjectScope(iProject);
        this.preferences = projectScope.getNode(PREF_QUALIFIER);
        this.loadIncludePath();
        this.loadOldConfiguration();
    }

    public void addOptionChangeListener(String string, IPhpProjectOptionChangeListener iPhpProjectOptionChangeListener) {
        List<IPhpProjectOptionChangeListener> list = this.optionsChangeListenersMap.get(string);
        if (list == null) {
            list = new ArrayList<IPhpProjectOptionChangeListener>();
            this.optionsChangeListenersMap.put(string, list);
        }
        list.add(iPhpProjectOptionChangeListener);
    }

    public void removeOptionChangeListener(String string, IPhpProjectOptionChangeListener iPhpProjectOptionChangeListener) {
        List<IPhpProjectOptionChangeListener> list = this.optionsChangeListenersMap.get(string);
        if (list != null) {
            list.remove(iPhpProjectOptionChangeListener);
        }
    }

    public void notifyOptionChangeListeners(String string, Object object, Object object2) {
        List<IPhpProjectOptionChangeListener> list = this.optionsChangeListenersMap.get(string);
        if (list == null) {
            return;
        }
        for (IPhpProjectOptionChangeListener iPhpProjectOptionChangeListener : list) {
            iPhpProjectOptionChangeListener.notifyOptionChanged(object, object2);
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public Object getOption(String string) {
        return this.preferences.get(string, null);
    }

    public void setOption(String string, Object object) {
        Object object2 = this.getOption(string);
        if (object2 != null ? object != null && object.equals(object2) : object == null) {
            return;
        }
        this.preferences.put(string, object.toString());
        this.flushPrefs();
        this.notifyOptionChangeListeners(string, object2, object);
    }

    public Object removeOption(String string) {
        Object object = this.getOption(string);
        if (object != null) {
            this.preferences.remove(string);
            this.flushPrefs();
        }
        return object;
    }

    private void flushPrefs() {
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            Logger.logException(backingStoreException);
        }
    }

    public Object removeOptionNotify(String string) {
        Object object = this.removeOption(string);
        this.notifyOptionChangeListeners(string, object, null);
        return object;
    }

    public void modifyIncludePathEntry(IIncludePathEntry iIncludePathEntry, IProject iProject, IPath iPath, IProgressMonitor iProgressMonitor) {
        throw new RuntimeException("implement me");
    }

    public IIncludePathEntry[] readRawIncludePath() {
        return this.includePathEntries;
    }

    public void removeResourceFromIncludePath(IResource iResource) {
        if (this.includePathEntries.length == 0) {
            return;
        }
        ArrayList<IIncludePathEntry> arrayList = new ArrayList<IIncludePathEntry>(this.includePathEntries.length);
        int n = 0;
        while (n < this.includePathEntries.length) {
            if (this.includePathEntries[n].getResource() != iResource) {
                arrayList.add(this.includePathEntries[n]);
            }
            ++n;
        }
        try {
            this.setRawIncludePath(arrayList.toArray(new IIncludePathEntry[arrayList.size()]), null);
            return;
        }
        catch (Exception exception) {
            PHPCorePlugin.log(exception);
            return;
        }
    }

    public void renameResourceAtIncludePath(IResource iResource, IResource iResource2) {
        if (this.includePathEntries.length == 0) {
            return;
        }
        ArrayList<IIncludePathEntry> arrayList = new ArrayList<IIncludePathEntry>(this.includePathEntries.length);
        int n = 0;
        while (n < this.includePathEntries.length) {
            if (this.includePathEntries[n].getResource() == iResource) {
                IIncludePathEntry iIncludePathEntry = IncludePathEntry.newProjectEntry(iResource2.getFullPath(), iResource2, false);
                arrayList.add(iIncludePathEntry);
            } else {
                arrayList.add(this.includePathEntries[n]);
            }
            ++n;
        }
        try {
            this.setRawIncludePath(arrayList.toArray(new IIncludePathEntry[arrayList.size()]), null);
        }
        catch (Exception exception) {
            PHPCorePlugin.log(exception);
        }
    }

    public void setRawIncludePath(IIncludePathEntry[] iIncludePathEntryArray, SubProgressMonitor subProgressMonitor) {
        IIncludePathEntry[] iIncludePathEntryArray2 = this.includePathEntries;
        this.includePathEntries = iIncludePathEntryArray;
        IncludePathEntry.updateProjectReferences(this.includePathEntries, iIncludePathEntryArray2, this.project, subProgressMonitor);
        this.saveIncludePath();
        this.notifyOptionChangeListeners("org.eclipse.php.core.includePath", iIncludePathEntryArray2, iIncludePathEntryArray);
    }

    private void saveIncludePath() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XMLWriter xMLWriter = new XMLWriter((OutputStream)byteArrayOutputStream);
            xMLWriter.startTag("includepath", null);
            int n = 0;
            while (n < this.includePathEntries.length) {
                ((IncludePathEntry)this.includePathEntries[n]).elementEncode(xMLWriter, this.project.getFullPath(), true);
                ++n;
            }
            xMLWriter.endTag("includepath");
            xMLWriter.flush();
            xMLWriter.close();
            this.preferences.put("org.eclipse.php.core.includePath", new String(byteArrayOutputStream.toByteArray()));
            this.flushPrefs();
            this.validateIncludePath();
        }
        catch (IOException iOException) {
            PHPCorePlugin.log(iOException);
        }
    }

    private void loadIncludePath() {
        try {
            Element element;
            Object object;
            String string = this.preferences.get("org.eclipse.php.core.includePath", null);
            if (string == null) {
                return;
            }
            StringReader stringReader = new StringReader(string);
            try {
                try {
                    object = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    element = ((DocumentBuilder)object).parse(new InputSource(stringReader)).getDocumentElement();
                }
                catch (Exception exception) {
                    throw new IOException("Bad project options file format");
                }
            }
            finally {
                ((Reader)stringReader).close();
            }
            object = new ArrayList();
            NodeList nodeList = element.getElementsByTagName("includepathentry");
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (node.getNodeType() == 1) {
                    IIncludePathEntry iIncludePathEntry = IncludePathEntry.elementDecode((Element)node, this);
                    object.add(iIncludePathEntry);
                }
                ++n;
            }
            n = object.size();
            this.includePathEntries = new IIncludePathEntry[n];
            object.toArray(this.includePathEntries);
        }
        catch (IOException iOException) {
            PHPCorePlugin.log(iOException);
        }
    }

    private void loadOldConfiguration() {
        IFile iFile = this.project.getFile(OLD_FILE_NAME);
        if (!iFile.exists()) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.includePathEntries = EMPTY_INCLUDEPATH;
        try {
            Object object;
            Object object2;
            Element element;
            Object object3;
            InputStreamReader inputStreamReader = new InputStreamReader(iFile.getContents());
            try {
                try {
                    object3 = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    element = ((DocumentBuilder)object3).parse(new InputSource(inputStreamReader)).getDocumentElement();
                }
                catch (Exception exception) {
                    throw new IOException("Bad project options file format");
                }
            }
            finally {
                ((Reader)inputStreamReader).close();
            }
            if (!element.getNodeName().equalsIgnoreCase(TAG_OPTIONS)) {
                throw new IOException("Bad project options file format");
            }
            object3 = element.getElementsByTagName(TAG_OPTION);
            int n = object3.getLength();
            int n2 = 0;
            while (n2 < n) {
                Element element2 = (Element)object3.item(n2);
                object2 = element2.getAttribute("name");
                object = element2.getFirstChild().getNodeValue().trim();
                this.preferences.put((String)object2, (String)object);
                ++n2;
            }
            object3 = element.getElementsByTagName("includepath");
            if (object3.getLength() > 0) {
                Element element3 = (Element)object3.item(0);
                object3 = element3.getElementsByTagName("includepathentry");
                n = object3.getLength();
                int n3 = 0;
                while (n3 < n) {
                    object2 = object3.item(n3);
                    if (object2.getNodeType() == 1) {
                        object = IncludePathEntry.elementDecode((Element)object2, this);
                        arrayList.add(object);
                    }
                    ++n3;
                }
                n3 = arrayList.size();
                this.includePathEntries = new IIncludePathEntry[n3];
                arrayList.toArray(this.includePathEntries);
            }
            this.saveIncludePath();
            iFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException iOException) {
            PHPCorePlugin.log(iOException);
        }
        catch (CoreException coreException) {
            PHPCorePlugin.log(coreException);
        }
    }

    public void validateIncludePath() {
        this.clearMarkers();
        int n = 0;
        while (n < this.includePathEntries.length) {
            String string = this.includePathEntries[n].validate();
            if (string != null) {
                this.addError(string);
            }
            ++n;
        }
    }

    private void addError(String string) {
        try {
            IMarker iMarker = this.project.createMarker("org.eclipse.core.resources.problemmarker");
            iMarker.setAttribute("location", (Object)LOCATION_INCLUDE_PATH);
            iMarker.setAttribute("message", (Object)string);
            iMarker.setAttribute("priority", 2);
            iMarker.setAttribute("severity", 1);
            iMarker.setAttribute(OWNER_ATTRIBUTE, (Object)OWNER_PHP_INCLUDE_PATH);
        }
        catch (CoreException coreException) {}
    }

    private void clearMarkers() {
        try {
            IMarker[] iMarkerArray = this.project.findMarkers("org.eclipse.core.resources.problemmarker", false, 2);
            int n = 0;
            while (n < iMarkerArray.length) {
                if (OWNER_PHP_INCLUDE_PATH.equals(iMarkerArray[n].getAttribute(OWNER_ATTRIBUTE))) {
                    iMarkerArray[n].delete();
                }
                ++n;
            }
        }
        catch (CoreException coreException) {}
    }
}

