/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Method;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.util.WeakObject;

public class WeakPropertyChangeListener
extends WeakObject
implements IPropertyChangeListener {
    private Object target;
    private static ReferenceQueue q = new ReferenceQueue();
    private static Class[] parameterTypes = new Class[]{IPropertyChangeListener.class};
    private static Object[] parameterValues = new Object[1];
    private static String removeListenerMethodName = "removePropertyChangeListener";

    public static WeakPropertyChangeListener create(IPropertyChangeListener iPropertyChangeListener, Object object) {
        WeakPropertyChangeListener.removeRedundantReferences();
        return new WeakPropertyChangeListener(iPropertyChangeListener, object);
    }

    public static void removeRedundantReferences() {
        WeakPropertyChangeListener weakPropertyChangeListener = (WeakPropertyChangeListener)q.poll();
        while (weakPropertyChangeListener != null) {
            WeakPropertyChangeListener.removeRedundantReference(weakPropertyChangeListener);
            weakPropertyChangeListener = (WeakPropertyChangeListener)q.poll();
        }
    }

    private static void removeRedundantReference(WeakPropertyChangeListener weakPropertyChangeListener) {
        try {
            Method method = weakPropertyChangeListener.target.getClass().getMethod(removeListenerMethodName, parameterTypes);
            WeakPropertyChangeListener.parameterValues[0] = weakPropertyChangeListener;
            method.invoke(weakPropertyChangeListener.target, parameterValues);
        }
        catch (Exception exception) {
            PHPCorePlugin.log(exception);
        }
    }

    protected WeakPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener, Object object) {
        super(iPropertyChangeListener, q);
        this.target = object;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        IPropertyChangeListener iPropertyChangeListener = (IPropertyChangeListener)this.get();
        if (iPropertyChangeListener != null) {
            iPropertyChangeListener.propertyChange(propertyChangeEvent);
        } else {
            WeakPropertyChangeListener.removeRedundantReference(this);
        }
    }
}

