/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.extensionpoints.IFileMapper;

public class AutoPathMapper
implements IFileMapper {
    private boolean workspaceRemap = false;
    private String externalLocPreAppend = "";
    private String launchProject = "";
    private boolean mappingRequired = false;

    public void init(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(string2));
        if (iFile == null) {
            this.mappingRequired = true;
            string = string.replace("\\", "/").trim();
            if ((string2 = string2.replace("\\", "/").trim()).endsWith(string)) {
                this.workspaceRemap = true;
                int n = string2.indexOf(string);
                this.externalLocPreAppend = string2.substring(0, n);
            } else {
                int n = string.startsWith("/") ? string.indexOf(47, 1) : string.indexOf(47);
                String string3 = string.substring(n);
                if (string2.endsWith(string3)) {
                    this.workspaceRemap = false;
                    this.launchProject = string.substring(0, n);
                    int n2 = string2.indexOf(string3);
                    this.externalLocPreAppend = string2.substring(0, n2);
                }
            }
        }
    }

    public String mapWorkspaceFileToExternal(IFile iFile, ILaunchConfiguration iLaunchConfiguration) {
        String string = null;
        if (iFile != null) {
            string = iFile.getRawLocation().toString();
            String string2 = iFile.getProjectRelativePath().toString();
            String string3 = iFile.getProject().getName();
            if (this.externalLocPreAppend != null) {
                StringBuffer stringBuffer = new StringBuffer(this.externalLocPreAppend);
                stringBuffer.append('/');
                if (this.workspaceRemap) {
                    stringBuffer.append(string3);
                    stringBuffer.append('/');
                }
                stringBuffer.append(string2);
                string = stringBuffer.toString();
            }
        }
        return string;
    }

    public String mapExternalFileToWorkspace(String string, ILaunchConfiguration iLaunchConfiguration) {
        String string2 = string;
        if (this.externalLocPreAppend != null && this.startsWith(string = string.replace('\\', '/'), this.externalLocPreAppend)) {
            String string3 = string.substring(this.externalLocPreAppend.length());
            IFile iFile = null;
            if (!this.workspaceRemap) {
                string3 = String.valueOf(this.launchProject) + string3;
            }
            if ((iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(string3))) != null) {
                string2 = iFile.getRawLocation().toString();
            }
        }
        return string2;
    }

    private boolean startsWith(String string, String string2) {
        String string3 = Platform.getOS();
        if (string3.equals("win32") || string3.equals("macosx")) {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
        }
        return string.startsWith(string2);
    }

    public boolean isMappingRequired() {
        return this.mappingRequired;
    }
}

