/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpResponse;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.browser.WebBrowserView;

public class DBGpUtils {
    private static Map encoded = Collections.synchronizedMap(new HashMap());

    public static String getFileURIString(String string) {
        if (encoded.containsKey(string)) {
            return (String)encoded.get(string);
        }
        String string2 = "";
        if (string == null || string.length() == 0) {
            return string2;
        }
        if (string.charAt(0) != '/') {
            string = "/" + string;
        }
        try {
            URI uRI = new URI("file", "", string, null, null);
            string2 = uRI.toASCIIString();
            encoded.put(string, string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            DBGpLogger.logException("URISyntaxException - 1", null, uRISyntaxException);
        }
        return string2;
    }

    public static String getFilenameFromURIString(String string) {
        String string2 = "";
        try {
            URI uRI = new URI(string);
            string2 = uRI.getPath();
            if (string2 != null && string2.length() > 2 && string2.charAt(2) == ':') {
                string2 = string2.substring(1);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            DBGpLogger.logException("URISyntaxException - 2", null, uRISyntaxException);
        }
        return string2;
    }

    public static boolean isGoodDBGpResponse(Object object, DBGpResponse dBGpResponse) {
        if (dBGpResponse.getType() == 2) {
            if (dBGpResponse.getErrorCode() == 0 || dBGpResponse.getErrorCode() == 300) {
                return true;
            }
            DBGpLogger.logError("DBGp Response Error: " + dBGpResponse.getCommand() + ":=" + dBGpResponse.getErrorCode() + " msg:" + dBGpResponse.getErrorMessage(), object, null);
        } else {
            DBGpLogger.logError("Unexpected XML or parser failure: " + dBGpResponse.getRawXML(), object, null);
        }
        return false;
    }

    public static void openInternalBrowserView(final String string) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                try {
                    IViewPart iViewPart = iWorkbenchWindow.getActivePage().showView("org.eclipse.ui.browser.view");
                    if (iViewPart instanceof WebBrowserView) {
                        ((WebBrowserView)iViewPart).setURL(string);
                    }
                }
                catch (PartInitException partInitException) {
                    throw new RuntimeException(partInitException);
                }
            }
        });
    }
}

