/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.model;

import java.util.StringTokenizer;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.model.PHPDebugElement;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpression;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpressionsManager;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionValue;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.PHPVariable;

public class PHPValue
extends PHPDebugElement
implements IValue {
    private ExpressionValue fValue;
    private boolean fHasChildren = false;
    private IVariable[] fChildren = new IVariable[0];
    private Expression fVariable;
    private boolean fGlobal;
    private String[] types = new String[]{"NULL", "INT", "STRING", "BOOLEAN", "DOUBLE", "ARRAY", "OBJECT", "RESOURCE"};

    public PHPValue(PHPDebugTarget pHPDebugTarget, Expression expression) {
        super(pHPDebugTarget);
        this.fValue = expression.getValue();
        this.fVariable = expression;
        this.fGlobal = false;
        this.processChildren(this.fValue);
    }

    public PHPValue(PHPDebugTarget pHPDebugTarget, Expression expression, boolean bl) {
        super(pHPDebugTarget);
        this.fValue = expression.getValue();
        this.fVariable = expression;
        this.fGlobal = bl;
        this.processChildren(this.fValue);
    }

    public String getReferenceTypeName() throws DebugException {
        return this.types[this.fValue.getType()];
    }

    public String getValueString() throws DebugException {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(this.fValue.getValueAsString(), "\\", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.length() > 1) {
                stringBuffer.append(string);
                continue;
            }
            stringBuffer.append(string);
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringTokenizer.nextToken();
        }
        String string = stringBuffer.toString();
        return string;
    }

    public String getValue() throws DebugException {
        return (String)this.fValue.getValue();
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        if (this.fChildren.length == 0) {
            PHPDebugTarget pHPDebugTarget = (PHPDebugTarget)this.getDebugTarget();
            DefaultExpressionsManager defaultExpressionsManager = pHPDebugTarget.getExpressionManager();
            Expression expression = this.fVariable;
            if (this.fGlobal) {
                String string = "$GLOBALS[\"" + this.fVariable.getFullName().substring(1) + "\"]";
                expression = new DefaultExpression(string);
            }
            defaultExpressionsManager.update(expression, 1);
            this.fValue = expression.getValue();
            this.processChildren(this.fValue);
        }
        return this.fChildren;
    }

    public boolean hasVariables() throws DebugException {
        return this.fHasChildren;
    }

    public void updateValue(ExpressionValue expressionValue) {
        this.fValue = expressionValue;
        this.processChildren(this.fValue);
    }

    public boolean isPrimative() {
        return this.fValue.isPrimitive();
    }

    private void processChildren(ExpressionValue expressionValue) {
        Expression[] expressionArray = expressionValue.getChildren();
        if (expressionArray == null) {
            return;
        }
        if (expressionArray.length == 0) {
            this.fHasChildren = true;
            this.fChildren = new IVariable[0];
            return;
        }
        this.fHasChildren = true;
        this.fChildren = new PHPVariable[expressionArray.length];
        int n = 0;
        while (n < expressionArray.length) {
            this.fChildren[n] = new PHPVariable((PHPDebugTarget)this.getDebugTarget(), expressionArray[n], this.fGlobal);
            ++n;
        }
    }

    public boolean equals(Object object) {
        return this.equals(object, 5);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean equals(Object object, int n) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PHPValue)) {
            return false;
        }
        PHPValue pHPValue = (PHPValue)((Object)object);
        boolean bl = pHPValue.fValue.getValue() == null;
        if (!this.fVariable.getFullName().equals(pHPValue.fVariable.getFullName())) return false;
        if (!bl) {
            if (!this.fValue.getValueAsString().equals(pHPValue.fValue.getValueAsString())) return false;
        }
        if (!this.fHasChildren) {
            if (!pHPValue.fHasChildren) return true;
            return false;
        }
        if (this.fChildren.length == 0) {
            try {
                this.getVariables();
            }
            catch (DebugException debugException) {}
        }
        if (pHPValue.fChildren.length == 0) {
            try {
                pHPValue.getVariables();
            }
            catch (DebugException debugException) {}
        }
        if (this.fChildren.length != pHPValue.fChildren.length) {
            return false;
        }
        if (n <= 0) {
            return true;
        }
        try {
            int n2 = 0;
            while (true) {
                if (n2 >= this.fChildren.length) {
                    return true;
                }
                IVariable iVariable = this.fChildren[n2];
                IVariable iVariable2 = pHPValue.fChildren[n2];
                if (!((PHPValue)iVariable.getValue()).equals(iVariable2.getValue(), --n)) {
                    return false;
                }
                ++n2;
            }
        }
        catch (DebugException debugException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public int hashCode() {
        return super.hashCode();
    }
}

