/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.launching;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.php.internal.debug.core.launching.PHPHyperLink;
import org.eclipse.php.internal.debug.core.launching.PHPStreamsProxy;

public class PHPProcess
extends PlatformObject
implements IProcess {
    private ILaunch fLaunch;
    private String fName;
    private Map fAttributes;
    private boolean fTerminated;
    private IConsole fConsole = null;
    private PHPStreamsProxy fProxy;
    private PHPHyperLink fPHPHyperLink;
    private IDebugTarget fDebugTarget;

    public PHPProcess(ILaunch iLaunch, String string) {
        this.fLaunch = iLaunch;
        this.fName = string;
        this.fTerminated = false;
        iLaunch.addProcess((IProcess)this);
        this.fProxy = new PHPStreamsProxy();
    }

    public String getLabel() {
        return this.fName;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    protected void setLaunch(ILaunch iLaunch) {
        this.fLaunch = iLaunch;
    }

    public IStreamsProxy getStreamsProxy() {
        return this.fProxy;
    }

    public void setAttribute(String string, String string2) {
        Object v;
        if (this.fAttributes == null) {
            this.fAttributes = new HashMap(5);
        }
        if ((v = this.fAttributes.get(string)) != null && v.equals(string2)) {
            return;
        }
        this.fAttributes.put(string, string2);
    }

    public String getAttribute(String string) {
        if (this.fAttributes == null) {
            return null;
        }
        return (String)this.fAttributes.get(string);
    }

    public int getExitValue() throws DebugException {
        return 0;
    }

    public Object getAdapter(Class clazz) {
        if (clazz.equals(IProcess.class)) {
            return this;
        }
        if (clazz.equals(IDebugTarget.class)) {
            ILaunch iLaunch = this.getLaunch();
            IDebugTarget[] iDebugTargetArray = iLaunch.getDebugTargets();
            int n = 0;
            while (n < iDebugTargetArray.length) {
                if (((Object)((Object)this)).equals(iDebugTargetArray[n].getProcess())) {
                    return iDebugTargetArray[n];
                }
                ++n;
            }
            return null;
        }
        if (clazz.equals(ITerminate.class)) {
            return this;
        }
        return super.getAdapter(clazz);
    }

    public boolean canTerminate() {
        return !this.fTerminated;
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    public void terminate() throws DebugException {
        this.fTerminated = true;
    }

    public void setPHPHyperLink(PHPHyperLink pHPHyperLink) {
        this.fPHPHyperLink = pHPHyperLink;
    }

    public PHPHyperLink getPHPHyperLink() {
        return this.fPHPHyperLink;
    }

    public IConsole getConsole() {
        return this.fConsole;
    }

    public void setConsole(IConsole iConsole) {
        this.fConsole = iConsole;
    }

    public IDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    public void setDebugTarget(IDebugTarget iDebugTarget) {
        this.fDebugTarget = iDebugTarget;
    }
}

