/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPExecutableDebuggerInitializer {
    private ILaunch launch;

    public PHPExecutableDebuggerInitializer(ILaunch iLaunch) throws IOException {
        this.launch = iLaunch;
    }

    public void initializeDebug(String string, String string2, String string3) {
        this.initializeDebug(string, string2, string3, null, null);
    }

    public void initializeDebug(String string, String string2, String string3, Map<String, String> map, String string4) {
        try {
            String[] stringArray;
            Path path = new Path(string);
            File file = new File(path.removeLastSegments(1).toString());
            String string5 = file.getAbsolutePath();
            if (string4 != null && !string4.equals("")) {
                string5 = string4;
            }
            String string6 = string5;
            string5 = new File(string5).getParentFile().getAbsolutePath();
            if (map == null) {
                map = this.getAdditionalLaunchEnvironment(string2, string3, string5, file.getAbsolutePath());
            } else {
                stringArray = this.getAdditionalLaunchEnvironment(string2, string3, string5, file.getAbsolutePath());
                stringArray.putAll(map);
                map = stringArray;
            }
            stringArray = PHPLaunchUtilities.getEnvironment(this.launch.getLaunchConfiguration(), this.asAttributesArray(map));
            String[] stringArray2 = PHPLaunchUtilities.getCommandLine(this.launch.getLaunchConfiguration(), string, string6, string2, string4);
            if (stringArray2.length == 4) {
                stringArray2[0] = PHPexes.changeToCGI(stringArray2[0]);
            }
            PHPexes.changePermissions(new File(stringArray2[0]));
            Process process = Runtime.getRuntime().exec(stringArray2, stringArray, file);
            ProcessOutputReader processOutputReader = new ProcessOutputReader(process);
            new Thread(processOutputReader).start();
        }
        catch (Exception exception) {
            final Display display = Display.getDefault();
            display.asyncExec(new Runnable(){

                public void run() {
                    String string = exception.getLocalizedMessage();
                    if (string != null) {
                        string = string.replaceFirst(String.valueOf(exception.getClass().getName()) + ": ", "");
                        MessageDialog.openError((Shell)display.getActiveShell(), (String)"Error", (String)NLS.bind((String)"Error running PHP executable:\n\n{0}", (Object)string));
                    }
                }
            });
            DebugPlugin.log((Throwable)exception);
        }
    }

    private String[] asAttributesArray(Map<String, String> map) {
        String[] stringArray = new String[map.size()];
        int n = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringArray[n++] = String.valueOf(entry.getKey()) + '=' + entry.getValue();
        }
        return stringArray;
    }

    protected Map<String, String> getAdditionalLaunchEnvironment(String string, String string2, String string3, String string4) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("REQUEST_METHOD", "GET");
        hashMap.put("SCRIPT_FILENAME", string);
        hashMap.put("SCRIPT_NAME", string);
        hashMap.put("PATH_TRANSLATED", string);
        hashMap.put("PATH_INFO", string);
        hashMap.put("QUERY_STRING", String.valueOf(string2) + "&debug_host=127.0.0.1");
        hashMap.put("REDIRECT_STATUS", "1");
        hashMap.put("PHPRC", string3);
        String string5 = System.getProperty("os.name");
        if (!string5.startsWith("Win")) {
            if (string5.startsWith("Mac")) {
                hashMap.put("DYLD_LIBRARY_PATH", string4);
            } else {
                hashMap.put("LD_LIBRARY_PATH", string4);
            }
        }
        return hashMap;
    }

    private void initializeSystemEnvironmentVariables() throws IOException {
    }

    private class ProcessOutputReader
    implements Runnable {
        Process p;

        ProcessOutputReader(Process process) {
            this.p = process;
        }

        public void run() {
            Object object;
            try {
                object = new byte[1000];
                InputStream inputStream = this.p.getInputStream();
                int n = inputStream.read((byte[])object);
                while (n > 0) {
                    n = inputStream.read((byte[])object);
                }
                inputStream = this.p.getErrorStream();
                n = inputStream.read((byte[])object);
                while (n != -1) {
                    n = inputStream.read((byte[])object);
                }
            }
            catch (IOException iOException) {
                PHPDebugPlugin.log(iOException);
            }
            if (PHPExecutableDebuggerInitializer.this.launch != null && PHPExecutableDebuggerInitializer.this.launch.getDebugTarget() == null) {
                object = PHPExecutableDebuggerInitializer.this.launch.getLaunchConfiguration().getName();
                boolean bl = "run".equals(PHPExecutableDebuggerInitializer.this.launch.getLaunchMode());
                String string = null;
                string = bl ? MessageFormat.format(PHPDebugCoreMessages.Debugger_Error_Message_3, object) : MessageFormat.format(PHPDebugCoreMessages.Debugger_Error_Message_2, object);
                final String string2 = string;
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)PHPDebugCoreMessages.Debugger_Error, (String)string2);
                        DebugPlugin.getDefault().getLaunchManager().removeLaunch(PHPExecutableDebuggerInitializer.this.launch);
                    }
                });
            }
        }
    }
}

