/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.hovers;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.php.internal.core.documentModel.parser.regions.PhpScriptRegion;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpStackFrame;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpVariable;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.ui.editor.hover.AbstractPHPTextHover;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.w3c.dom.Node;

public class XDebugTextHover
extends AbstractPHPTextHover {
    public String getHoverInfo(ITextViewer iTextViewer, IRegion iRegion) {
        if (iRegion == null || iTextViewer == null || iTextViewer.getDocument() == null) {
            return null;
        }
        IAdaptable iAdaptable = DebugUITools.getDebugContext();
        if (iAdaptable instanceof DBGpStackFrame) {
            DBGpStackFrame dBGpStackFrame = (DBGpStackFrame)iAdaptable;
            int n = iRegion.getOffset();
            IStructuredDocumentRegion iStructuredDocumentRegion = ((IStructuredDocument)iTextViewer.getDocument()).getRegionAtCharacterOffset(n);
            ITextRegion iTextRegion = null;
            if (iStructuredDocumentRegion != null) {
                iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n);
            }
            IStructuredDocumentRegion iStructuredDocumentRegion2 = iStructuredDocumentRegion;
            if (iTextRegion instanceof ITextRegionContainer) {
                iStructuredDocumentRegion2 = (ITextRegionContainer)iTextRegion;
                iTextRegion = iStructuredDocumentRegion2.getRegionAtCharacterOffset(n);
            }
            if (iTextRegion.getType() == "PHP_CONTENT") {
                String string;
                PhpScriptRegion phpScriptRegion = (PhpScriptRegion)iTextRegion;
                try {
                    iTextRegion = phpScriptRegion.getPhpToken(n - iStructuredDocumentRegion2.getStartOffset() - iTextRegion.getStart());
                }
                catch (BadLocationException badLocationException) {
                    iTextRegion = null;
                }
                if (iTextRegion != null && (string = iTextRegion.getType()) == "PHP_VARIABLE") {
                    String string2 = null;
                    try {
                        string2 = iTextViewer.getDocument().get(iRegion.getOffset(), iRegion.getLength());
                        if (string2 != null) {
                            string2 = string2.trim();
                            string2 = "<B>" + string2 + " = </B>" + this.getPropertyValue(dBGpStackFrame, string2);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Logger.logException("Error retrieving the value\n", badLocationException);
                    }
                    return string2;
                }
            }
        }
        return null;
    }

    protected String getValueByEval(DBGpTarget dBGpTarget, String string) {
        String string2 = null;
        Node node = dBGpTarget.eval(string);
        DBGpVariable dBGpVariable = new DBGpVariable(dBGpTarget, node, "-2");
        IValue iValue = null;
        try {
            iValue = dBGpVariable.getValue();
            if (iValue != null) {
                string2 = iValue.getValueString();
            }
        }
        catch (DebugException debugException) {}
        if (string2 != null && string2.length() == 0) {
            string2 = "Empty";
            return string2;
        }
        if (string2 != null) {
            this.tab.matcher(string2).replaceAll("    ");
        }
        return string2;
    }

    protected String getPropertyValue(DBGpStackFrame dBGpStackFrame, String string) {
        String string2 = null;
        DBGpTarget dBGpTarget = (DBGpTarget)dBGpStackFrame.getDebugTarget();
        Node node = dBGpTarget.getProperty(string, dBGpStackFrame.getStackLevel(), 0);
        DBGpVariable dBGpVariable = new DBGpVariable(dBGpTarget, node, "-2");
        IValue iValue = null;
        try {
            iValue = dBGpVariable.getValue();
            if (iValue != null) {
                string2 = iValue.getValueString();
            }
        }
        catch (DebugException debugException) {}
        if (string2 != null && string2.length() == 0) {
            string2 = "Empty";
            return string2;
        }
        if (string2 != null) {
            this.tab.matcher(string2).replaceAll("    ");
        }
        return string2;
    }
}

