/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.format.FormatPreferencesSupport;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.autoEdit.IndentLineAutoEditStrategy;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class TabAutoEditStrategy
implements IAutoEditStrategy {
    private int lastIndentSize = 0;
    private String lastIndentString = "";
    private StringBuffer helpBuffer = new StringBuffer();
    private IStructuredDocument document;
    private DocumentCommand command;
    private IndentLineAutoEditStrategy autoIndentLineStrategy = new IndentLineAutoEditStrategy();

    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        if (documentCommand.text != null && documentCommand.text.equals("\t")) {
            documentCommand.text = "";
            this.command = documentCommand;
            this.document = (IStructuredDocument)iDocument;
            boolean bl = PHPUiPlugin.getDefault().getPreferenceStore().getBoolean("smart_tab");
            if (!bl) {
                this.applyTabRule();
                return;
            }
            if (documentCommand.length != 0) {
                return;
            }
            this.tabPressed();
        }
    }

    private void tabPressed() {
        try {
            boolean bl;
            int n = this.document.getLineOfOffset(this.command.offset);
            IRegion iRegion = this.document.getLineInformation(n);
            int n2 = this.document.getLineOffset(n);
            int n3 = 0;
            int n4 = 0;
            boolean bl2 = bl = this.command.offset == n2;
            if (bl || !this.hasTextBeforeCaret(iRegion)) {
                n3 = this.calculateOriginalIndentSize(n, iRegion);
                n4 = this.calculateAutoIndentSize(n);
                if (n4 == -1) {
                    this.applyTabRule();
                    return;
                }
                boolean bl3 = this.hasEmptyCharAfterCaret(n, n2);
                if (n4 >= n3) {
                    this.applyIndent(n, n2);
                    if (n4 == n3 && !bl3) {
                        this.applyTabRule();
                    }
                } else if (this.hasEmptyCharAfterCaret(n, n2)) {
                    this.applyIndent(n, n2);
                } else {
                    this.applyTabRule();
                }
            } else {
                this.applyTabRule();
            }
        }
        catch (BadLocationException badLocationException) {
            Logger.logException(badLocationException);
        }
    }

    private boolean hasTextBeforeCaret(IRegion iRegion) throws BadLocationException {
        int n = iRegion.getLength();
        int n2 = iRegion.getOffset();
        String string = this.document.get(n2, n);
        int n3 = this.command.offset - n2;
        int n4 = 0;
        while (n4 < n3) {
            if (string.charAt(n4) != ' ' && string.charAt(n4) != '\t') {
                return true;
            }
            ++n4;
        }
        return false;
    }

    private boolean hasEmptyCharAfterCaret(int n, int n2) throws BadLocationException {
        boolean bl = false;
        IRegion iRegion = this.document.getLineInformation(n);
        int n3 = iRegion.getLength();
        if (n3 == 0) {
            return false;
        }
        int n4 = this.command.offset - n2;
        String string = this.document.get(n2, n3);
        if (n4 == string.length()) {
            return false;
        }
        char c = string.charAt(n4);
        if (c == ' ' || c == '\t') {
            bl = true;
        }
        return bl;
    }

    private int calculateOriginalIndentSize(int n, IRegion iRegion) throws BadLocationException {
        int n2 = iRegion.getOffset();
        int n3 = iRegion.getLength();
        String string = this.document.get(n2, n3);
        int n4 = 0;
        int n5 = 0;
        while (n5 < string.length()) {
            switch (string.charAt(n5)) {
                default: {
                    n5 = string.length();
                    break;
                }
                case ' ': {
                    ++n4;
                    break;
                }
                case '\t': {
                    n4 += 4;
                }
            }
            ++n5;
        }
        return n4;
    }

    private void applyIndent(int n, int n2) throws BadLocationException {
        this.command.offset = n2;
        this.command.length = this.getCurrentIndentLength(n);
        this.command.text = this.helpBuffer.toString();
    }

    private int getCurrentIndentLength(int n) throws BadLocationException {
        IRegion iRegion = this.document.getLineInformation(n);
        int n2 = iRegion.getOffset();
        int n3 = iRegion.getLength();
        String string = this.document.get(n2, n3);
        int n4 = 0;
        while (n4 < n3 && (string.charAt(n4) == ' ' || string.charAt(n4) == '\t')) {
            ++n4;
        }
        return n4;
    }

    private int calculateAutoIndentSize(int n) {
        this.helpBuffer.setLength(0);
        try {
            this.autoIndentLineStrategy.placeMatchingBlanks(this.document, this.helpBuffer, n, this.command);
        }
        catch (Exception exception) {
            Logger.logException(exception);
            return -1;
        }
        int n2 = 0;
        String string = this.helpBuffer.toString();
        int n3 = 0;
        while (n3 < string.length()) {
            switch (string.charAt(n3)) {
                case ' ': {
                    ++n2;
                    break;
                }
                case '\t': {
                    n2 += 4;
                }
            }
            ++n3;
        }
        return n2;
    }

    private void applyTabRule() {
        char c = FormatPreferencesSupport.getInstance().getIndentationChar((IDocument)this.document);
        if (c == ' ') {
            int n = FormatPreferencesSupport.getInstance().getIndentationSize((IDocument)this.document);
            this.command.text = String.valueOf(this.command.text) + this.getIndentationString(n);
        } else {
            this.command.text = String.valueOf(this.command.text) + "\t";
        }
    }

    private String getIndentationString(int n) {
        if (n == this.lastIndentSize) {
            return this.lastIndentString;
        }
        this.lastIndentSize = n;
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < cArray.length) {
            cArray[n2] = 32;
            ++n2;
        }
        this.lastIndentString = String.valueOf(cArray);
        return this.lastIndentString;
    }
}

