/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.folding.projection;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.folding.projection.ProjectionAnnotationModelChanges;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProjectionViewerInformation {
    private ProjectionAnnotationModel fProjectionAnnotationModel;
    private IDocument fDocument;
    private IDocumentListener fDocumentListener;
    private boolean fIsDocumentChanging = false;
    private List<ProjectionAnnotationModelChanges> fQueuedAnnotationChanges;

    public ProjectionViewerInformation(ProjectionViewer projectionViewer) {
        this.fDocument = projectionViewer.getDocument();
        this.fProjectionAnnotationModel = projectionViewer.getProjectionAnnotationModel();
    }

    IDocument getDocument() {
        return this.fDocument;
    }

    private List<ProjectionAnnotationModelChanges> getQueuedAnnotationChanges() {
        if (this.fQueuedAnnotationChanges == null) {
            this.fQueuedAnnotationChanges = new LinkedList<ProjectionAnnotationModelChanges>();
        }
        return this.fQueuedAnnotationChanges;
    }

    void setIsDocumentChanging(boolean bl) {
        this.fIsDocumentChanging = bl;
    }

    boolean isDocumentChanging() {
        return this.fIsDocumentChanging;
    }

    void applyAnnotationModelChanges() {
        List<ProjectionAnnotationModelChanges> list = this.getQueuedAnnotationChanges();
        while (!list.isEmpty()) {
            ProjectionAnnotationModelChanges projectionAnnotationModelChanges = list.remove(0);
            try {
                this.fProjectionAnnotationModel.modifyAnnotations(projectionAnnotationModelChanges.getDeletions(), projectionAnnotationModelChanges.getAdditions(), null);
                Map map = projectionAnnotationModelChanges.getModifications();
                for (Map.Entry entry : map.entrySet()) {
                    Map.Entry entry2 = entry;
                    Position position = this.fProjectionAnnotationModel.getPosition((Annotation)entry2.getKey());
                    if (position.equals(entry2.getValue())) continue;
                    this.fProjectionAnnotationModel.modifyAnnotationPosition((Annotation)entry2.getKey(), (Position)entry2.getValue());
                }
            }
            catch (RuntimeException runtimeException) {
                Logger.log(202, runtimeException.getMessage(), runtimeException);
            }
        }
    }

    boolean hasChangesQueued() {
        return !this.getQueuedAnnotationChanges().isEmpty();
    }

    public void queueAnnotationModelChanges(ProjectionAnnotationModelChanges projectionAnnotationModelChanges) {
        this.getQueuedAnnotationChanges().add(projectionAnnotationModelChanges);
        if (!this.isDocumentChanging()) {
            this.applyAnnotationModelChanges();
        }
    }

    public void initialize() {
        if (this.fDocumentListener == null) {
            this.fDocumentListener = new DocumentListener(this);
        }
        this.getDocument().addDocumentListener(this.fDocumentListener);
    }

    public void dispose() {
        if (this.fDocumentListener != null) {
            this.getDocument().removeDocumentListener(this.fDocumentListener);
        }
        if (this.fQueuedAnnotationChanges != null) {
            this.fQueuedAnnotationChanges.clear();
            this.fQueuedAnnotationChanges = null;
        }
    }

    private static class DocumentListener
    implements IDocumentListener {
        private ProjectionViewerInformation fInfo;

        public DocumentListener(ProjectionViewerInformation projectionViewerInformation) {
            this.fInfo = projectionViewerInformation;
        }

        public void documentAboutToBeChanged(DocumentEvent documentEvent) {
            IDocument iDocument = documentEvent.getDocument();
            if (this.fInfo.getDocument() == iDocument) {
                this.fInfo.setIsDocumentChanging(true);
            }
        }

        public void documentChanged(DocumentEvent documentEvent) {
            IDocument iDocument = documentEvent.getDocument();
            if (iDocument instanceof IDocumentExtension && this.fInfo.getDocument() == iDocument) {
                ((IDocumentExtension)iDocument).registerPostNotificationReplace((IDocumentListener)this, (IDocumentExtension.IReplace)new PostDocumentChangedListener(this.fInfo));
            }
        }
    }

    private static class PostDocumentChangedListener
    implements IDocumentExtension.IReplace {
        private ProjectionViewerInformation fInfo;

        public PostDocumentChangedListener(ProjectionViewerInformation projectionViewerInformation) {
            this.fInfo = projectionViewerInformation;
        }

        public void perform(IDocument iDocument, IDocumentListener iDocumentListener) {
            this.fInfo.applyAnnotationModelChanges();
            this.fInfo.setIsDocumentChanging(false);
        }
    }
}

