/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.creation.ui.task;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.axis.consumption.core.AxisConsumptionCoreMessages;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.jst.ws.internal.axis.consumption.ui.AxisConsumptionUIMessages;
import org.eclipse.jst.ws.internal.axis.consumption.ui.util.PlatformUtils;
import org.eclipse.jst.ws.internal.axis.consumption.ui.util.WSDLUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.eclipse.BaseEclipseEnvironment;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.eclipse.wst.ws.internal.wsrt.WebServiceInfo;

public class BackupSkelImplCommand
extends AbstractDataModelOperation {
    private final String IMPL = "Impl";
    private final String DOT = ".";
    private final String BAK_EXT = "bak";
    private final String JAVA = "java";
    private WebServicesParser webServicesParser;
    private JavaWSDLParameter javaWSDLParam;
    private WebServiceInfo webServiceInfo;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment environment = this.getEnvironment();
        if (this.javaWSDLParam == null) {
            IStatus status = StatusUtils.errorStatus((String)AxisConsumptionCoreMessages.MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET);
            environment.getStatusHandler().reportError(status);
            return status;
        }
        IStatus status = Status.OK_STATUS;
        Definition definition = null;
        String wsdlURL = this.javaWSDLParam.getInputWsdlLocation();
        try {
            URL url = new URL(wsdlURL);
            definition = this.webServicesParser.getWSDLDefinition(url.toString());
        }
        catch (MalformedURLException malformedURLException) {
            wsdlURL = PlatformUtils.getFileURLFromPath((IPath)new Path(wsdlURL));
            definition = this.webServicesParser.getWSDLDefinition(wsdlURL);
        }
        Service service = null;
        Port port = null;
        ArrayList<String> implURLList = new ArrayList<String>();
        if (definition != null) {
            block25: {
                String implURLString;
                StringBuffer beanName = new StringBuffer();
                String beanPackageName = null;
                HashMap mappings = this.javaWSDLParam.getMappings();
                if (mappings != null) {
                    String targetNamespace = definition.getTargetNamespace();
                    beanPackageName = (String)mappings.get(targetNamespace);
                }
                if (beanPackageName == null) {
                    beanPackageName = WSDLUtils.getPackageName((Definition)definition);
                }
                this.javaWSDLParam.setBeanPackage(beanPackageName);
                beanName.append(beanPackageName);
                beanName.append(".");
                service = (Service)definition.getServices().values().iterator().next();
                port = (Port)service.getPorts().values().iterator().next();
                Binding binding = port.getBinding();
                String qName = binding.getQName().getLocalPart();
                beanName.append(qName.substring(0, 1).toUpperCase());
                beanName.append(qName.substring(1));
                beanName.append("Impl");
                String beanNameString = beanName.toString();
                this.javaWSDLParam.setBeanName(beanNameString);
                FileInputStream finStream = null;
                ResourceContext context = ((BaseEclipseEnvironment)environment).getResourceContext();
                IStatusHandler statusHandler = environment.getStatusHandler();
                String beanNamePathString = beanNameString.replace('.', '/');
                IPath skelImplPath = new Path(this.javaWSDLParam.getJavaOutput()).append((IPath)new Path(beanNamePathString)).addFileExtension("java");
                try {
                    implURLString = skelImplPath.toFile().toURL().toString();
                }
                catch (MalformedURLException malformedURLException) {
                    implURLString = PlatformUtils.getFileURLFromPath((IPath)skelImplPath);
                }
                implURLList.add(implURLString);
                if (skelImplPath.toFile().exists()) {
                    IPath targetPath = skelImplPath.addFileExtension("bak");
                    try {
                        try {
                            finStream = new FileInputStream(skelImplPath.toString());
                            if (finStream != null) {
                                FileResourceUtils.createFileAtLocation((ResourceContext)context, (IPath)targetPath.makeAbsolute(), (InputStream)finStream, (IProgressMonitor)monitor, (IStatusHandler)statusHandler);
                                finStream.close();
                            }
                        }
                        catch (Exception e) {
                            status = StatusUtils.errorStatus((String)NLS.bind((String)AxisConsumptionCoreMessages.MSG_ERROR_MOVE_RESOURCE, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
                            environment.getStatusHandler().reportError(status);
                            try {
                                if (finStream != null) {
                                    finStream.close();
                                }
                                break block25;
                            }
                            catch (IOException iOException) {}
                            break block25;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (finStream != null) {
                                finStream.close();
                            }
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        if (finStream != null) {
                            finStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            String[] implURLArray = new String[implURLList.size()];
            this.webServiceInfo.setImplURLs(implURLList.toArray(implURLArray));
        } else {
            status = StatusUtils.errorStatus((String)NLS.bind((String)AxisConsumptionUIMessages.MSG_ERROR_WSDL_NO_DEFINITION, (Object[])new String[]{wsdlURL}));
            environment.getStatusHandler().reportError(status);
        }
        return status;
    }

    public void setJavaWSDLParam(JavaWSDLParameter javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    public void setWebServicesParser(WebServicesParser webServicesParser) {
        this.webServicesParser = webServicesParser;
    }

    public void setWebServiceInfo(WebServiceInfo webServiceInfo) {
        this.webServiceInfo = webServiceInfo;
    }
}

