/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.MemoryView;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.MonitorMemoryBlockDialog;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class AddMemoryBlockAction
extends Action
implements IDebugContextListener,
IDebugEventSetListener {
    protected IAdaptable fCurrentContext = null;
    protected IMemoryBlock fLastMemoryBlock;
    private boolean fAddDefaultRenderings = true;
    protected IMemoryRenderingSite fSite;

    public AddMemoryBlockAction(IMemoryRenderingSite site) {
        this.initialize(site);
    }

    AddMemoryBlockAction(IMemoryRenderingSite site, boolean addDefaultRenderings) {
        this.initialize(site);
        this.fAddDefaultRenderings = addDefaultRenderings;
    }

    private void initialize(IMemoryRenderingSite site) {
        this.setText(DebugUIMessages.AddMemoryBlockAction_title);
        this.doInitialization(site);
    }

    public AddMemoryBlockAction(String text, int style, IMemoryRenderingSite site) {
        super(text, style);
        this.doInitialization(site);
    }

    private void doInitialization(IMemoryRenderingSite site) {
        this.fSite = site;
        this.setToolTipText(DebugUIMessages.AddMemoryBlockAction_tooltip);
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_MONITOR_EXPRESSION"));
        this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_MONITOR_EXPRESSION"));
        this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_MONITOR_EXPRESSION"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.addMemoryMonitorAction_context");
        DebugUITools.getDebugContextManager().getContextService(site.getSite().getWorkbenchWindow()).addDebugContextListener(this);
        this.fCurrentContext = DebugUITools.getDebugContext();
        this.updateAction(this.fCurrentContext);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void run() {
        boolean exit = false;
        String prefillExp = null;
        String prefillLength = null;
        while (!exit) {
            String input;
            exit = true;
            IAdaptable elem = DebugUITools.getDebugContext();
            IMemoryBlockRetrieval retrieval = MemoryViewUtil.getMemoryBlockRetrieval(elem);
            if (retrieval == null) {
                return;
            }
            Shell shell = DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
            MonitorMemoryBlockDialog dialog = new MonitorMemoryBlockDialog(shell, retrieval, prefillExp, prefillLength);
            dialog.open();
            int returnCode = dialog.getReturnCode();
            if (returnCode == 1) {
                return;
            }
            prefillExp = input = dialog.getExpression();
            prefillLength = dialog.getLength();
            ArrayList<String> expressions = new ArrayList<String>();
            if (input.length() == 0) {
                expressions.add("");
            } else {
                StringTokenizer tokenizer = new StringTokenizer(input, ",");
                while (tokenizer.hasMoreTokens()) {
                    expressions.add(tokenizer.nextToken());
                }
            }
            final String[] expressionsArray = expressions.toArray(new String[expressions.size()]);
            final boolean finalExit = exit = true;
            final IAdaptable finalElement = elem;
            final IMemoryBlockRetrieval finalRetrieval = retrieval;
            final MonitorMemoryBlockDialog finalDialog = dialog;
            Job job = new Job("Add Memory Block"){

                protected IStatus run(IProgressMonitor monitor) {
                    AddMemoryBlockAction.this.addMemoryBlocks(finalExit, finalElement, finalRetrieval, finalDialog, expressionsArray);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    private boolean addMemoryBlocks(boolean exit, Object elem, IMemoryBlockRetrieval standardMemRetrieval, MonitorMemoryBlockDialog dialog, String[] expressionsArray) {
        int i = 0;
        while (i < expressionsArray.length) {
            String expression = expressionsArray[i].trim();
            try {
                if (standardMemRetrieval instanceof IMemoryBlockRetrievalExtension) {
                    IMemoryBlockRetrievalExtension memRetrieval = (IMemoryBlockRetrievalExtension)standardMemRetrieval;
                    IMemoryBlockExtension memBlock = memRetrieval.getExtendedMemoryBlock(expression, elem);
                    if (memBlock != null) {
                        this.fLastMemoryBlock = memBlock;
                        IMemoryBlock[] memArray = new IMemoryBlock[]{memBlock};
                        MemoryViewUtil.getMemoryBlockManager().addMemoryBlocks(memArray);
                        if (this.fAddDefaultRenderings) {
                            this.addDefaultRenderings((IMemoryBlock)memBlock);
                        }
                    } else {
                        MemoryViewUtil.openError(DebugUIMessages.AddMemoryBlockAction_title, DebugUIMessages.AddMemoryBlockAction_noMemoryBlock, null);
                        exit = false;
                    }
                } else {
                    String hexPrefix;
                    if ((expression = expression.toUpperCase()).startsWith(hexPrefix = "0X")) {
                        expression = expression.substring(hexPrefix.length());
                    }
                    BigInteger address = new BigInteger(expression, 16);
                    long longAddress = address.longValue();
                    String strLength = dialog.getLength();
                    long length = Long.parseLong(strLength);
                    if (length <= 0L) {
                        String message = String.valueOf(DebugUIMessages.AddMemoryBlockAction_failed) + "\n" + DebugUIMessages.AddMemoryBlockAction_input_invalid;
                        MemoryViewUtil.openError(DebugUIMessages.AddMemoryBlockAction_title, message, null);
                        exit = false;
                    } else {
                        IMemoryBlock memBlock = standardMemRetrieval.getMemoryBlock(longAddress, length);
                        if (memBlock instanceof IMemoryBlockExtension) {
                            Status status = new Status(2, DebugUIPlugin.getUniqueIdentifier(), 0, "IMemoryBlockRetrieval returns IMemoryBlockExtension.  This may result in unexpected behavior.", null);
                            DebugUIPlugin.log((IStatus)status);
                        }
                        if (memBlock != null) {
                            this.fLastMemoryBlock = memBlock;
                            IMemoryBlock[] memArray = new IMemoryBlock[]{memBlock};
                            MemoryViewUtil.getMemoryBlockManager().addMemoryBlocks(memArray);
                            if (this.fAddDefaultRenderings) {
                                this.addDefaultRenderings(memBlock);
                            }
                        } else {
                            MemoryViewUtil.openError(DebugUIMessages.AddMemoryBlockAction_title, DebugUIMessages.AddMemoryBlockAction_noMemoryBlock, null);
                            exit = false;
                        }
                    }
                }
            }
            catch (DebugException e1) {
                MemoryViewUtil.openError(DebugUIMessages.AddMemoryBlockAction_title, DebugUIMessages.AddMemoryBlockAction_failed, (Exception)((Object)e1));
                exit = false;
            }
            catch (NumberFormatException numberFormatException) {
                String message = String.valueOf(DebugUIMessages.AddMemoryBlockAction_failed) + "\n" + DebugUIMessages.AddMemoryBlockAction_input_invalid;
                MemoryViewUtil.openError(DebugUIMessages.AddMemoryBlockAction_title, message, null);
                exit = false;
            }
            ++i;
        }
        return exit;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            this.handleDebugEvent(events[i]);
            ++i;
        }
    }

    private void handleDebugEvent(DebugEvent event) {
        Object src = event.getSource();
        IDebugTarget srcDT = null;
        IDebugTarget selectionDT = null;
        if (event.getKind() == 8) {
            if (src instanceof ITerminate && src instanceof IDebugElement) {
                srcDT = ((IDebugElement)src).getDebugTarget();
            }
            if (this.fCurrentContext instanceof IDebugElement) {
                selectionDT = ((IDebugElement)this.fCurrentContext).getDebugTarget();
            }
            if (srcDT == selectionDT) {
                this.setEnabled(false);
            }
        }
    }

    public IMemoryBlock getLastMemoryBlock() {
        return this.fLastMemoryBlock;
    }

    protected void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        DebugUITools.getDebugContextManager().getContextService(this.fSite.getSite().getWorkbenchWindow()).removeDebugContextListener(this);
    }

    private void addDefaultRenderings(IMemoryBlock memoryBlock) {
        IMemoryRenderingType primaryType = DebugUITools.getMemoryRenderingManager().getPrimaryRenderingType(memoryBlock);
        IMemoryRenderingType[] renderingTypes = DebugUITools.getMemoryRenderingManager().getDefaultRenderingTypes(memoryBlock);
        try {
            if (primaryType != null) {
                this.createRenderingInContainer(memoryBlock, primaryType, "org.eclipse.debug.ui.MemoryView.RenderingViewPane.1");
            } else if (renderingTypes.length > 0) {
                primaryType = renderingTypes[0];
                this.createRenderingInContainer(memoryBlock, renderingTypes[0], "org.eclipse.debug.ui.MemoryView.RenderingViewPane.1");
            }
        }
        catch (CoreException e1) {
            DebugUIPlugin.log(e1);
        }
        int i = 0;
        while (i < renderingTypes.length) {
            try {
                boolean create = true;
                if (primaryType != null && primaryType.getId().equals(renderingTypes[i].getId())) {
                    create = false;
                }
                if (create) {
                    this.createRenderingInContainer(memoryBlock, renderingTypes[i], "org.eclipse.debug.ui.MemoryView.RenderingViewPane.2");
                }
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
            ++i;
        }
    }

    private void createRenderingInContainer(IMemoryBlock memoryBlock, IMemoryRenderingType primaryType, String paneId) throws CoreException {
        IMemoryRendering rendering = primaryType.createRendering();
        IMemoryRenderingContainer container = this.fSite.getContainer(paneId);
        rendering.init(container, memoryBlock);
        container.addMemoryRendering(rendering);
    }

    protected MemoryView getMemoryView() {
        if (this.fSite instanceof MemoryView) {
            return (MemoryView)this.fSite;
        }
        return null;
    }

    protected void updateAction(final Object debugContext) {
        Job job = new Job("Update Add Memory Block Action"){

            protected IStatus run(IProgressMonitor monitor) {
                AddMemoryBlockAction.this.setEnabled(MemoryViewUtil.isValidContext(debugContext));
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void debugContextChanged(DebugContextEvent event) {
        if ((event.getFlags() & 1) > 0) {
            IAdaptable context = DebugUITools.getDebugContext();
            this.updateAction(context);
            this.fCurrentContext = context;
        }
    }
}

